/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.RandomUtils;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.chaos.actions.BatchRestartRsAction;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.util.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollingBatchRestartRsAction
extends BatchRestartRsAction {
    private static final Logger LOG = LoggerFactory.getLogger(RollingBatchRestartRsAction.class);
    protected int maxDeadServers;

    public RollingBatchRestartRsAction(long sleepTime, float ratio) {
        this(sleepTime, ratio, 5);
    }

    public RollingBatchRestartRsAction(long sleepTime, float ratio, int maxDeadServers) {
        super(sleepTime, ratio);
        this.maxDeadServers = maxDeadServers;
    }

    public RollingBatchRestartRsAction(long sleepTime, float ratio, int maxDeadServers, boolean skipMetaRS) {
        this(sleepTime, ratio, maxDeadServers);
        this.skipMetaRS = skipMetaRS;
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        this.getLogger().info("Performing action: Rolling batch restarting {}% of region servers", (Object)((int)(this.ratio * 100.0f)));
        List<ServerName> selectedServers = this.selectServers();
        LinkedList<ServerName> serversToBeKilled = new LinkedList<ServerName>(selectedServers);
        LinkedList<ServerName> deadServers = new LinkedList<ServerName>();
        while (!(serversToBeKilled.isEmpty() && deadServers.isEmpty() || this.context.isStopping())) {
            KillOrStart action = serversToBeKilled.isEmpty() ? KillOrStart.START : (deadServers.isEmpty() ? KillOrStart.KILL : (deadServers.size() >= this.maxDeadServers ? KillOrStart.START : (RandomUtils.nextBoolean() ? KillOrStart.KILL : KillOrStart.START)));
            switch (action) {
                case KILL: {
                    ServerName server = (ServerName)serversToBeKilled.remove();
                    try {
                        this.killRs(server);
                    }
                    catch (Shell.ExitCodeException e) {
                        this.getLogger().info("Problem killing but presume successful; code={}", (Object)e.getExitCode(), (Object)e);
                    }
                    deadServers.add(server);
                    break;
                }
                case START: {
                    ServerName server = (ServerName)Objects.requireNonNull(deadServers.peek());
                    try {
                        this.startRs(server);
                        deadServers.remove(server);
                        break;
                    }
                    catch (Shell.ExitCodeException e) {
                        Collections.shuffle(deadServers);
                        this.getLogger().info("Problem starting {}, will retry; code={}", new Object[]{server, e.getExitCode(), e});
                    }
                }
            }
            this.sleep(RandomUtils.nextInt((int)0, (int)((int)this.sleepTime)));
        }
    }

    protected List<ServerName> selectServers() throws IOException {
        return PolicyBasedChaosMonkey.selectRandomItems(this.getCurrentServers(), this.ratio);
    }

    public static void main(String[] args) throws Exception {
        RollingBatchRestartRsAction action = new RollingBatchRestartRsAction(1L, 1.0f){
            private int invocations = 0;

            @Override
            protected ServerName[] getCurrentServers() {
                int count = 4;
                ArrayList<ServerName> serverNames = new ArrayList<ServerName>(4);
                for (int i = 0; i < 4; ++i) {
                    serverNames.add(ServerName.valueOf((String)(i + ".example.org"), (int)i, (long)i));
                }
                return serverNames.toArray(new ServerName[0]);
            }

            @Override
            protected void killRs(ServerName server) throws IOException {
                LOG.info("Killed {}", (Object)server);
                if (this.invocations++ % 3 == 0) {
                    throw new Shell.ExitCodeException(-1, "Failed");
                }
            }

            @Override
            protected void startRs(ServerName server) throws IOException {
                LOG.info("Started {}", (Object)server);
                if (this.invocations++ % 3 == 0) {
                    throw new Shell.ExitCodeException(-1, "Failed");
                }
            }
        };
        action.perform();
    }

    static enum KillOrStart {
        KILL,
        START;

    }
}

