/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.util.Random;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.Admin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TruncateTableAction
extends Action {
    private static final Logger LOG = LoggerFactory.getLogger(TruncateTableAction.class);
    private final TableName tableName;
    private final Random random;

    public TruncateTableAction(String tableName) {
        this.tableName = TableName.valueOf((String)tableName);
        this.random = new Random();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws Exception {
        IntegrationTestingUtility util = this.context.getHBaseIntegrationTestingUtility();
        Admin admin = util.getAdmin();
        if (this.context.isStopping()) {
            return;
        }
        boolean preserveSplits = this.random.nextBoolean();
        this.getLogger().info("Performing action: Truncate table {} preserve splits {}", (Object)this.tableName.getNameAsString(), (Object)preserveSplits);
        admin.truncateTable(this.tableName, preserveSplits);
    }
}

