/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.policies;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import org.apache.hadoop.hbase.DaemonThreadFactory;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.monkies.PolicyBasedChaosMonkey;
import org.apache.hadoop.hbase.chaos.policies.PeriodicPolicy;
import org.apache.hadoop.hbase.chaos.policies.Policy;
import org.apache.hadoop.util.StringUtils;

public class TwoConcurrentActionPolicy
extends PeriodicPolicy {
    private final Action[] actionsOne;
    private final Action[] actionsTwo;
    private final ExecutorService executor;

    public TwoConcurrentActionPolicy(long sleepTime, Action[] actionsOne, Action[] actionsTwo) {
        super(sleepTime);
        this.actionsOne = actionsOne;
        this.actionsTwo = actionsTwo;
        this.executor = Executors.newFixedThreadPool(2, (ThreadFactory)new DaemonThreadFactory("TwoConcurrentAction-"));
    }

    @Override
    protected void runOneIteration() {
        Action actionOne = PolicyBasedChaosMonkey.selectRandomItem(this.actionsOne);
        Action actionTwo = PolicyBasedChaosMonkey.selectRandomItem(this.actionsTwo);
        Future<?> fOne = this.executor.submit(new ActionRunner(actionOne));
        Future<?> fTwo = this.executor.submit(new ActionRunner(actionTwo));
        try {
            fOne.get();
            fTwo.get();
        }
        catch (InterruptedException e) {
            LOG.warn("Exception occurred during performing action: " + StringUtils.stringifyException((Throwable)e));
        }
        catch (ExecutionException ex) {
            LOG.warn("Exception occurred during performing action: " + StringUtils.stringifyException((Throwable)ex));
        }
    }

    @Override
    public void init(Policy.PolicyContext context) throws Exception {
        super.init(context);
        for (Action a : this.actionsOne) {
            a.init(context);
        }
        for (Action a : this.actionsTwo) {
            a.init(context);
        }
    }

    private static class ActionRunner
    implements Runnable {
        private final Action action;

        public ActionRunner(Action action) {
            this.action = action;
        }

        @Override
        public void run() {
            try {
                this.action.perform();
            }
            catch (Exception ex) {
                Policy.LOG.warn("Exception occurred during performing action: " + StringUtils.stringifyException((Throwable)ex));
            }
        }
    }
}

