/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeEncodingAction
extends Action {
    private final TableName tableName;
    private final Random random;
    private static final Logger LOG = LoggerFactory.getLogger(ChangeEncodingAction.class);

    public ChangeEncodingAction(TableName tableName) {
        this.tableName = tableName;
        this.random = new Random();
    }

    @Override
    protected Logger getLogger() {
        return LOG;
    }

    @Override
    public void perform() throws IOException {
        this.getLogger().debug("Performing action: Changing encodings on " + this.tableName);
        int[] possibleIds = new int[]{0, 2, 3, 4, 7};
        this.modifyAllTableColumns(this.tableName, (String columnName, ColumnFamilyDescriptorBuilder columnBuilder) -> {
            short id = (short)possibleIds[this.random.nextInt(possibleIds.length)];
            DataBlockEncoding encoding = DataBlockEncoding.getEncodingById((short)id);
            columnBuilder.setDataBlockEncoding(encoding);
            this.getLogger().debug("Set encoding of column family " + columnName + " to: " + encoding);
        });
    }
}

