/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ConnectionRule;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MiniClusterRule;
import org.apache.hadoop.hbase.ShellExecEndpointCoprocessor;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.client.AsyncAdmin;
import org.apache.hadoop.hbase.client.AsyncConnection;
import org.apache.hadoop.hbase.coprocessor.protobuf.generated.ShellExecEndpoint;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestShellExecEndpointCoprocessor {
    @ClassRule
    public static final HBaseClassTestRule testRule = HBaseClassTestRule.forClass(TestShellExecEndpointCoprocessor.class);
    @ClassRule
    public static final MiniClusterRule miniClusterRule = MiniClusterRule.newBuilder().setConfiguration(TestShellExecEndpointCoprocessor.createConfiguration()).build();
    @Rule
    public final ConnectionRule connectionRule = ConnectionRule.createAsyncConnectionRule(() -> ((MiniClusterRule)miniClusterRule).createAsyncConnection());

    @Test
    public void testShellExecUnspecified() {
        this.testShellExecForeground(b -> {});
    }

    @Test
    public void testShellExecForeground() {
        this.testShellExecForeground(b -> b.setAwaitResponse(true));
    }

    private void testShellExecForeground(Consumer<ShellExecEndpoint.ShellExecRequest.Builder> consumer) {
        AsyncConnection conn = this.connectionRule.getAsyncConnection();
        AsyncAdmin admin = conn.getAdmin();
        String command = "echo -n \"hello world\"";
        ShellExecEndpoint.ShellExecRequest.Builder builder = ShellExecEndpoint.ShellExecRequest.newBuilder().setCommand("echo -n \"hello world\"");
        consumer.accept(builder);
        ShellExecEndpoint.ShellExecResponse resp = (ShellExecEndpoint.ShellExecResponse)admin.coprocessorService(ShellExecEndpoint.ShellExecService::newStub, (stub, controller, callback) -> stub.shellExec(controller, builder.build(), callback)).join();
        Assert.assertEquals((long)0L, (long)resp.getExitCode());
        Assert.assertEquals((Object)"hello world", (Object)resp.getStdout());
    }

    @Test
    public void testShellExecBackground() throws IOException {
        AsyncConnection conn = this.connectionRule.getAsyncConnection();
        AsyncAdmin admin = conn.getAdmin();
        File testDataDir = TestShellExecEndpointCoprocessor.ensureTestDataDirExists(miniClusterRule.getTestingUtility());
        File testFile = new File(testDataDir, "shell_exec_background.txt");
        Assert.assertTrue((boolean)testFile.createNewFile());
        Assert.assertEquals((long)0L, (long)testFile.length());
        String command = "echo \"hello world\" >> " + testFile.getAbsolutePath();
        ShellExecEndpoint.ShellExecRequest req = ShellExecEndpoint.ShellExecRequest.newBuilder().setCommand(command).setAwaitResponse(false).build();
        ShellExecEndpoint.ShellExecResponse resp = (ShellExecEndpoint.ShellExecResponse)admin.coprocessorService(ShellExecEndpoint.ShellExecService::newStub, (stub, controller, callback) -> stub.shellExec(controller, req, callback)).join();
        Assert.assertFalse((String)"the response from a background task should have no exit code", (boolean)resp.hasExitCode());
        Assert.assertFalse((String)"the response from a background task should have no stdout", (boolean)resp.hasStdout());
        Assert.assertFalse((String)"the response from a background task should have no stderr", (boolean)resp.hasStderr());
        Waiter.waitFor((Configuration)conn.getConfiguration(), (long)5000L, () -> testFile.length() > 0L);
        String content = new String(Files.readAllBytes(testFile.toPath())).trim();
        Assert.assertEquals((Object)"hello world", (Object)content);
    }

    private static File ensureTestDataDirExists(HBaseTestingUtility testingUtility) throws IOException {
        Path testDataDir = Optional.of(testingUtility).map(HBaseCommonTestingUtility::getDataTestDir).map(Object::toString).map(x$0 -> Paths.get(x$0, new String[0])).orElseThrow(() -> new RuntimeException("Unable to locate temp directory path."));
        File testDataDirFile = Files.createDirectories(testDataDir, new FileAttribute[0]).toFile();
        Assert.assertTrue((boolean)testDataDirFile.exists());
        return testDataDirFile;
    }

    private static Configuration createConfiguration() {
        Configuration conf = HBaseConfiguration.create();
        conf.set("hbase.coprocessor.master.classes", ShellExecEndpointCoprocessor.class.getName());
        return conf;
    }
}

