/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={IntegrationTests.class})
public class IntegrationTestTableMapReduceUtil
implements Configurable,
Tool {
    private static IntegrationTestingUtility util;

    @BeforeClass
    public static void provisionCluster() throws Exception {
        if (null == util) {
            util = new IntegrationTestingUtility();
        }
    }

    @Before
    public void skipMiniCluster() {
        Assume.assumeTrue((String)"test requires a distributed cluster.", (boolean)util.isDistributedCluster());
    }

    @Test
    public void testAddDependencyJars() throws Exception {
        Job job = new Job();
        TableMapReduceUtil.addDependencyJars((Job)job);
        String tmpjars = job.getConfiguration().get("tmpjars");
        Assert.assertTrue((boolean)tmpjars.contains("hbase-common"));
        Assert.assertTrue((boolean)tmpjars.contains("hbase-protocol"));
        Assert.assertTrue((boolean)tmpjars.contains("hbase-client"));
        Assert.assertTrue((boolean)tmpjars.contains("hbase-hadoop-compat"));
        Assert.assertTrue((boolean)tmpjars.contains("hbase-server"));
        Assert.assertTrue((boolean)tmpjars.contains("zookeeper"));
        Assert.assertTrue((boolean)tmpjars.contains("netty"));
        Assert.assertTrue((boolean)tmpjars.contains("protobuf"));
        Assert.assertTrue((boolean)tmpjars.contains("guava"));
        Assert.assertTrue((boolean)tmpjars.contains("htrace"));
    }

    public int run(String[] args) throws Exception {
        IntegrationTestTableMapReduceUtil.provisionCluster();
        this.skipMiniCluster();
        this.testAddDependencyJars();
        return 0;
    }

    public void setConf(Configuration conf) {
        if (util != null) {
            throw new IllegalArgumentException("setConf not supported after the test has been initialized.");
        }
        util = new IntegrationTestingUtility(conf);
    }

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestTableMapReduceUtil(), (String[])args);
        System.exit(status);
    }
}

