/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.regionserver.FlushAllLargeStoresPolicy;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Random64;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileAsBinaryInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileAsBinaryOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.hbase.thirdparty.org.apache.commons.cli.GnuParser;
import org.apache.hbase.thirdparty.org.apache.commons.cli.HelpFormatter;
import org.apache.hbase.thirdparty.org.apache.commons.cli.Options;
import org.apache.hbase.thirdparty.org.apache.commons.cli.ParseException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestBigLinkedList
extends IntegrationTestBase {
    protected static final byte[] NO_KEY = new byte[1];
    protected static String TABLE_NAME_KEY = "IntegrationTestBigLinkedList.table";
    protected static String DEFAULT_TABLE_NAME = "IntegrationTestBigLinkedList";
    protected static byte[] FAMILY_NAME = Bytes.toBytes((String)"meta");
    private static byte[] BIG_FAMILY_NAME = Bytes.toBytes((String)"big");
    private static byte[] TINY_FAMILY_NAME = Bytes.toBytes((String)"tiny");
    protected static final byte[] COLUMN_PREV = Bytes.toBytes((String)"prev");
    protected static final byte[] COLUMN_CLIENT = Bytes.toBytes((String)"client");
    protected static final byte[] COLUMN_COUNT = Bytes.toBytes((String)"count");
    private static final String GENERATOR_NUM_ROWS_PER_MAP_KEY = "IntegrationTestBigLinkedList.generator.num_rows";
    private static final String GENERATOR_NUM_MAPPERS_KEY = "IntegrationTestBigLinkedList.generator.map.tasks";
    private static final String GENERATOR_WIDTH_KEY = "IntegrationTestBigLinkedList.generator.width";
    private static final String GENERATOR_WRAP_KEY = "IntegrationTestBigLinkedList.generator.wrap";
    private static final String CONCURRENT_WALKER_KEY = "IntegrationTestBigLinkedList.generator.concurrentwalkers";
    protected int NUM_SLAVES_BASE = 3;
    private static final int MISSING_ROWS_TO_LOG = 10;
    private static final int WIDTH_DEFAULT = 1000000;
    private static final int WRAP_DEFAULT = 25;
    private static final int ROWKEY_LENGTH = 16;
    private static final int CONCURRENT_WALKER_DEFAULT = 0;
    protected String toRun;
    protected String[] otherArgs;
    protected IntegrationTestingUtility util;

    static TableName getTableName(Configuration conf) {
        return TableName.valueOf((String)conf.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
    }

    private static CINode getCINode(Result result, CINode node) {
        node.key = Bytes.copy((byte[])result.getRow());
        node.prev = result.containsColumn(FAMILY_NAME, COLUMN_PREV) ? Bytes.copy((byte[])result.getValue(FAMILY_NAME, COLUMN_PREV)) : NO_KEY;
        node.count = result.containsColumn(FAMILY_NAME, COLUMN_COUNT) ? Bytes.toLong((byte[])result.getValue(FAMILY_NAME, COLUMN_COUNT)) : -1L;
        node.client = result.containsColumn(FAMILY_NAME, COLUMN_CLIENT) ? Bytes.toString((byte[])result.getValue(FAMILY_NAME, COLUMN_CLIENT)) : "";
        return node;
    }

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        boolean isDistributed = this.util.isDistributedCluster();
        this.util.initializeCluster(isDistributed ? 1 : this.NUM_SLAVES_BASE);
        if (!isDistributed) {
            this.util.startMiniMapReduceCluster();
        }
        this.setConf(this.util.getConfiguration());
    }

    @Override
    public void cleanUpCluster() throws Exception {
        super.cleanUpCluster();
        if (this.util.isDistributedCluster()) {
            this.util.shutdownMiniMapReduceCluster();
        }
    }

    private static boolean isMultiUnevenColumnFamilies(Configuration conf) {
        return conf.getBoolean("generator.multiple.columnfamilies", true);
    }

    @Test
    public void testContinuousIngest() throws IOException, Exception {
        Configuration conf = this.getTestingUtil(this.getConf()).getConfiguration();
        if (IntegrationTestBigLinkedList.isMultiUnevenColumnFamilies(this.getConf())) {
            conf.set("hbase.regionserver.flush.policy", FlushAllLargeStoresPolicy.class.getName());
        }
        int ret = ToolRunner.run((Configuration)conf, (Tool)new Loop(), (String[])new String[]{"1", "1", "2000000", this.util.getDataTestDirOnTestFS("IntegrationTestBigLinkedList").toString(), "1"});
        Assert.assertEquals((long)0L, (long)ret);
    }

    private void usage() {
        System.err.println("Usage: " + ((Object)((Object)this)).getClass().getSimpleName() + " COMMAND [COMMAND options]");
        this.printCommands();
    }

    private void printCommands() {
        System.err.println("Commands:");
        System.err.println(" generator  Map only job that generates data.");
        System.err.println(" verify     A map reduce job that looks for holes. Check return code and");
        System.err.println("            look at the counts after running. See REFERENCED and");
        System.err.println("            UNREFERENCED are ok. Any UNDEFINED counts are bad. Do not run");
        System.err.println("            with the Generator.");
        System.err.println(" walker     Standalone program that starts following a linked list & emits timing info.");
        System.err.println(" print      Standalone program that prints nodes in the linked list.");
        System.err.println(" delete     Standalone program that deletes a single node.");
        System.err.println(" loop       Program to Loop through Generator and Verify steps");
        System.err.println(" clean      Program to clean all left over detritus.");
        System.err.println(" search     Search for missing keys.");
        System.err.println("");
        System.err.println("General options:");
        System.err.println(" -D" + TABLE_NAME_KEY + "=<tableName>");
        System.err.println("    Run using the <tableName> as the tablename.  Defaults to " + DEFAULT_TABLE_NAME);
        System.err.println(" -Dhbase.test.regions-per-server=<# regions>");
        System.err.println("    Create table with presplit regions per server.  Defaults to 3");
        System.err.println(" -DuseMob=<true|false>");
        System.err.println("    Create table so that the mob read/write path is forced.  Defaults to false");
        System.err.flush();
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        String[] args = cmd.getArgs();
        if (args.length < 1) {
            this.printUsage(((Object)((Object)this)).getClass().getSimpleName() + " <general options> COMMAND [<COMMAND options>]", "General options:", "");
            this.printCommands();
            throw new RuntimeException("Incorrect Number of args.");
        }
        this.toRun = args[0];
        this.otherArgs = Arrays.copyOfRange(args, 1, args.length);
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        Configured tool = null;
        if (this.toRun.equalsIgnoreCase("Generator")) {
            tool = new Generator();
        } else if (this.toRun.equalsIgnoreCase("Verify")) {
            tool = new Verify();
        } else if (this.toRun.equalsIgnoreCase("Loop")) {
            Loop loop = new Loop();
            loop.it = this;
            tool = loop;
        } else if (this.toRun.equalsIgnoreCase("Walker")) {
            tool = new Walker();
        } else if (this.toRun.equalsIgnoreCase("Print")) {
            tool = new Print();
        } else if (this.toRun.equalsIgnoreCase("Delete")) {
            tool = new Delete();
        } else if (this.toRun.equalsIgnoreCase("Clean")) {
            tool = new Clean();
        } else if (this.toRun.equalsIgnoreCase("Search")) {
            tool = new Search();
        } else {
            this.usage();
            throw new RuntimeException("Unknown arg");
        }
        return ToolRunner.run((Configuration)this.getConf(), (Tool)tool, (String[])this.otherArgs);
    }

    @Override
    public TableName getTablename() {
        Configuration c = this.getConf();
        return TableName.valueOf((String)c.get(TABLE_NAME_KEY, DEFAULT_TABLE_NAME));
    }

    @Override
    protected Set<String> getColumnFamilies() {
        if (IntegrationTestBigLinkedList.isMultiUnevenColumnFamilies(this.getConf())) {
            return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])FAMILY_NAME), Bytes.toString((byte[])BIG_FAMILY_NAME), Bytes.toString((byte[])TINY_FAMILY_NAME)});
        }
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])FAMILY_NAME)});
    }

    private static void setJobConf(Job job, int numMappers, long numNodes, Integer width, Integer wrapMultiplier, Integer numWalkers) {
        job.getConfiguration().setInt(GENERATOR_NUM_MAPPERS_KEY, numMappers);
        job.getConfiguration().setLong(GENERATOR_NUM_ROWS_PER_MAP_KEY, numNodes);
        if (width != null) {
            job.getConfiguration().setInt(GENERATOR_WIDTH_KEY, width.intValue());
        }
        if (wrapMultiplier != null) {
            job.getConfiguration().setInt(GENERATOR_WRAP_KEY, wrapMultiplier.intValue());
        }
        if (numWalkers != null) {
            job.getConfiguration().setInt(CONCURRENT_WALKER_KEY, numWalkers.intValue());
        }
    }

    public static void setJobScannerConf(Job job) {
        job.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        job.getConfiguration().setInt("hbase.mapreduce.log.scanner.rowcount", 100000);
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestBigLinkedList(), (String[])args);
        System.exit(ret);
    }

    private static class Clean
    extends Configured
    implements Tool {
        private Clean() {
        }

        public int run(String[] args) throws Exception {
            if (args.length < 1) {
                System.err.println("Usage: Clean <output dir>");
                return -1;
            }
            Path p = new Path(args[0]);
            Configuration conf = this.getConf();
            TableName tableName = IntegrationTestBigLinkedList.getTableName(conf);
            try (FileSystem fs = HFileSystem.get((Configuration)conf);
                 Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Admin admin = conn.getAdmin();){
                if (admin.tableExists(tableName)) {
                    admin.disableTable(tableName);
                    admin.deleteTable(tableName);
                }
                if (fs.exists(p)) {
                    fs.delete(p, true);
                }
            }
            return 0;
        }
    }

    private static class Walker
    extends WalkerBase
    implements Tool {
        public int run(String[] args) throws IOException {
            boolean isSpecificStart;
            Options options = new Options();
            options.addOption("n", "num", true, "number of queries");
            options.addOption("s", "start", true, "key to start at, binary string");
            options.addOption("l", "logevery", true, "log every N queries");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            long maxQueries = Long.MAX_VALUE;
            if (cmd.hasOption('n')) {
                maxQueries = Long.parseLong(cmd.getOptionValue("n"));
            }
            byte[] startKey = (isSpecificStart = cmd.hasOption('s')) ? Bytes.toBytesBinary((String)cmd.getOptionValue('s')) : null;
            int logEvery = cmd.hasOption('l') ? Integer.parseInt(cmd.getOptionValue('l')) : 1;
            Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
            Table table = connection.getTable(IntegrationTestBigLinkedList.getTableName(this.getConf()));
            long numQueries = 0L;
            while (!(numQueries >= maxQueries || numQueries != 0L && isSpecificStart)) {
                CINode node;
                if (!isSpecificStart) {
                    startKey = new byte[16];
                    Bytes.random((byte[])startKey);
                }
                if ((node = Walker.findStartNode(table, startKey)) == null && isSpecificStart) {
                    System.err.printf("Start node not found: %s \n", Bytes.toStringBinary((byte[])startKey));
                }
                ++numQueries;
                while (node != null && node.prev.length != NO_KEY.length && numQueries < maxQueries) {
                    byte[] prev = node.prev;
                    long t1 = System.currentTimeMillis();
                    node = this.getNode(prev, table, node);
                    long t2 = System.currentTimeMillis();
                    if (logEvery > 0 && numQueries % (long)logEvery == 0L) {
                        System.out.printf("CQ %d: %d %s \n", numQueries, t2 - t1, Bytes.toStringBinary((byte[])prev));
                    }
                    ++numQueries;
                    if (node == null) {
                        System.err.printf("UNDEFINED NODE %s \n", Bytes.toStringBinary((byte[])prev));
                        continue;
                    }
                    if (node.prev.length != NO_KEY.length) continue;
                    System.err.printf("TERMINATING NODE %s \n", Bytes.toStringBinary((byte[])node.key));
                }
            }
            table.close();
            connection.close();
            return 0;
        }
    }

    static abstract class WalkerBase
    extends Configured {
        WalkerBase() {
        }

        protected static CINode findStartNode(Table table, byte[] startKey) throws IOException {
            Scan scan = new Scan();
            scan.setStartRow(startKey);
            scan.setBatch(1);
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            long t1 = System.currentTimeMillis();
            ResultScanner scanner = table.getScanner(scan);
            Result result = scanner.next();
            long t2 = System.currentTimeMillis();
            scanner.close();
            if (result != null) {
                CINode node = IntegrationTestBigLinkedList.getCINode(result, new CINode());
                System.out.printf("FSR %d %s\n", t2 - t1, Bytes.toStringBinary((byte[])node.key));
                return node;
            }
            System.out.println("FSR " + (t2 - t1));
            return null;
        }

        protected CINode getNode(byte[] row, Table table, CINode node) throws IOException {
            Get get = new Get(row);
            get.addColumn(FAMILY_NAME, COLUMN_PREV);
            Result result = table.get(get);
            return IntegrationTestBigLinkedList.getCINode(result, node);
        }
    }

    private static class Delete
    extends Configured
    implements Tool {
        private Delete() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 1) {
                System.out.println("Usage : " + Delete.class.getSimpleName() + " <node to delete>");
                return 0;
            }
            byte[] val = Bytes.toBytesBinary((String)args[0]);
            org.apache.hadoop.hbase.client.Delete delete = new org.apache.hadoop.hbase.client.Delete(val);
            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
                 Table table = connection.getTable(IntegrationTestBigLinkedList.getTableName(this.getConf()));){
                table.delete(delete);
            }
            System.out.println("Delete successful");
            return 0;
        }
    }

    private static class Print
    extends Configured
    implements Tool {
        private Print() {
        }

        public int run(String[] args) throws Exception {
            Options options = new Options();
            options.addOption("s", "start", true, "start key");
            options.addOption("e", "end", true, "end key");
            options.addOption("l", "limit", true, "number to print");
            GnuParser parser = new GnuParser();
            CommandLine cmd = null;
            try {
                cmd = parser.parse(options, args);
                if (cmd.getArgs().length != 0) {
                    throw new ParseException("Command takes no arguments");
                }
            }
            catch (ParseException e) {
                System.err.println("Failed to parse command line " + e.getMessage());
                System.err.println();
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(((Object)((Object)this)).getClass().getSimpleName(), options);
                System.exit(-1);
            }
            Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
            Table table = connection.getTable(IntegrationTestBigLinkedList.getTableName(this.getConf()));
            Scan scan = new Scan();
            scan.setBatch(10000);
            if (cmd.hasOption("s")) {
                scan.setStartRow(Bytes.toBytesBinary((String)cmd.getOptionValue("s")));
            }
            if (cmd.hasOption("e")) {
                scan.setStopRow(Bytes.toBytesBinary((String)cmd.getOptionValue("e")));
            }
            int limit = 0;
            limit = cmd.hasOption("l") ? Integer.parseInt(cmd.getOptionValue("l")) : 100;
            ResultScanner scanner = table.getScanner(scan);
            CINode node = new CINode();
            Result result = scanner.next();
            int count = 0;
            while (result != null && count++ < limit) {
                node = IntegrationTestBigLinkedList.getCINode(result, node);
                System.out.printf("%s:%s:%012d:%s\n", Bytes.toStringBinary((byte[])node.key), Bytes.toStringBinary((byte[])node.prev), node.count, node.client);
                result = scanner.next();
            }
            scanner.close();
            table.close();
            connection.close();
            return 0;
        }
    }

    static class Loop
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Loop.class);
        private static final String USAGE = "Usage: Loop <num iterations> <num mappers> <num nodes per mapper> <output dir> <num reducers> [<width> <wrap multiplier> <num walker threads>] \nwhere <num nodes per map> should be a multiple of width*wrap multiplier, 25M by default \nwalkers will select and verify random flushed loop during Generation.";
        IntegrationTestBigLinkedList it;

        Loop() {
        }

        protected void runGenerator(int numMappers, long numNodes, String outputDir, Integer width, Integer wrapMultiplier, Integer numWalkers) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path generatorOutput = new Path(outputPath, uuid.toString());
            Generator generator = new Generator();
            generator.setConf(this.getConf());
            int retCode = generator.run(numMappers, numNodes, generatorOutput, width, wrapMultiplier, numWalkers);
            if (retCode > 0) {
                throw new RuntimeException("Generator failed with return code: " + retCode);
            }
            if (numWalkers > 0 && !generator.verify()) {
                throw new RuntimeException("Generator.verify failed");
            }
            LOG.info("Generator finished with success. Total nodes=" + numNodes);
        }

        protected void runVerify(String outputDir, int numReducers, long expectedNumNodes) throws Exception {
            Path outputPath = new Path(outputDir);
            UUID uuid = UUID.randomUUID();
            Path iterationOutput = new Path(outputPath, uuid.toString());
            Verify verify = new Verify();
            verify.setConf(this.getConf());
            int retCode = verify.run(iterationOutput, numReducers);
            if (retCode > 0) {
                throw new RuntimeException("Verify.run failed with return code: " + retCode);
            }
            if (!verify.verify(expectedNumNodes)) {
                throw new RuntimeException("Verify.verify failed");
            }
            LOG.info("Verify finished with success. Total nodes=" + expectedNumNodes);
        }

        public int run(String[] args) throws Exception {
            if (args.length < 5) {
                System.err.println(USAGE);
                return 1;
            }
            try {
                int numIterations = Integer.parseInt(args[0]);
                int numMappers = Integer.parseInt(args[1]);
                long numNodes = Long.parseLong(args[2]);
                String outputDir = args[3];
                int numReducers = Integer.parseInt(args[4]);
                Integer width = args.length < 6 ? null : Integer.valueOf(Integer.parseInt(args[5]));
                Integer wrapMultiplier = args.length < 7 ? null : Integer.valueOf(Integer.parseInt(args[6]));
                Integer numWalkers = args.length < 8 ? 0 : Integer.parseInt(args[7]);
                long expectedNumNodes = 0L;
                if (numIterations < 0) {
                    numIterations = Integer.MAX_VALUE;
                }
                LOG.info("Running Loop with args:" + Arrays.deepToString(args));
                for (int i = 0; i < numIterations; ++i) {
                    LOG.info("Starting iteration = " + i);
                    this.runGenerator(numMappers, numNodes, outputDir, width, wrapMultiplier, numWalkers);
                    this.runVerify(outputDir, numReducers, expectedNumNodes += (long)numMappers * numNodes);
                }
                return 0;
            }
            catch (NumberFormatException e) {
                System.err.println("Parsing loop arguments failed: " + e.getMessage());
                System.err.println(USAGE);
                return 1;
            }
        }
    }

    static class Verify
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Verify.class);
        protected static final BytesWritable DEF = new BytesWritable(new byte[]{0});
        protected static final BytesWritable DEF_LOST_FAMILIES = new BytesWritable(new byte[]{1});
        protected Job job;

        Verify() {
        }

        public int run(String[] args) throws Exception {
            if (args.length != 2) {
                System.out.println("Usage : " + Verify.class.getSimpleName() + " <output dir> <num reducers>");
                return 0;
            }
            String outputDir = args[0];
            int numReducers = Integer.parseInt(args[1]);
            return this.run(outputDir, numReducers);
        }

        public int run(String outputDir, int numReducers) throws Exception {
            return this.run(new Path(outputDir), numReducers);
        }

        public int run(Path outputDir, int numReducers) throws Exception {
            LOG.info("Running Verify with outputDir=" + outputDir + ", numReducers=" + numReducers);
            this.job = Job.getInstance((Configuration)this.getConf());
            this.job.setJobName("Link Verifier");
            this.job.setNumReduceTasks(numReducers);
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            IntegrationTestBigLinkedList.setJobScannerConf(this.job);
            Scan scan = new Scan();
            scan.addColumn(FAMILY_NAME, COLUMN_PREV);
            scan.setCaching(10000);
            scan.setCacheBlocks(false);
            if (IntegrationTestBigLinkedList.isMultiUnevenColumnFamilies(this.getConf())) {
                scan.addColumn(BIG_FAMILY_NAME, BIG_FAMILY_NAME);
                scan.addColumn(TINY_FAMILY_NAME, TINY_FAMILY_NAME);
            }
            TableMapReduceUtil.initTableMapperJob((byte[])IntegrationTestBigLinkedList.getTableName(this.getConf()).getName(), (Scan)scan, VerifyMapper.class, BytesWritable.class, BytesWritable.class, (Job)this.job);
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)this.job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            this.job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
            this.job.setReducerClass(VerifyReducer.class);
            this.job.setOutputFormatClass(SequenceFileAsBinaryOutputFormat.class);
            this.job.setOutputKeyClass(BytesWritable.class);
            this.job.setOutputValueClass(BytesWritable.class);
            TextOutputFormat.setOutputPath((Job)this.job, (Path)outputDir);
            boolean success = this.job.waitForCompletion(true);
            if (success) {
                Counters counters = this.job.getCounters();
                if (null == counters) {
                    LOG.warn("Counters were null, cannot verify Job completion. This is commonly a result of insufficient YARN configuration.");
                    return 0;
                }
                if (this.verifyUnexpectedValues(counters)) {
                    return 0;
                }
            }
            return 1;
        }

        public boolean verify(long expectedReferenced) throws Exception {
            if (this.job == null) {
                throw new IllegalStateException("You should call run() first");
            }
            Counters counters = this.job.getCounters();
            if (counters == null) {
                LOG.info("Counters object was null, write verification cannot be performed. This is commonly a result of insufficient YARN configuration.");
                return false;
            }
            boolean success = this.verifyExpectedValues(expectedReferenced, counters);
            if (!this.verifyUnexpectedValues(counters)) {
                success = false;
            }
            if (!success) {
                this.handleFailure(counters);
            }
            return success;
        }

        protected boolean verifyExpectedValues(long expectedReferenced, Counters counters) {
            Counter referenced = counters.findCounter((Enum)Counts.REFERENCED);
            Counter unreferenced = counters.findCounter((Enum)Counts.UNREFERENCED);
            boolean success = true;
            if (expectedReferenced != referenced.getValue()) {
                LOG.error("Expected referenced count does not match with actual referenced count. expected referenced=" + expectedReferenced + " ,actual=" + referenced.getValue());
                success = false;
            }
            if (unreferenced.getValue() > 0L) {
                Counter multiref = counters.findCounter((Enum)Counts.EXTRAREFERENCES);
                boolean couldBeMultiRef = multiref.getValue() == unreferenced.getValue();
                LOG.error("Unreferenced nodes were not expected. Unreferenced count=" + unreferenced.getValue() + (couldBeMultiRef ? "; could be due to duplicate random numbers" : ""));
                success = false;
            }
            return success;
        }

        protected boolean verifyUnexpectedValues(Counters counters) {
            Counter undefined = counters.findCounter((Enum)Counts.UNDEFINED);
            Counter lostfamilies = counters.findCounter((Enum)Counts.LOST_FAMILIES);
            boolean success = true;
            if (undefined.getValue() > 0L) {
                LOG.error("Found an undefined node. Undefined count=" + undefined.getValue());
                success = false;
            }
            if (lostfamilies.getValue() > 0L) {
                LOG.error("Found nodes which lost big or tiny families, count=" + lostfamilies.getValue());
                success = false;
            }
            return success;
        }

        protected void handleFailure(Counters counters) throws IOException {
            Configuration conf = this.job.getConfiguration();
            TableName tableName = IntegrationTestBigLinkedList.getTableName(conf);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 RegionLocator rl = conn.getRegionLocator(tableName);){
                HRegionLocation loc;
                byte[] key;
                String keyString;
                CounterGroup g = (CounterGroup)counters.getGroup("undef");
                Iterator it = g.iterator();
                while (it.hasNext()) {
                    keyString = ((Counter)it.next()).getName();
                    key = Bytes.toBytes((String)keyString);
                    loc = rl.getRegionLocation(key, true);
                    LOG.error("undefined row " + keyString + ", " + loc);
                }
                g = (CounterGroup)counters.getGroup("unref");
                it = g.iterator();
                while (it.hasNext()) {
                    keyString = ((Counter)it.next()).getName();
                    key = Bytes.toBytes((String)keyString);
                    loc = rl.getRegionLocation(key, true);
                    LOG.error("unreferred row " + keyString + ", " + loc);
                }
            }
        }

        public static class VerifyReducer
        extends Reducer<BytesWritable, BytesWritable, BytesWritable, BytesWritable> {
            private ArrayList<byte[]> refs = new ArrayList();
            private final BytesWritable UNREF = new BytesWritable(VerifyReducer.addPrefixFlag(Counts.UNREFERENCED.ordinal(), new byte[0]));
            private final BytesWritable LOSTFAM = new BytesWritable(VerifyReducer.addPrefixFlag(Counts.LOST_FAMILIES.ordinal(), new byte[0]));
            private AtomicInteger rows = new AtomicInteger(0);
            private Connection connection;

            protected void setup(Reducer.Context context) throws IOException, InterruptedException {
                super.setup(context);
                this.connection = ConnectionFactory.createConnection((Configuration)context.getConfiguration());
            }

            protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
                if (this.connection != null) {
                    this.connection.close();
                }
                super.cleanup(context);
            }

            public static byte[] addPrefixFlag(int ordinal, byte[] r) {
                byte[] prefix = Bytes.toBytes((short)((short)ordinal));
                if (prefix.length != 2) {
                    throw new RuntimeException("Unexpected size: " + prefix.length);
                }
                byte[] result = new byte[prefix.length + r.length];
                System.arraycopy(prefix, 0, result, 0, prefix.length);
                System.arraycopy(r, 0, result, prefix.length, r.length);
                return result;
            }

            public static Counts whichType(byte[] bs) {
                short ordinal = Bytes.toShort((byte[])bs, (int)0, (int)2);
                return Counts.values()[ordinal];
            }

            public static byte[] getRowOnly(BytesWritable bw) {
                byte[] bytes = new byte[bw.getLength() - 2];
                System.arraycopy(bw.getBytes(), 2, bytes, 0, bytes.length);
                return bytes;
            }

            public void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
                String keyString;
                int defCount = 0;
                boolean lostFamilies = false;
                this.refs.clear();
                for (BytesWritable type : values) {
                    if (type.getLength() == DEF.getLength()) {
                        ++defCount;
                        if (type.getBytes()[0] != 1) continue;
                        lostFamilies = true;
                        continue;
                    }
                    byte[] bytes = new byte[type.getLength()];
                    System.arraycopy(type.getBytes(), 0, bytes, 0, type.getLength());
                    this.refs.add(bytes);
                }
                StringBuilder refsSb = null;
                if (defCount == 0 || this.refs.size() != 1) {
                    keyString = Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength());
                    refsSb = this.dumpExtraInfoOnRefs(key, context, this.refs);
                    LOG.error("LinkedListError: key=" + keyString + ", reference(s)=" + (refsSb != null ? refsSb.toString() : ""));
                }
                if (lostFamilies) {
                    keyString = Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength());
                    LOG.error("LinkedListError: key=" + keyString + ", lost big or tiny families");
                    context.getCounter((Enum)Counts.LOST_FAMILIES).increment(1L);
                    context.write((Object)key, (Object)this.LOSTFAM);
                }
                if (defCount == 0 && this.refs.size() > 0) {
                    for (int i = 0; i < this.refs.size(); ++i) {
                        int ordinal;
                        byte[] bs = this.refs.get(i);
                        if (i <= 0) {
                            ordinal = Counts.UNDEFINED.ordinal();
                            context.write((Object)key, (Object)new BytesWritable(VerifyReducer.addPrefixFlag(ordinal, bs)));
                            context.getCounter((Enum)Counts.UNDEFINED).increment(1L);
                            continue;
                        }
                        ordinal = Counts.EXTRA_UNDEF_REFERENCES.ordinal();
                        context.write((Object)key, (Object)new BytesWritable(VerifyReducer.addPrefixFlag(ordinal, bs)));
                    }
                    if (this.rows.addAndGet(1) < 10) {
                        String keyString2 = Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength());
                        context.getCounter("undef", keyString2).increment(1L);
                    }
                } else if (defCount > 0 && this.refs.isEmpty()) {
                    context.write((Object)key, (Object)this.UNREF);
                    context.getCounter((Enum)Counts.UNREFERENCED).increment(1L);
                    if (this.rows.addAndGet(1) < 10) {
                        keyString = Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength());
                        context.getCounter("unref", keyString).increment(1L);
                    }
                } else {
                    if (this.refs.size() > 1) {
                        for (int i = 1; i < this.refs.size(); ++i) {
                            context.write((Object)key, (Object)new BytesWritable(VerifyReducer.addPrefixFlag(Counts.EXTRAREFERENCES.ordinal(), this.refs.get(i))));
                        }
                        context.getCounter((Enum)Counts.EXTRAREFERENCES).increment((long)(this.refs.size() - 1));
                    }
                    context.getCounter((Enum)Counts.REFERENCED).increment(1L);
                }
            }

            private StringBuilder dumpExtraInfoOnRefs(BytesWritable key, Reducer.Context context, List<byte[]> refs) throws IOException {
                StringBuilder refsSb = null;
                if (refs.isEmpty()) {
                    return refsSb;
                }
                refsSb = new StringBuilder();
                String comma = "";
                TableName tn = IntegrationTestBigLinkedList.getTableName(context.getConfiguration());
                try (Table t = this.connection.getTable(tn);){
                    for (byte[] ref : refs) {
                        Result r = t.get(new Get(ref));
                        List cells = r.listCells();
                        String ts = cells != null && !cells.isEmpty() ? new Date(((Cell)cells.get(0)).getTimestamp()).toString() : "";
                        byte[] b = r.getValue(FAMILY_NAME, COLUMN_CLIENT);
                        String jobStr = b != null && b.length > 0 ? Bytes.toString((byte[])b) : "";
                        b = r.getValue(FAMILY_NAME, COLUMN_COUNT);
                        long count = b != null && b.length > 0 ? Bytes.toLong((byte[])b) : -1L;
                        b = r.getValue(FAMILY_NAME, COLUMN_PREV);
                        String refRegionLocation = "";
                        String keyRegionLocation = "";
                        if (b != null && b.length > 0) {
                            try (RegionLocator rl = this.connection.getRegionLocator(tn);){
                                HRegionLocation hrl = rl.getRegionLocation(b);
                                if (hrl != null) {
                                    refRegionLocation = hrl.toString();
                                }
                                if ((hrl = rl.getRegionLocation(key.getBytes())) != null) {
                                    keyRegionLocation = hrl.toString();
                                }
                            }
                        }
                        LOG.error("Extras on ref without a def, ref=" + Bytes.toStringBinary((byte[])ref) + ", refPrevEqualsKey=" + (Bytes.compareTo((byte[])key.getBytes(), (int)0, (int)key.getLength(), (byte[])b, (int)0, (int)b.length) == 0) + ", key=" + Bytes.toStringBinary((byte[])key.getBytes(), (int)0, (int)key.getLength()) + ", ref row date=" + ts + ", jobStr=" + jobStr + ", ref row count=" + count + ", ref row regionLocation=" + refRegionLocation + ", key row regionLocation=" + keyRegionLocation);
                        refsSb.append(comma);
                        comma = ",";
                        refsSb.append(Bytes.toStringBinary((byte[])ref));
                    }
                }
                return refsSb;
            }
        }

        public static enum Counts {
            UNREFERENCED,
            UNDEFINED,
            REFERENCED,
            CORRUPT,
            EXTRAREFERENCES,
            EXTRA_UNDEF_REFERENCES,
            LOST_FAMILIES;

        }

        public static class VerifyMapper
        extends TableMapper<BytesWritable, BytesWritable> {
            private BytesWritable row = new BytesWritable();
            private BytesWritable ref = new BytesWritable();
            private boolean multipleUnevenColumnFamilies;

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                this.multipleUnevenColumnFamilies = IntegrationTestBigLinkedList.isMultiUnevenColumnFamilies(context.getConfiguration());
            }

            protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
                byte[] rowKey = key.get();
                this.row.set(rowKey, 0, rowKey.length);
                if (!(!this.multipleUnevenColumnFamilies || value.containsColumn(BIG_FAMILY_NAME, BIG_FAMILY_NAME) && value.containsColumn(TINY_FAMILY_NAME, TINY_FAMILY_NAME))) {
                    context.write((Object)this.row, (Object)DEF_LOST_FAMILIES);
                } else {
                    context.write((Object)this.row, (Object)DEF);
                }
                byte[] prev = value.getValue(FAMILY_NAME, COLUMN_PREV);
                if (prev != null && prev.length > 0) {
                    this.ref.set(prev, 0, prev.length);
                    context.write((Object)this.ref, (Object)this.row);
                } else {
                    LOG.warn(String.format("Prev is not set for: %s", Bytes.toStringBinary((byte[])rowKey)));
                }
            }
        }
    }

    static class Search
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Search.class);
        protected Job job;
        static final String FOUND_GROUP_KEY = "Found";
        static final String SEARCHER_INPUTDIR_KEY = "searcher.keys.inputdir";

        Search() {
        }

        private static void printUsage(String error) {
            if (error != null && error.length() > 0) {
                System.out.println("ERROR: " + error);
            }
            System.err.println("Usage: search <KEYS_DIR> [<MAPPERS_COUNT>]");
        }

        public int run(String[] args) throws Exception {
            if (args.length < 1 || args.length > 2) {
                Search.printUsage(null);
                return 1;
            }
            Path inputDir = new Path(args[0]);
            int numMappers = 1;
            if (args.length > 1) {
                numMappers = Integer.parseInt(args[1]);
            }
            return this.run(inputDir, numMappers);
        }

        public int run(Path inputDir, int numMappers) throws Exception {
            this.getConf().set(SEARCHER_INPUTDIR_KEY, inputDir.toString());
            SortedSet<byte[]> keys = Search.readKeysToSearch(this.getConf());
            if (keys.isEmpty()) {
                throw new RuntimeException("No keys to find");
            }
            LOG.info("Count of keys to find: " + keys.size());
            for (byte[] key : keys) {
                LOG.info("Key: " + Bytes.toStringBinary((byte[])key));
            }
            Path walsDir = new Path(CommonFSUtils.getWALRootDir((Configuration)this.getConf()), "WALs");
            Path oldWalsDir = new Path(CommonFSUtils.getWALRootDir((Configuration)this.getConf()), "oldWALs");
            LOG.info("Running Search with keys inputDir=" + inputDir + ", numMappers=" + numMappers + " against " + this.getConf().get("hbase.rootdir"));
            int ret = ToolRunner.run((Configuration)this.getConf(), (Tool)new WALSearcher(this.getConf()), (String[])new String[]{walsDir.toString(), ""});
            if (ret != 0) {
                return ret;
            }
            return ToolRunner.run((Configuration)this.getConf(), (Tool)new WALSearcher(this.getConf()), (String[])new String[]{oldWalsDir.toString(), ""});
        }

        static SortedSet<byte[]> readKeysToSearch(Configuration conf) throws IOException, InterruptedException {
            Path keysInputDir = new Path(conf.get(SEARCHER_INPUTDIR_KEY));
            FileSystem fs = FileSystem.get((Configuration)conf);
            TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            if (!fs.exists(keysInputDir)) {
                throw new FileNotFoundException(keysInputDir.toString());
            }
            if (!fs.isDirectory(keysInputDir)) {
                throw new UnsupportedOperationException("TODO");
            }
            RemoteIterator iterator = fs.listFiles(keysInputDir, false);
            while (iterator.hasNext()) {
                LocatedFileStatus keyFileStatus = (LocatedFileStatus)iterator.next();
                if (keyFileStatus.getPath().getName().startsWith("_")) continue;
                result.addAll(Search.readFileToSearch(conf, fs, keyFileStatus));
            }
            return result;
        }

        private static SortedSet<byte[]> readFileToSearch(Configuration conf, FileSystem fs, LocatedFileStatus keyFileStatus) throws IOException, InterruptedException {
            TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            TaskAttemptContextImpl context = new TaskAttemptContextImpl(conf, new TaskAttemptID());
            try (SequenceFileAsBinaryInputFormat.SequenceFileAsBinaryRecordReader rr = new SequenceFileAsBinaryInputFormat.SequenceFileAsBinaryRecordReader();){
                FileSplit is = new FileSplit(keyFileStatus.getPath(), 0L, keyFileStatus.getLen(), new String[0]);
                rr.initialize((InputSplit)is, (TaskAttemptContext)context);
                while (rr.nextKeyValue()) {
                    rr.getCurrentKey();
                    BytesWritable bw = rr.getCurrentValue();
                    if (Verify.VerifyReducer.whichType(bw.getBytes()) != Verify.Counts.UNDEFINED) continue;
                    byte[] key = new byte[rr.getCurrentKey().getLength()];
                    System.arraycopy(rr.getCurrentKey().getBytes(), 0, key, 0, rr.getCurrentKey().getLength());
                    result.add(key);
                }
            }
            return result;
        }

        public static class WALSearcher
        extends WALPlayer {
            public WALSearcher(Configuration conf) {
                super(conf);
            }

            public Job createSubmittableJob(String[] args) throws IOException {
                Job job = super.createSubmittableJob(args);
                job.setJarByClass(WALMapperSearcher.class);
                job.setMapperClass(WALMapperSearcher.class);
                job.setOutputFormatClass(NullOutputFormat.class);
                return job;
            }

            public static class WALMapperSearcher
            extends WALPlayer.WALMapper {
                private SortedSet<byte[]> keysToFind;
                private AtomicInteger rows = new AtomicInteger(0);

                public void setup(Mapper.Context context) throws IOException {
                    super.setup(context);
                    try {
                        this.keysToFind = Search.readKeysToSearch(context.getConfiguration());
                        LOG.info("Loaded keys to find: count=" + this.keysToFind.size());
                    }
                    catch (InterruptedException e) {
                        throw new InterruptedIOException(e.toString());
                    }
                }

                protected boolean filter(Mapper.Context context, Cell cell) {
                    byte[] row = new byte[cell.getRowLength()];
                    System.arraycopy(cell.getRowArray(), cell.getRowOffset(), row, 0, cell.getRowLength());
                    boolean b = this.keysToFind.contains(row);
                    if (b) {
                        String keyStr = Bytes.toStringBinary((byte[])row);
                        try {
                            LOG.info("Found cell=" + cell + " , walKey=" + context.getCurrentKey());
                        }
                        catch (IOException | InterruptedException e) {
                            LOG.warn(e.toString(), (Throwable)e);
                        }
                        if (this.rows.addAndGet(1) < 10) {
                            context.getCounter(Search.FOUND_GROUP_KEY, keyStr).increment(1L);
                        }
                        context.getCounter(Search.FOUND_GROUP_KEY, "CELL_WITH_MISSING_ROW").increment(1L);
                    }
                    return b;
                }
            }
        }
    }

    static class Generator
    extends Configured
    implements Tool {
        private static final Logger LOG = LoggerFactory.getLogger(Generator.class);
        public static final String MULTIPLE_UNEVEN_COLUMNFAMILIES_KEY = "generator.multiple.columnfamilies";
        public static final String BIG_FAMILY_VALUE_SIZE_KEY = "generator.big.family.value.size";
        public static final String USAGE = "Usage : " + Generator.class.getSimpleName() + " <num mappers> <num nodes per map> <tmp output dir> [<width> <wrap multiplier> <num walker threads>] \nWhere <num nodes per map> should be a multiple of 'width' * 'wrap multiplier'.\n25M is default because default 'width' is 1M and default 'wrap multiplier' is 25.\nWe write out 1M nodes and then flush the client. After 25 flushes, we connect \nfirst written nodes back to the 25th set.\nWalkers verify random flushed loops during Generation.";
        public Job job;

        Generator() {
        }

        public int run(String[] args) throws Exception {
            if (args.length < 3) {
                System.err.println(USAGE);
                return 1;
            }
            try {
                int numMappers = Integer.parseInt(args[0]);
                long numNodes = Long.parseLong(args[1]);
                Path tmpOutput = new Path(args[2]);
                Integer width = args.length < 4 ? null : Integer.valueOf(Integer.parseInt(args[3]));
                Integer wrapMultiplier = args.length < 5 ? null : Integer.valueOf(Integer.parseInt(args[4]));
                Integer numWalkers = args.length < 6 ? null : Integer.valueOf(Integer.parseInt(args[5]));
                return this.run(numMappers, numNodes, tmpOutput, width, wrapMultiplier, numWalkers);
            }
            catch (NumberFormatException e) {
                System.err.println("Parsing generator arguments failed: " + e.getMessage());
                System.err.println(USAGE);
                return 1;
            }
        }

        protected void createSchema() throws IOException {
            Configuration conf = this.getConf();
            TableName tableName = IntegrationTestBigLinkedList.getTableName(conf);
            try (Connection conn = ConnectionFactory.createConnection((Configuration)conf);
                 Admin admin = conn.getAdmin();){
                if (!admin.tableExists(tableName)) {
                    HTableDescriptor htd = new HTableDescriptor(IntegrationTestBigLinkedList.getTableName(this.getConf()));
                    htd.addFamily(new HColumnDescriptor(FAMILY_NAME));
                    htd.addFamily(new HColumnDescriptor(BIG_FAMILY_NAME));
                    htd.addFamily(new HColumnDescriptor(TINY_FAMILY_NAME));
                    if (conf.getBoolean("useMob", false)) {
                        for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
                            hcd.setMobEnabled(true);
                            hcd.setMobThreshold(4L);
                        }
                    }
                    if (conf.getBoolean("hbase.test.pre-split-table", true)) {
                        int numberOfServers = admin.getRegionServers().size();
                        if (numberOfServers == 0) {
                            throw new IllegalStateException("No live regionservers");
                        }
                        int regionsPerServer = conf.getInt("hbase.test.regions-per-server", 3);
                        int totalNumberOfRegions = numberOfServers * regionsPerServer;
                        LOG.info("Number of live regionservers: " + numberOfServers + ", pre-splitting table into " + totalNumberOfRegions + " regions (default regions per server: " + regionsPerServer + ")");
                        byte[][] splits = new RegionSplitter.UniformSplit().split(totalNumberOfRegions);
                        admin.createTable((TableDescriptor)htd, splits);
                    } else {
                        admin.createTable((TableDescriptor)htd);
                    }
                }
            }
            catch (MasterNotRunningException e) {
                LOG.error("Master not running", (Throwable)e);
                throw new IOException(e);
            }
        }

        public int runRandomInputGenerator(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMultiplier, Integer numWalkers) throws Exception {
            LOG.info("Running RandomInputGenerator with numMappers=" + numMappers + ", numNodes=" + numNodes);
            Job job = Job.getInstance((Configuration)this.getConf());
            job.setJobName("Random Input Generator");
            job.setNumReduceTasks(0);
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(GeneratorInputFormat.class);
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(NullWritable.class);
            IntegrationTestBigLinkedList.setJobConf(job, numMappers, numNodes, width, wrapMultiplier, numWalkers);
            job.setMapperClass(Mapper.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)tmpOutput);
            job.setOutputFormatClass(SequenceFileOutputFormat.class);
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{Random64.class});
            boolean success = this.jobCompletion(job);
            return success ? 0 : 1;
        }

        public int runGenerator(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMultiplier, Integer numWalkers) throws Exception {
            LOG.info("Running Generator with numMappers=" + numMappers + ", numNodes=" + numNodes);
            this.createSchema();
            this.job = Job.getInstance((Configuration)this.getConf());
            this.job.setJobName("Link Generator");
            this.job.setNumReduceTasks(0);
            this.job.setJarByClass(((Object)((Object)this)).getClass());
            FileInputFormat.setInputPaths((Job)this.job, (Path[])new Path[]{tmpOutput});
            this.job.setInputFormatClass(OneFilePerMapperSFIF.class);
            this.job.setOutputKeyClass(NullWritable.class);
            this.job.setOutputValueClass(NullWritable.class);
            IntegrationTestBigLinkedList.setJobConf(this.job, numMappers, numNodes, width, wrapMultiplier, numWalkers);
            this.setMapperForGenerator(this.job);
            this.job.setOutputFormatClass(NullOutputFormat.class);
            this.job.getConfiguration().setBoolean("mapreduce.map.speculative", false);
            TableMapReduceUtil.addDependencyJars((Job)this.job);
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)this.job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
            TableMapReduceUtil.initCredentials((Job)this.job);
            boolean success = this.jobCompletion(this.job);
            return success ? 0 : 1;
        }

        protected boolean jobCompletion(Job job) throws IOException, InterruptedException, ClassNotFoundException {
            boolean success = job.waitForCompletion(true);
            return success;
        }

        protected void setMapperForGenerator(Job job) {
            job.setMapperClass(GeneratorMapper.class);
        }

        public int run(int numMappers, long numNodes, Path tmpOutput, Integer width, Integer wrapMultiplier, Integer numWalkers) throws Exception {
            int ret = this.runRandomInputGenerator(numMappers, numNodes, tmpOutput, width, wrapMultiplier, numWalkers);
            if (ret > 0) {
                return ret;
            }
            return this.runGenerator(numMappers, numNodes, tmpOutput, width, wrapMultiplier, numWalkers);
        }

        public boolean verify() {
            try {
                Counters counters = this.job.getCounters();
                if (counters == null) {
                    LOG.info("Counters object was null, Generator verification cannot be performed. This is commonly a result of insufficient YARN configuration.");
                    return false;
                }
                if (counters.findCounter((Enum)Counts.TERMINATING).getValue() > 0L || counters.findCounter((Enum)Counts.UNDEFINED).getValue() > 0L || counters.findCounter((Enum)Counts.IOEXCEPTION).getValue() > 0L) {
                    LOG.error("Concurrent walker failed to verify during Generation phase");
                    LOG.error("TERMINATING nodes: " + counters.findCounter((Enum)Counts.TERMINATING).getValue());
                    LOG.error("UNDEFINED nodes: " + counters.findCounter((Enum)Counts.UNDEFINED).getValue());
                    LOG.error("IOEXCEPTION nodes: " + counters.findCounter((Enum)Counts.IOEXCEPTION).getValue());
                    return false;
                }
            }
            catch (IOException e) {
                LOG.info("Generator verification could not find counter");
                return false;
            }
            return true;
        }

        static class GeneratorMapper
        extends Mapper<BytesWritable, NullWritable, NullWritable, NullWritable> {
            byte[][] first = null;
            byte[][] prev = null;
            byte[][] current = null;
            byte[] id;
            long count = 0L;
            int i;
            BufferedMutator mutator;
            Connection connection;
            long numNodes;
            long wrap;
            int width;
            boolean multipleUnevenColumnFamilies;
            byte[] tinyValue = new byte[]{116};
            byte[] bigValue = null;
            Configuration conf;
            private Random64 rand = new Random64();
            volatile boolean walkersStop;
            int numWalkers;
            volatile List<Long> flushedLoops = new ArrayList<Long>();
            List<Thread> walkers = new ArrayList<Thread>();

            GeneratorMapper() {
            }

            protected void setup(Mapper.Context context) throws IOException, InterruptedException {
                this.id = Bytes.toBytes((String)("Job: " + context.getJobID() + " Task: " + context.getTaskAttemptID()));
                this.connection = ConnectionFactory.createConnection((Configuration)context.getConfiguration());
                this.instantiateHTable();
                this.width = context.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_WIDTH_KEY, 1000000);
                this.current = new byte[this.width][];
                int wrapMultiplier = context.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_WRAP_KEY, 25);
                this.wrap = (long)wrapMultiplier * (long)this.width;
                this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, 25000000L);
                if (this.numNodes < this.wrap) {
                    this.wrap = this.numNodes;
                }
                this.multipleUnevenColumnFamilies = IntegrationTestBigLinkedList.isMultiUnevenColumnFamilies(context.getConfiguration());
                this.numWalkers = context.getConfiguration().getInt(IntegrationTestBigLinkedList.CONCURRENT_WALKER_KEY, 0);
                this.walkersStop = false;
                this.conf = context.getConfiguration();
                if (this.multipleUnevenColumnFamilies) {
                    int limit;
                    int n = context.getConfiguration().getInt(Generator.BIG_FAMILY_VALUE_SIZE_KEY, 256);
                    Preconditions.checkArgument((n <= (limit = context.getConfiguration().getInt("hbase.client.keyvalue.maxsize", 0xA00000)) ? 1 : 0) != 0, (String)"%s(%s) > %s(%s)", (Object)Generator.BIG_FAMILY_VALUE_SIZE_KEY, (Object)n, (Object)"hbase.client.keyvalue.maxsize", (Object)limit);
                    this.bigValue = new byte[n];
                    this.rand.nextBytes(this.bigValue);
                    LOG.info("Create a bigValue with " + n + " bytes.");
                }
                Preconditions.checkArgument((this.numNodes > 0L ? 1 : 0) != 0, (String)"numNodes(%s) <= 0", (long)this.numNodes);
                Preconditions.checkArgument((this.numNodes % (long)this.width == 0L ? 1 : 0) != 0, (String)"numNodes(%s) mod width(%s) != 0", (long)this.numNodes, (int)this.width);
                Preconditions.checkArgument((this.numNodes % this.wrap == 0L ? 1 : 0) != 0, (String)"numNodes(%s) mod wrap(%s) != 0", (long)this.numNodes, (long)this.wrap);
            }

            protected void instantiateHTable() throws IOException {
                this.mutator = this.connection.getBufferedMutator(new BufferedMutatorParams(IntegrationTestBigLinkedList.getTableName(this.connection.getConfiguration())).writeBufferSize(0x400000L));
            }

            protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
                this.joinWalkers();
                this.mutator.close();
                this.connection.close();
            }

            protected void map(BytesWritable key, NullWritable value, Mapper.Context output) throws IOException {
                this.current[this.i] = new byte[key.getLength()];
                System.arraycopy(key.getBytes(), 0, this.current[this.i], 0, key.getLength());
                if (++this.i == this.current.length) {
                    LOG.debug("Persisting current.length={}, count={}, id={}, current={}, i=", new Object[]{this.current.length, this.count, Bytes.toStringBinary((byte[])this.id), Bytes.toStringBinary((byte[])this.current[0]), this.i});
                    this.persist(output, this.count, this.prev, this.current, this.id);
                    this.i = 0;
                    if (this.first == null) {
                        this.first = this.current;
                    }
                    this.prev = this.current;
                    this.current = new byte[this.width][];
                    this.count += (long)this.current.length;
                    output.setStatus("Count " + this.count);
                    if (this.count % this.wrap == 0L) {
                        GeneratorMapper.circularLeftShift(this.first);
                        this.persist(output, -1L, this.prev, this.first, null);
                        if (this.numWalkers > 0) {
                            this.addFlushed(key.getBytes());
                            if (this.walkers.isEmpty()) {
                                this.startWalkers(this.numWalkers, this.conf, output);
                            }
                        }
                        this.first = null;
                        this.prev = null;
                    }
                }
            }

            private static <T> void circularLeftShift(T[] first) {
                T ez = first[0];
                System.arraycopy(first, 1, first, 0, first.length - 1);
                first[first.length - 1] = ez;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void addFlushed(byte[] rowKey) {
                List<Long> list = this.flushedLoops;
                synchronized (list) {
                    this.flushedLoops.add(Bytes.toLong((byte[])rowKey));
                    this.flushedLoops.notifyAll();
                }
            }

            protected void persist(Mapper.Context output, long count, byte[][] prev, byte[][] current, byte[] id) throws IOException {
                for (int i = 0; i < current.length; ++i) {
                    if (i % 100 == 0) {
                        output.progress();
                    }
                    Put put = new Put(current[i]);
                    put.addColumn(FAMILY_NAME, COLUMN_PREV, prev == null ? NO_KEY : prev[i]);
                    if (count >= 0L) {
                        put.addColumn(FAMILY_NAME, COLUMN_COUNT, Bytes.toBytes((long)(count + (long)i)));
                    }
                    if (id != null) {
                        put.addColumn(FAMILY_NAME, COLUMN_CLIENT, id);
                    }
                    if (this.multipleUnevenColumnFamilies) {
                        put.addColumn(TINY_FAMILY_NAME, TINY_FAMILY_NAME, this.tinyValue);
                        put.addColumn(BIG_FAMILY_NAME, BIG_FAMILY_NAME, this.bigValue);
                    }
                    this.mutator.mutate((Mutation)put);
                }
                this.mutator.flush();
            }

            private void startWalkers(int numWalkers, Configuration conf, Mapper.Context context) {
                LOG.info("Starting " + numWalkers + " concurrent walkers");
                for (int i = 0; i < numWalkers; ++i) {
                    Thread walker = new Thread(new ContinuousConcurrentWalker(conf, context));
                    walker.start();
                    this.walkers.add(walker);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void joinWalkers() {
                this.walkersStop = true;
                List<Long> list = this.flushedLoops;
                synchronized (list) {
                    this.flushedLoops.notifyAll();
                }
                for (Thread walker : this.walkers) {
                    try {
                        walker.join();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }

            public static class ConcurrentWalker
            extends WalkerBase {
                Mapper.Context context;

                public ConcurrentWalker(Mapper.Context context) {
                    this.context = context;
                }

                public void run(long startKeyIn, long maxQueriesIn) throws IOException {
                    long maxQueries = maxQueriesIn > 0L ? maxQueriesIn : Long.MAX_VALUE;
                    byte[] startKey = Bytes.toBytes((long)startKeyIn);
                    Connection connection = ConnectionFactory.createConnection((Configuration)this.getConf());
                    Table table = connection.getTable(IntegrationTestBigLinkedList.getTableName(this.getConf()));
                    CINode node = ConcurrentWalker.findStartNode(table, startKey);
                    if (node == null) {
                        LOG.error("Start node not found: " + Bytes.toStringBinary((byte[])startKey));
                        throw new IOException("Start node not found: " + startKeyIn);
                    }
                    for (long numQueries = 0L; numQueries < maxQueries; ++numQueries) {
                        byte[] prev = node.prev;
                        long t1 = System.currentTimeMillis();
                        node = this.getNode(prev, table, node);
                        long t2 = System.currentTimeMillis();
                        if (node == null) {
                            LOG.error("ConcurrentWalker found UNDEFINED NODE: " + Bytes.toStringBinary((byte[])prev));
                            this.context.getCounter((Enum)Counts.UNDEFINED).increment(1L);
                            continue;
                        }
                        if (node.prev.length == NO_KEY.length) {
                            LOG.error("ConcurrentWalker found TERMINATING NODE: " + Bytes.toStringBinary((byte[])node.key));
                            this.context.getCounter((Enum)Counts.TERMINATING).increment(1L);
                            continue;
                        }
                        this.context.getCounter((Enum)Counts.SUCCESS).increment(1L);
                    }
                    table.close();
                    connection.close();
                }
            }

            public class ContinuousConcurrentWalker
            implements Runnable {
                ConcurrentWalker walker;
                Configuration conf;
                Mapper.Context context;

                public ContinuousConcurrentWalker(Configuration conf, Mapper.Context context) {
                    this.conf = conf;
                    this.context = context;
                }

                @Override
                public void run() {
                    while (!GeneratorMapper.this.walkersStop) {
                        try {
                            long node = this.selectLoop();
                            try {
                                this.walkLoop(node);
                            }
                            catch (IOException e) {
                                this.context.getCounter((Enum)Counts.IOEXCEPTION).increment(1L);
                                return;
                            }
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }

                private void walkLoop(long node) throws IOException {
                    this.walker = new ConcurrentWalker(this.context);
                    this.walker.setConf(this.conf);
                    this.walker.run(node, GeneratorMapper.this.wrap);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private long selectLoop() throws InterruptedException {
                    List<Long> list = GeneratorMapper.this.flushedLoops;
                    synchronized (list) {
                        while (GeneratorMapper.this.flushedLoops.isEmpty() && !GeneratorMapper.this.walkersStop) {
                            GeneratorMapper.this.flushedLoops.wait();
                        }
                        if (GeneratorMapper.this.walkersStop) {
                            throw new InterruptedException();
                        }
                        return GeneratorMapper.this.flushedLoops.get(ThreadLocalRandom.current().nextInt(GeneratorMapper.this.flushedLoops.size()));
                    }
                }
            }
        }

        static class OneFilePerMapperSFIF<K, V>
        extends SequenceFileInputFormat<K, V> {
            OneFilePerMapperSFIF() {
            }

            protected boolean isSplitable(JobContext context, Path filename) {
                return false;
            }
        }

        static class GeneratorInputFormat
        extends InputFormat<BytesWritable, NullWritable> {
            GeneratorInputFormat() {
            }

            public RecordReader<BytesWritable, NullWritable> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
                GeneratorRecordReader rr = new GeneratorRecordReader();
                rr.initialize(split, context);
                return rr;
            }

            public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
                int numMappers = job.getConfiguration().getInt(IntegrationTestBigLinkedList.GENERATOR_NUM_MAPPERS_KEY, 1);
                ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numMappers);
                for (int i = 0; i < numMappers; ++i) {
                    splits.add(new GeneratorInputSplit());
                }
                return splits;
            }

            static class GeneratorRecordReader
            extends RecordReader<BytesWritable, NullWritable> {
                private long count;
                private long numNodes;
                private Random64 rand = new Random64();

                GeneratorRecordReader() {
                }

                public void close() throws IOException {
                }

                public BytesWritable getCurrentKey() throws IOException, InterruptedException {
                    byte[] bytes = new byte[16];
                    this.rand.nextBytes(bytes);
                    return new BytesWritable(bytes);
                }

                public NullWritable getCurrentValue() throws IOException, InterruptedException {
                    return NullWritable.get();
                }

                public float getProgress() throws IOException, InterruptedException {
                    return (float)((double)this.count / (double)this.numNodes);
                }

                public void initialize(InputSplit arg0, TaskAttemptContext context) throws IOException, InterruptedException {
                    this.numNodes = context.getConfiguration().getLong(IntegrationTestBigLinkedList.GENERATOR_NUM_ROWS_PER_MAP_KEY, 25000000L);
                }

                public boolean nextKeyValue() throws IOException, InterruptedException {
                    return this.count++ < this.numNodes;
                }
            }

            static class GeneratorInputSplit
            extends InputSplit
            implements Writable {
                GeneratorInputSplit() {
                }

                public long getLength() throws IOException, InterruptedException {
                    return 1L;
                }

                public String[] getLocations() throws IOException, InterruptedException {
                    return new String[0];
                }

                public void readFields(DataInput arg0) throws IOException {
                }

                public void write(DataOutput arg0) throws IOException {
                }
            }
        }

        public static enum Counts {
            SUCCESS,
            TERMINATING,
            UNDEFINED,
            IOEXCEPTION;

        }
    }

    static class CINode {
        byte[] key;
        byte[] prev;
        String client;
        long count;

        CINode() {
        }
    }
}

