/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.IntegrationTestBase;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.NMapInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.collect.Sets;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestLoadAndVerify
extends IntegrationTestBase {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestLoadAndVerify.class);
    private static final String TEST_NAME = "IntegrationTestLoadAndVerify";
    private static final byte[] TEST_FAMILY = Bytes.toBytes((String)"f1");
    private static final byte[] TEST_QUALIFIER = Bytes.toBytes((String)"q1");
    private static final String NUM_TO_WRITE_KEY = "loadmapper.num_to_write";
    private static final long NUM_TO_WRITE_DEFAULT = 100000L;
    private static final String TABLE_NAME_KEY = "loadmapper.table";
    private static final String TABLE_NAME_DEFAULT = "table";
    private static final String NUM_BACKREFS_KEY = "loadmapper.backrefs";
    private static final int NUM_BACKREFS_DEFAULT = 50;
    private static final String NUM_MAP_TASKS_KEY = "loadmapper.map.tasks";
    private static final String NUM_REDUCE_TASKS_KEY = "verify.reduce.tasks";
    private static final int NUM_MAP_TASKS_DEFAULT = 200;
    private static final int NUM_REDUCE_TASKS_DEFAULT = 35;
    private static final int SCANNER_CACHING = 500;
    private static final int MISSING_ROWS_TO_LOG = 10;
    private String toRun = null;
    private String keysDir = null;
    static final String FOUND_GROUP_KEY = "Found";
    static final String SEARCHER_INPUTDIR_KEY = "searcher.keys.inputdir";

    @Override
    public void setUpCluster() throws Exception {
        this.util = this.getTestingUtil(this.getConf());
        this.util.initializeCluster(3);
        this.setConf(this.util.getConfiguration());
        if (!this.util.isDistributedCluster()) {
            this.getConf().setLong(NUM_TO_WRITE_KEY, 1000L);
            this.getConf().setInt(NUM_MAP_TASKS_KEY, 2);
            this.getConf().setInt(NUM_REDUCE_TASKS_KEY, 3);
            this.util.startMiniMapReduceCluster();
        }
    }

    @Override
    public void cleanUpCluster() throws Exception {
        super.cleanUpCluster();
        if (!this.util.isDistributedCluster()) {
            this.util.shutdownMiniMapReduceCluster();
        }
    }

    public static long swapLong(long value) {
        return ((value >> 0 & 0xFFL) << 56) + ((value >> 8 & 0xFFL) << 48) + ((value >> 16 & 0xFFL) << 40) + ((value >> 24 & 0xFFL) << 32) + ((value >> 32 & 0xFFL) << 24) + ((value >> 40 & 0xFFL) << 16) + ((value >> 48 & 0xFFL) << 8) + ((value >> 56 & 0xFFL) << 0);
    }

    protected Job doLoad(Configuration conf, HTableDescriptor htd) throws Exception {
        Path outputDir = this.getTestDir(TEST_NAME, "load-output");
        LOG.info("Load output dir: " + outputDir);
        NMapInputFormat.setNumMapTasks((Configuration)conf, (int)conf.getInt(NUM_MAP_TASKS_KEY, 200));
        conf.set(TABLE_NAME_KEY, htd.getTableName().getNameAsString());
        Job job = Job.getInstance((Configuration)conf);
        job.setJobName("IntegrationTestLoadAndVerify Load for " + htd.getTableName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        this.setMapperClass(job);
        job.setInputFormatClass(NMapInputFormat.class);
        job.setNumReduceTasks(0);
        IntegrationTestLoadAndVerify.setJobScannerConf(job);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        TableMapReduceUtil.addDependencyJars((Job)job);
        TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
        TableMapReduceUtil.initCredentials((Job)job);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        return job;
    }

    protected void setMapperClass(Job job) {
        job.setMapperClass(LoadMapper.class);
    }

    protected void doVerify(Configuration conf, HTableDescriptor htd) throws Exception {
        Path outputDir = this.getTestDir(TEST_NAME, "verify-output");
        LOG.info("Verify output dir: " + outputDir);
        Job job = Job.getInstance((Configuration)conf);
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setJobName("IntegrationTestLoadAndVerify Verification for " + htd.getTableName());
        IntegrationTestLoadAndVerify.setJobScannerConf(job);
        Scan scan = new Scan();
        TableMapReduceUtil.initTableMapperJob((String)htd.getTableName().getNameAsString(), (Scan)scan, VerifyMapper.class, BytesWritable.class, BytesWritable.class, (Job)job);
        TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{AbstractHBaseTool.class});
        int scannerCaching = conf.getInt("verify.scannercaching", 500);
        TableMapReduceUtil.setScannerCaching((Job)job, (int)scannerCaching);
        job.setReducerClass(VerifyReducer.class);
        job.setNumReduceTasks(conf.getInt(NUM_REDUCE_TASKS_KEY, 35));
        FileOutputFormat.setOutputPath((Job)job, (Path)outputDir);
        Assert.assertTrue((boolean)job.waitForCompletion(true));
        long numOutputRecords = job.getCounters().findCounter((Enum)Counters.ROWS_WRITTEN).getValue();
        Assert.assertEquals((long)0L, (long)numOutputRecords);
    }

    static SortedSet<byte[]> readKeysToSearch(Configuration conf) throws IOException, InterruptedException {
        Path keysInputDir = new Path(conf.get(SEARCHER_INPUTDIR_KEY));
        FileSystem fs = FileSystem.get((Configuration)conf);
        TreeSet<byte[]> result = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        if (!fs.exists(keysInputDir)) {
            throw new FileNotFoundException(keysInputDir.toString());
        }
        if (!fs.isDirectory(keysInputDir)) {
            FileStatus keyFileStatus = fs.getFileStatus(keysInputDir);
            IntegrationTestLoadAndVerify.readFileToSearch(conf, fs, keyFileStatus, result);
        } else {
            RemoteIterator iterator = fs.listFiles(keysInputDir, false);
            while (iterator.hasNext()) {
                LocatedFileStatus keyFileStatus = (LocatedFileStatus)iterator.next();
                if (keyFileStatus.getPath().getName().startsWith("_")) continue;
                IntegrationTestLoadAndVerify.readFileToSearch(conf, fs, (FileStatus)keyFileStatus, result);
            }
        }
        return result;
    }

    private static SortedSet<byte[]> readFileToSearch(Configuration conf, FileSystem fs, FileStatus keyFileStatus, SortedSet<byte[]> result) throws IOException, InterruptedException {
        try (FSDataInputStream in = fs.open(keyFileStatus.getPath());
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)in));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] parts = line.split("\\s+");
                if (parts.length >= 1) {
                    String key = parts[0];
                    result.add(Bytes.toBytesBinary((String)key));
                    continue;
                }
                LOG.info("Cannot parse key from: " + line);
            }
        }
        return result;
    }

    private int doSearch(Configuration conf, String keysDir) throws Exception {
        Path inputDir = new Path(keysDir);
        this.getConf().set(SEARCHER_INPUTDIR_KEY, inputDir.toString());
        SortedSet<byte[]> keys = IntegrationTestLoadAndVerify.readKeysToSearch(this.getConf());
        if (keys.isEmpty()) {
            throw new RuntimeException("No keys to find");
        }
        LOG.info("Count of keys to find: " + keys.size());
        for (byte[] key : keys) {
            LOG.info("Key: " + Bytes.toStringBinary((byte[])key));
        }
        Path walsDir = new Path(CommonFSUtils.getWALRootDir((Configuration)this.getConf()), "WALs");
        Path oldWalsDir = new Path(CommonFSUtils.getWALRootDir((Configuration)this.getConf()), "oldWALs");
        LOG.info("Running Search with keys inputDir=" + inputDir + " against " + this.getConf().get("hbase.rootdir"));
        int ret = ToolRunner.run((Tool)new WALSearcher(this.getConf()), (String[])new String[]{walsDir.toString(), ""});
        if (ret != 0) {
            return ret;
        }
        return ToolRunner.run((Tool)new WALSearcher(this.getConf()), (String[])new String[]{oldWalsDir.toString(), ""});
    }

    private static void setJobScannerConf(Job job) {
        job.getConfiguration().setBoolean("hbase.client.log.scanner.activity", true);
        long lpr = job.getConfiguration().getLong(NUM_TO_WRITE_KEY, 100000L) / 100L;
        job.getConfiguration().setInt("hbase.mapreduce.log.scanner.rowcount", (int)lpr);
    }

    public Path getTestDir(String testName, String subdir) throws IOException {
        Path testDir = this.util.getDataTestDirOnTestFS(testName);
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        fs.deleteOnExit(testDir);
        return new Path(new Path(testDir, testName), subdir);
    }

    @Test
    public void testLoadAndVerify() throws Exception {
        HTableDescriptor htd = new HTableDescriptor(TableName.valueOf((String)TEST_NAME));
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        Admin admin = this.getTestingUtil(this.getConf()).getAdmin();
        admin.createTable((TableDescriptor)htd, Bytes.toBytes((long)0L), Bytes.toBytes((long)-1L), 40);
        this.doLoad(this.getConf(), htd);
        this.doVerify(this.getConf(), htd);
        this.getTestingUtil(this.getConf()).deleteTable(htd.getTableName());
    }

    public void printUsage() {
        this.printUsage(((Object)((Object)this)).getClass().getSimpleName() + " <options> [-Doptions] <load|verify|loadAndVerify|search>", "Options", "");
        System.err.println("");
        System.err.println("  Loads a table with row dependencies and verifies the dependency chains");
        System.err.println("Options");
        System.err.println("  -Dloadmapper.table=<name>        Table to write/verify (default autogen)");
        System.err.println("  -Dloadmapper.backrefs=<n>        Number of backreferences per row (default 50)");
        System.err.println("  -Dloadmapper.num_to_write=<n>    Number of rows per mapper (default 100,000 per mapper)");
        System.err.println("  -Dloadmapper.deleteAfter=<bool>  Delete after a successful verify (default true)");
        System.err.println("  -Dloadmapper.numPresplits=<n>    Number of presplit regions to start with (default 40)");
        System.err.println("  -Dloadmapper.map.tasks=<n>       Number of map tasks for load (default 200)");
        System.err.println("  -Dverify.reduce.tasks=<n>        Number of reduce tasks for verify (default 35)");
        System.err.println("  -Dverify.scannercaching=<n>      Number hbase scanner caching rows to read (default 50)");
    }

    @Override
    protected void processOptions(CommandLine cmd) {
        super.processOptions(cmd);
        String[] args = cmd.getArgs();
        if (args == null || args.length < 1) {
            this.printUsage();
            throw new RuntimeException("Incorrect Number of args.");
        }
        this.toRun = args[0];
        if (this.toRun.equalsIgnoreCase("search") && args.length > 1) {
            this.keysDir = args[1];
        }
    }

    @Override
    public int runTestFromCommandLine() throws Exception {
        IntegrationTestingUtility.setUseDistributedCluster(this.getConf());
        boolean doLoad = false;
        boolean doVerify = false;
        boolean doSearch = false;
        boolean doDelete = this.getConf().getBoolean("loadmapper.deleteAfter", true);
        int numPresplits = this.getConf().getInt("loadmapper.numPresplits", 40);
        if (this.toRun.equalsIgnoreCase("load")) {
            doLoad = true;
        } else if (this.toRun.equalsIgnoreCase("verify")) {
            doVerify = true;
        } else if (this.toRun.equalsIgnoreCase("loadAndVerify")) {
            doLoad = true;
            doVerify = true;
        } else if (this.toRun.equalsIgnoreCase("search")) {
            doLoad = false;
            doVerify = false;
            doSearch = true;
            if (this.keysDir == null) {
                System.err.println("Usage: search <KEYS_DIR>]");
                return 1;
            }
        } else {
            System.err.println("Invalid argument " + this.toRun);
            this.printUsage();
            return 1;
        }
        TableName table = this.getTablename();
        HTableDescriptor htd = new HTableDescriptor(table);
        htd.addFamily(new HColumnDescriptor(TEST_FAMILY));
        if (doLoad) {
            try (Connection conn = ConnectionFactory.createConnection((Configuration)this.getConf());
                 Admin admin = conn.getAdmin();){
                admin.createTable((TableDescriptor)htd, Bytes.toBytes((long)0L), Bytes.toBytes((long)-1L), numPresplits);
                this.doLoad(this.getConf(), htd);
            }
        }
        if (doVerify) {
            this.doVerify(this.getConf(), htd);
            if (doDelete) {
                this.getTestingUtil(this.getConf()).deleteTable(htd.getTableName());
            }
        }
        if (doSearch) {
            return this.doSearch(this.getConf(), this.keysDir);
        }
        return 0;
    }

    @Override
    public TableName getTablename() {
        return TableName.valueOf((String)this.getConf().get(TABLE_NAME_KEY, TEST_NAME));
    }

    @Override
    protected Set<String> getColumnFamilies() {
        return Sets.newHashSet((Object[])new String[]{Bytes.toString((byte[])TEST_FAMILY)});
    }

    public static void main(String[] argv) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        int ret = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestLoadAndVerify(), (String[])argv);
        System.exit(ret);
    }

    public static class WALSearcher
    extends WALPlayer {
        public WALSearcher(Configuration conf) {
            super(conf);
        }

        public Job createSubmittableJob(String[] args) throws IOException {
            Job job = super.createSubmittableJob(args);
            job.setJarByClass(WALMapperSearcher.class);
            job.setMapperClass(WALMapperSearcher.class);
            job.setOutputFormatClass(NullOutputFormat.class);
            return job;
        }

        public static class WALMapperSearcher
        extends WALPlayer.WALMapper {
            private SortedSet<byte[]> keysToFind;
            private AtomicInteger rows = new AtomicInteger(0);

            public void setup(Mapper.Context context) throws IOException {
                super.setup(context);
                try {
                    this.keysToFind = IntegrationTestLoadAndVerify.readKeysToSearch(context.getConfiguration());
                    LOG.info("Loaded keys to find: count=" + this.keysToFind.size());
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException(e.toString());
                }
            }

            protected boolean filter(Mapper.Context context, Cell cell) {
                byte[] row = new byte[cell.getRowLength()];
                System.arraycopy(cell.getRowArray(), cell.getRowOffset(), row, 0, cell.getRowLength());
                boolean b = this.keysToFind.contains(row);
                if (b) {
                    String keyStr = Bytes.toStringBinary((byte[])row);
                    try {
                        LOG.info("Found cell=" + cell + " , walKey=" + context.getCurrentKey());
                    }
                    catch (IOException | InterruptedException e) {
                        LOG.warn(e.toString(), (Throwable)e);
                    }
                    if (this.rows.addAndGet(1) < 10) {
                        context.getCounter(IntegrationTestLoadAndVerify.FOUND_GROUP_KEY, keyStr).increment(1L);
                    }
                    context.getCounter(IntegrationTestLoadAndVerify.FOUND_GROUP_KEY, "CELL_WITH_MISSING_ROW").increment(1L);
                }
                return b;
            }
        }
    }

    public static class VerifyReducer
    extends Reducer<BytesWritable, BytesWritable, Text, Text> {
        private Counter refsChecked;
        private Counter rowsWritten;

        public void setup(Reducer.Context context) throws IOException {
            this.refsChecked = context.getCounter((Enum)Counters.REFERENCES_CHECKED);
            this.rowsWritten = context.getCounter((Enum)Counters.ROWS_WRITTEN);
        }

        protected void reduce(BytesWritable referredRow, Iterable<BytesWritable> referrers, Reducer.Context ctx) throws IOException, InterruptedException {
            boolean gotOriginalRow = false;
            int refCount = 0;
            for (BytesWritable ref : referrers) {
                if (ref.getLength() == 0) {
                    assert (!gotOriginalRow);
                    gotOriginalRow = true;
                    continue;
                }
                ++refCount;
            }
            this.refsChecked.increment((long)refCount);
            if (!gotOriginalRow) {
                String parsedRow = this.makeRowReadable(referredRow.getBytes(), referredRow.getLength());
                String binRow = Bytes.toStringBinary((byte[])referredRow.getBytes(), (int)0, (int)referredRow.getLength());
                LOG.error("Reference error row " + parsedRow);
                ctx.write((Object)new Text(binRow), (Object)new Text(parsedRow));
                this.rowsWritten.increment(1L);
            }
        }

        private String makeRowReadable(byte[] bytes, int length) {
            long rowIdx = IntegrationTestLoadAndVerify.swapLong(Bytes.toLong((byte[])bytes, (int)0));
            String suffix = Bytes.toString((byte[])bytes, (int)8, (int)(length - 8));
            return "Row #" + rowIdx + " suffix " + suffix;
        }
    }

    public static class VerifyMapper
    extends TableMapper<BytesWritable, BytesWritable> {
        static final BytesWritable EMPTY = new BytesWritable(HConstants.EMPTY_BYTE_ARRAY);

        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            BytesWritable bwKey = new BytesWritable(key.get());
            BytesWritable bwVal = new BytesWritable();
            for (Cell kv : value.listCells()) {
                if (Bytes.compareTo((byte[])TEST_QUALIFIER, (int)0, (int)TEST_QUALIFIER.length, (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength()) == 0) {
                    context.write((Object)bwKey, (Object)EMPTY);
                    continue;
                }
                bwVal.set(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
                context.write((Object)bwVal, (Object)bwKey);
            }
        }
    }

    public static class LoadMapper
    extends Mapper<NullWritable, NullWritable, NullWritable, NullWritable> {
        protected long recordsToWrite;
        protected Connection connection;
        protected BufferedMutator mutator;
        protected Configuration conf;
        protected int numBackReferencesPerRow;
        protected String shortTaskId;
        protected Counter rowsWritten;
        protected Counter refsWritten;

        public void setup(Mapper.Context context) throws IOException {
            this.conf = context.getConfiguration();
            this.recordsToWrite = this.conf.getLong(IntegrationTestLoadAndVerify.NUM_TO_WRITE_KEY, 100000L);
            String tableName = this.conf.get(IntegrationTestLoadAndVerify.TABLE_NAME_KEY, IntegrationTestLoadAndVerify.TABLE_NAME_DEFAULT);
            this.numBackReferencesPerRow = this.conf.getInt(IntegrationTestLoadAndVerify.NUM_BACKREFS_KEY, 50);
            this.connection = ConnectionFactory.createConnection((Configuration)this.conf);
            this.mutator = this.connection.getBufferedMutator(new BufferedMutatorParams(TableName.valueOf((String)tableName)).writeBufferSize(0x400000L));
            String taskId = this.conf.get("mapreduce.task.attempt.id");
            Matcher matcher = Pattern.compile(".+_m_(\\d+_\\d+)").matcher(taskId);
            if (!matcher.matches()) {
                throw new RuntimeException("Strange task ID: " + taskId);
            }
            this.shortTaskId = matcher.group(1);
            this.rowsWritten = context.getCounter((Enum)Counters.ROWS_WRITTEN);
            this.refsWritten = context.getCounter((Enum)Counters.REFERENCES_WRITTEN);
        }

        public void cleanup(Mapper.Context context) throws IOException {
            this.mutator.close();
            this.connection.close();
        }

        protected void map(NullWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            String suffix = "/" + this.shortTaskId;
            byte[] row = Bytes.add((byte[])new byte[8], (byte[])Bytes.toBytes((String)suffix));
            int BLOCK_SIZE = (int)(this.recordsToWrite / 100L);
            ThreadLocalRandom rand = ThreadLocalRandom.current();
            long i = 0L;
            while (i < this.recordsToWrite) {
                long blockStart = i;
                for (long idxInBlock = 0L; idxInBlock < (long)BLOCK_SIZE && i < this.recordsToWrite; ++idxInBlock, ++i) {
                    long byteSwapped = IntegrationTestLoadAndVerify.swapLong(i);
                    Bytes.putLong((byte[])row, (int)0, (long)byteSwapped);
                    Put p = new Put(row);
                    p.addColumn(TEST_FAMILY, TEST_QUALIFIER, HConstants.EMPTY_BYTE_ARRAY);
                    if (blockStart > 0L) {
                        for (int j = 0; j < this.numBackReferencesPerRow; ++j) {
                            long referredRow = blockStart - (long)BLOCK_SIZE + (long)((Random)rand).nextInt(BLOCK_SIZE);
                            Bytes.putLong((byte[])row, (int)0, (long)IntegrationTestLoadAndVerify.swapLong(referredRow));
                            p.addColumn(TEST_FAMILY, row, HConstants.EMPTY_BYTE_ARRAY);
                        }
                        this.refsWritten.increment(1L);
                    }
                    this.rowsWritten.increment(1L);
                    this.mutator.mutate((Mutation)p);
                    if (i % 100L != 0L) continue;
                    context.setStatus("Written " + i + "/" + this.recordsToWrite + " records");
                    context.progress();
                }
                this.mutator.flush();
            }
        }
    }

    private static enum Counters {
        ROWS_WRITTEN,
        REFERENCES_WRITTEN,
        REFERENCES_CHECKED;

    }
}

