/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.test;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.zookeeper.RecoverableZooKeeper;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.org.apache.commons.cli.CommandLine;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.junit.Assert;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestZKAndFSPermissions
extends AbstractHBaseTool {
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestZKAndFSPermissions.class);
    private String superUser;
    private String masterPrincipal;
    private boolean isForce;
    private String fsPerms;
    private boolean skipFSCheck;
    private boolean skipZKCheck;
    public static final String FORCE_CHECK_ARG = "f";
    public static final String PRINCIPAL_ARG = "p";
    public static final String SUPERUSER_ARG = "s";
    public static final String FS_PERMS = "fs_perms";
    public static final String SKIP_CHECK_FS = "skip_fs_check";
    public static final String SKIP_CHECK_ZK = "skip_zk_check";

    public void setConf(Configuration conf) {
        super.setConf(conf);
    }

    protected void addOptions() {
        this.addOptNoArg(FORCE_CHECK_ARG, "Whether to skip configuration lookup and assume a secure setup");
        this.addOptWithArg(PRINCIPAL_ARG, "The principal for zk authorization");
        this.addOptWithArg(SUPERUSER_ARG, "The principal for super user");
        this.addOptWithArg(FS_PERMS, "FS permissions, ex. 700, 750, etc. Defaults to 700");
        this.addOptNoArg(SKIP_CHECK_FS, "Whether to skip checking FS permissions");
        this.addOptNoArg(SKIP_CHECK_ZK, "Whether to skip checking ZK permissions");
    }

    protected void processOptions(CommandLine cmd) {
        this.isForce = cmd.hasOption(FORCE_CHECK_ARG);
        this.masterPrincipal = this.getShortUserName(this.conf.get("hbase.master.kerberos.principal"));
        this.superUser = cmd.getOptionValue(SUPERUSER_ARG, this.conf.get("hbase.superuser"));
        this.masterPrincipal = cmd.getOptionValue(PRINCIPAL_ARG, this.masterPrincipal);
        this.fsPerms = cmd.getOptionValue(FS_PERMS, "700");
        this.skipFSCheck = cmd.hasOption(SKIP_CHECK_FS);
        this.skipZKCheck = cmd.hasOption(SKIP_CHECK_ZK);
    }

    private String getShortUserName(String principal) {
        for (int i = 0; i < principal.length(); ++i) {
            if (principal.charAt(i) != '/' && principal.charAt(i) != '@') continue;
            return principal.substring(0, i);
        }
        return principal;
    }

    protected int doWork() throws Exception {
        if (!this.isForce && !"kerberos".equalsIgnoreCase(this.conf.get("hbase.security.authentication"))) {
            LOG.warn("hbase.security.authentication is not kerberos, and -f is not supplied. Skip running the test");
            return 0;
        }
        if (!this.skipZKCheck) {
            this.testZNodeACLs();
        }
        if (!this.skipFSCheck) {
            this.testFSPerms();
        }
        return 0;
    }

    private void testZNodeACLs() throws IOException, KeeperException, InterruptedException {
        ZKWatcher watcher = new ZKWatcher(this.conf, "IntegrationTestZnodeACLs", null);
        RecoverableZooKeeper zk = ZKUtil.connect((Configuration)this.conf, (Watcher)watcher);
        String baseZNode = watcher.getZNodePaths().baseZNode;
        LOG.info("");
        LOG.info("***********************************************************************************");
        LOG.info("Checking ZK permissions, root znode: " + baseZNode);
        LOG.info("***********************************************************************************");
        LOG.info("");
        this.checkZnodePermsRecursive(watcher, zk, baseZNode);
        LOG.info("Checking ZK permissions: SUCCESS");
    }

    private void checkZnodePermsRecursive(ZKWatcher watcher, RecoverableZooKeeper zk, String znode) throws KeeperException, InterruptedException {
        block3: {
            boolean expectedWorldReadable = watcher.getZNodePaths().isClientReadable(znode);
            this.assertZnodePerms(zk, znode, expectedWorldReadable);
            try {
                List children = zk.getChildren(znode, false);
                for (String child : children) {
                    this.checkZnodePermsRecursive(watcher, zk, ZNodePaths.joinZNode((String)znode, (String)child));
                }
            }
            catch (KeeperException ke) {
                if (ke.code() == KeeperException.Code.NOAUTH || ke.code() == KeeperException.Code.NONODE) break block3;
                throw ke;
            }
        }
    }

    private void assertZnodePerms(RecoverableZooKeeper zk, String znode, boolean expectedWorldReadable) throws KeeperException, InterruptedException {
        List acls;
        Stat stat = new Stat();
        try {
            acls = zk.getZooKeeper().getACL(znode, stat);
        }
        catch (KeeperException.NoNodeException ex) {
            LOG.debug("Caught exception for missing znode", (Throwable)ex);
            return;
        }
        String[] superUsers = this.superUser == null ? null : this.superUser.split(",");
        LOG.info("Checking ACLs for znode znode:" + znode + " acls:" + acls);
        for (ACL acl : acls) {
            int perms = acl.getPerms();
            Id id = acl.getId();
            if (ZooDefs.Ids.ANYONE_ID_UNSAFE.equals((Object)id)) {
                Assert.assertTrue((boolean)expectedWorldReadable);
                Assert.assertEquals((long)perms, (long)1L);
                continue;
            }
            if (superUsers != null && ZKWatcher.isSuperUserId((String[])superUsers, (Id)id)) {
                Assert.assertEquals((long)perms, (long)31L);
                continue;
            }
            if (new Id("sasl", this.masterPrincipal).equals((Object)id)) {
                Assert.assertEquals((long)perms, (long)31L);
                continue;
            }
            Assert.fail((String)("An ACL is found which is not expected for the znode:" + znode + " , ACL:" + acl));
        }
    }

    private void testFSPerms() throws IOException {
        Path rootDir = CommonFSUtils.getRootDir((Configuration)this.conf);
        LOG.info("");
        LOG.info("***********************************************************************************");
        LOG.info("Checking FS permissions for root dir:" + rootDir);
        LOG.info("***********************************************************************************");
        LOG.info("");
        FileSystem fs = rootDir.getFileSystem(this.conf);
        short expectedPerms = Short.valueOf(this.fsPerms, 8);
        Assert.assertEquals((Object)FsPermission.createImmutable((short)expectedPerms), (Object)fs.getFileStatus(rootDir).getPermission());
        LOG.info("Checking FS permissions: SUCCESS");
    }

    public static void main(String[] args) throws Exception {
        Configuration configuration = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(configuration);
        IntegrationTestZKAndFSPermissions tool = new IntegrationTestZKAndFSPermissions();
        int ret = ToolRunner.run((Configuration)configuration, (Tool)tool, (String[])args);
        System.exit(ret);
    }
}

