/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ClusterManager;
import org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hadoop.hbase.HBaseCluster;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class DistributedHBaseCluster
extends HBaseCluster {
    private Admin admin;
    private final Connection connection;
    private ClusterManager clusterManager;
    private Set<ServerName> killedRegionServers = new HashSet<ServerName>();

    public DistributedHBaseCluster(Configuration conf, ClusterManager clusterManager) throws IOException {
        super(conf);
        this.clusterManager = clusterManager;
        this.connection = ConnectionFactory.createConnection((Configuration)conf);
        this.admin = this.connection.getAdmin();
        this.initialClusterStatus = this.getClusterMetrics();
    }

    public void setClusterManager(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public ClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public ClusterMetrics getClusterMetrics() throws IOException {
        return this.admin.getClusterMetrics();
    }

    public ClusterMetrics getInitialClusterMetrics() throws IOException {
        return this.initialClusterStatus;
    }

    public void close() throws IOException {
        if (this.admin != null) {
            this.admin.close();
        }
        if (this.connection != null && !this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public AdminProtos.AdminService.BlockingInterface getAdminProtocol(ServerName serverName) throws IOException {
        return ((ClusterConnection)this.connection).getAdmin(serverName);
    }

    public ClientProtos.ClientService.BlockingInterface getClientProtocol(ServerName serverName) throws IOException {
        return ((ClusterConnection)this.connection).getClient(serverName);
    }

    public void startRegionServer(String hostname, int port) throws IOException {
        LOG.info("Starting RS on: {}", (Object)hostname);
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_REGIONSERVER, hostname, port);
    }

    public void killRegionServer(ServerName serverName) throws IOException {
        LOG.info("Aborting RS: {}", (Object)serverName.getServerName());
        this.killedRegionServers.add(serverName);
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public boolean isKilledRS(ServerName serverName) {
        return this.killedRegionServers.contains(serverName);
    }

    public void stopRegionServer(ServerName serverName) throws IOException {
        LOG.info("Stopping RS: {}", (Object)serverName.getServerName());
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForRegionServerToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName, timeout);
    }

    public void suspendRegionServer(ServerName serverName) throws IOException {
        LOG.info("Suspend RS: {}", (Object)serverName.getServerName());
        this.clusterManager.suspend(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public void resumeRegionServer(ServerName serverName) throws IOException {
        LOG.info("Resume RS: {}", (Object)serverName.getServerName());
        this.clusterManager.resume(ClusterManager.ServiceType.HBASE_REGIONSERVER, serverName.getHostname(), serverName.getPort());
    }

    public void startZkNode(String hostname, int port) throws IOException {
        LOG.info("Starting ZooKeeper node on: {}", (Object)hostname);
        this.clusterManager.start(ClusterManager.ServiceType.ZOOKEEPER_SERVER, hostname, port);
    }

    public void killZkNode(ServerName serverName) throws IOException {
        LOG.info("Aborting ZooKeeper node on: {}", (Object)serverName.getServerName());
        this.clusterManager.kill(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName.getHostname(), serverName.getPort());
    }

    public void stopZkNode(ServerName serverName) throws IOException {
        LOG.info("Stopping ZooKeeper node: {}", (Object)serverName.getServerName());
        this.clusterManager.stop(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForZkNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName, timeout);
    }

    public void waitForZkNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.ZOOKEEPER_SERVER, serverName, timeout);
    }

    public void startDataNode(ServerName serverName) throws IOException {
        LOG.info("Starting data node on: {}", (Object)serverName.getServerName());
        this.clusterManager.start(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void killDataNode(ServerName serverName) throws IOException {
        LOG.info("Aborting data node on: {}", (Object)serverName.getServerName());
        this.clusterManager.kill(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void stopDataNode(ServerName serverName) throws IOException {
        LOG.info("Stopping data node on: {}", (Object)serverName.getServerName());
        this.clusterManager.stop(ClusterManager.ServiceType.HADOOP_DATANODE, serverName.getHostname(), serverName.getPort());
    }

    public void waitForDataNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.HADOOP_DATANODE, serverName, timeout);
    }

    public void waitForDataNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HADOOP_DATANODE, serverName, timeout);
    }

    public void startNameNode(ServerName serverName) throws IOException {
        LOG.info("Starting name node on: {}", (Object)serverName.getServerName());
        this.clusterManager.start(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void killNameNode(ServerName serverName) throws IOException {
        LOG.info("Aborting name node on: {}", (Object)serverName.getServerName());
        this.clusterManager.kill(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void stopNameNode(ServerName serverName) throws IOException {
        LOG.info("Stopping name node on: {}", (Object)serverName.getServerName());
        this.clusterManager.stop(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName.getHostname(), serverName.getPort());
    }

    public void waitForNameNodeToStart(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStart(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName, timeout);
    }

    public void waitForNameNodeToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HADOOP_NAMENODE, serverName, timeout);
    }

    private void waitForServiceToStop(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info("Waiting for service: {} to stop: {}", (Object)service, (Object)serverName.getServerName());
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start < timeout) {
            if (!this.clusterManager.isRunning(service, serverName.getHostname(), serverName.getPort())) {
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("Timed-out waiting for service to stop: " + serverName);
    }

    private void waitForServiceToStart(ClusterManager.ServiceType service, ServerName serverName, long timeout) throws IOException {
        LOG.info("Waiting for service: {} to start: ", (Object)service, (Object)serverName.getServerName());
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start < timeout) {
            if (this.clusterManager.isRunning(service, serverName.getHostname(), serverName.getPort())) {
                return;
            }
            Threads.sleep((long)100L);
        }
        throw new IOException("Timed-out waiting for service to start: " + serverName);
    }

    public MasterProtos.MasterService.BlockingInterface getMasterAdminService() throws IOException {
        return ((ClusterConnection)this.connection).getMaster();
    }

    public void startMaster(String hostname, int port) throws IOException {
        LOG.info("Starting Master on: {}:{}", (Object)hostname, (Object)port);
        this.clusterManager.start(ClusterManager.ServiceType.HBASE_MASTER, hostname, port);
    }

    public void killMaster(ServerName serverName) throws IOException {
        LOG.info("Aborting Master: {}", (Object)serverName.getServerName());
        this.clusterManager.kill(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname(), serverName.getPort());
    }

    public void stopMaster(ServerName serverName) throws IOException {
        LOG.info("Stopping Master: {}", (Object)serverName.getServerName());
        this.clusterManager.stop(ClusterManager.ServiceType.HBASE_MASTER, serverName.getHostname(), serverName.getPort());
    }

    public void waitForMasterToStop(ServerName serverName, long timeout) throws IOException {
        this.waitForServiceToStop(ClusterManager.ServiceType.HBASE_MASTER, serverName, timeout);
    }

    public boolean waitForActiveAndReadyMaster(long timeout) throws IOException {
        long start = EnvironmentEdgeManager.currentTime();
        while (EnvironmentEdgeManager.currentTime() - start < timeout) {
            try {
                this.getMasterAdminService();
                return true;
            }
            catch (MasterNotRunningException m) {
                LOG.warn("Master not started yet " + (Object)((Object)m));
            }
            catch (ZooKeeperConnectionException e) {
                LOG.warn("Failed to connect to ZK " + (Object)((Object)e));
            }
            Threads.sleep((long)1000L);
        }
        return false;
    }

    public ServerName getServerHoldingRegion(TableName tn, byte[] regionName) throws IOException {
        byte[] startKey = RegionInfo.getStartKey((byte[])regionName);
        HRegionLocation regionLoc = null;
        try (RegionLocator locator = this.connection.getRegionLocator(tn);){
            regionLoc = locator.getRegionLocation(startKey, true);
        }
        if (regionLoc == null) {
            LOG.warn("Cannot find region server holding region {}", (Object)Bytes.toStringBinary((byte[])regionName));
            return null;
        }
        return regionLoc.getServerName();
    }

    public void waitUntilShutDown() {
        throw new RuntimeException("Not implemented");
    }

    public void shutdown() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    public boolean isDistributedCluster() {
        return true;
    }

    public boolean restoreClusterMetrics(ClusterMetrics initial) throws IOException {
        ClusterMetrics current = this.getClusterMetrics();
        LOG.info("Restoring cluster - started");
        boolean success = true;
        success = this.restoreMasters(initial, current) && success;
        success = this.restoreRegionServers(initial, current) && success;
        success = this.restoreAdmin() && success;
        LOG.info("Restoring cluster - done");
        return success;
    }

    protected boolean restoreMasters(ClusterMetrics initial, ClusterMetrics current) {
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        ServerName initMaster = initial.getMasterName();
        if (!ServerName.isSameAddress((ServerName)initMaster, (ServerName)current.getMasterName())) {
            LOG.info("Restoring cluster - Initial active master : {} has changed to : {}", (Object)initMaster.getAddress(), (Object)current.getMasterName().getAddress());
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, initMaster.getHostname(), initMaster.getPort())) {
                    LOG.info("Restoring cluster - starting initial active master at:{}", (Object)initMaster.getAddress());
                    this.startMaster(initMaster.getHostname(), initMaster.getPort());
                }
                for (ServerName currentBackup : current.getBackupMasterNames()) {
                    if (ServerName.isSameAddress((ServerName)currentBackup, (ServerName)initMaster)) continue;
                    LOG.info("Restoring cluster - stopping backup master: {}", (Object)currentBackup);
                    this.stopMaster(currentBackup);
                }
                LOG.info("Restoring cluster - stopping active master: {}", (Object)current.getMasterName());
                this.stopMaster(current.getMasterName());
                this.waitForActiveAndReadyMaster();
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
            for (ServerName backup : initial.getBackupMasterNames()) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, backup.getHostname(), backup.getPort())) continue;
                    LOG.info("Restoring cluster - starting initial backup master: {}", (Object)backup.getAddress());
                    this.startMaster(backup.getHostname(), backup.getPort());
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        } else {
            TreeSet<ServerName> toStart = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
            TreeSet<ServerName> toKill = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
            toStart.addAll(initial.getBackupMasterNames());
            toKill.addAll(current.getBackupMasterNames());
            for (ServerName server : current.getBackupMasterNames()) {
                toStart.remove(server);
            }
            for (ServerName server : initial.getBackupMasterNames()) {
                toKill.remove(server);
            }
            for (ServerName sn : toStart) {
                try {
                    if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, sn.getHostname(), sn.getPort())) continue;
                    LOG.info("Restoring cluster - starting initial backup master: {}", (Object)sn.getAddress());
                    this.startMaster(sn.getHostname(), sn.getPort());
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
            for (ServerName sn : toKill) {
                try {
                    if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_MASTER, sn.getHostname(), sn.getPort())) continue;
                    LOG.info("Restoring cluster - stopping backup master: {}", (Object)sn.getAddress());
                    this.stopMaster(sn);
                }
                catch (IOException ex) {
                    deferred.add(ex);
                }
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn("Restoring cluster - restoring region servers reported {} errors:", (Object)deferred.size());
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(Objects.toString(deferred.get(i)));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreRegionServers(ClusterMetrics initial, ClusterMetrics current) {
        TreeSet<ServerName> toStart = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
        TreeSet<ServerName> toKill = new TreeSet<ServerName>(new ServerNameIgnoreStartCodeComparator());
        toStart.addAll(initial.getLiveServerMetrics().keySet());
        toKill.addAll(current.getLiveServerMetrics().keySet());
        ServerName master = initial.getMasterName();
        for (Object server : current.getLiveServerMetrics().keySet()) {
            toStart.remove(server);
        }
        for (Object server : initial.getLiveServerMetrics().keySet()) {
            toKill.remove(server);
        }
        ArrayList<IOException> deferred = new ArrayList<IOException>();
        for (ServerName sn : toStart) {
            try {
                if (this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, sn.getHostname(), sn.getPort()) || master.getPort() == sn.getPort()) continue;
                LOG.info("Restoring cluster - starting initial region server: {}", (Object)sn.getAddress());
                this.startRegionServer(sn.getHostname(), sn.getPort());
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        for (ServerName sn : toKill) {
            try {
                if (!this.clusterManager.isRunning(ClusterManager.ServiceType.HBASE_REGIONSERVER, sn.getHostname(), sn.getPort()) || master.getPort() == sn.getPort()) continue;
                LOG.info("Restoring cluster - stopping initial region server: {}", (Object)sn.getAddress());
                this.stopRegionServer(sn);
            }
            catch (IOException ex) {
                deferred.add(ex);
            }
        }
        if (!deferred.isEmpty()) {
            LOG.warn("Restoring cluster - restoring region servers reported {} errors:", (Object)deferred.size());
            for (int i = 0; i < deferred.size() && i < 3; ++i) {
                LOG.warn(Objects.toString(deferred.get(i)));
            }
        }
        return deferred.isEmpty();
    }

    protected boolean restoreAdmin() throws IOException {
        try {
            this.admin.close();
        }
        catch (IOException ioe) {
            LOG.warn("While closing the old connection", (Throwable)ioe);
        }
        this.admin = this.connection.getAdmin();
        LOG.info("Added new HBaseAdmin");
        return true;
    }

    private static class ServerNameIgnoreStartCodeComparator
    implements Comparator<ServerName> {
        private ServerNameIgnoreStartCodeComparator() {
        }

        @Override
        public int compare(ServerName o1, ServerName o2) {
            int compare = o1.getHostname().compareToIgnoreCase(o2.getHostname());
            if (compare != 0) {
                return compare;
            }
            compare = o1.getPort() - o2.getPort();
            if (compare != 0) {
                return compare;
            }
            return 0;
        }
    }
}

