/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.TestImportTsv;
import org.apache.hadoop.hbase.testclassification.IntegrationTests;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hbase.thirdparty.com.google.common.base.Splitter;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={IntegrationTests.class})
public class IntegrationTestImportTsv
extends Configured
implements Tool {
    private static final String NAME = IntegrationTestImportTsv.class.getSimpleName();
    private static final Logger LOG = LoggerFactory.getLogger(IntegrationTestImportTsv.class);
    private static final String GENERATED_HFILE_FOLDER_PARAM_KEY = "IntegrationTestImportTsv.generatedHFileFolder";
    protected static final String simple_tsv = "row1\t1\tc1\tc2\nrow2\t1\tc1\tc2\nrow3\t1\tc1\tc2\nrow4\t1\tc1\tc2\nrow5\t1\tc1\tc2\nrow6\t1\tc1\tc2\nrow7\t1\tc1\tc2\nrow8\t1\tc1\tc2\nrow9\t1\tc1\tc2\nrow10\t1\tc1\tc2\n";
    @Rule
    public TestName name = new TestName();
    protected static final Set<KeyValue> simple_expected = new TreeSet<KeyValue>((Comparator)CellComparator.getInstance()){
        private static final long serialVersionUID = 1L;
        {
            byte[] family = Bytes.toBytes((String)"d");
            for (String line : Splitter.on((char)'\n').split((CharSequence)IntegrationTestImportTsv.simple_tsv)) {
                String[] row = line.split("\t");
                byte[] key = Bytes.toBytes((String)row[0]);
                long ts = Long.parseLong(row[1]);
                byte[][] fields = new byte[][]{Bytes.toBytes((String)row[2]), Bytes.toBytes((String)row[3])};
                this.add(new KeyValue(key, family, fields[0], ts, KeyValue.Type.Put, fields[0]));
                this.add(new KeyValue(key, family, fields[1], ts, KeyValue.Type.Put, fields[1]));
            }
        }
    };
    protected static IntegrationTestingUtility util = null;

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        LOG.debug("Ignoring setConf call.");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        if (null == util) {
            util = new IntegrationTestingUtility();
        }
        util.initializeCluster(1);
        if (!util.isDistributedCluster()) {
            util.startMiniMapReduceCluster();
        }
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.restoreCluster();
        if (!util.isDistributedCluster()) {
            util.shutdownMiniMapReduceCluster();
        }
        util = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadIncrementalHFiles(Path hfiles, TableName tableName) throws Exception {
        String[] args = new String[]{hfiles.toString(), tableName.getNameAsString()};
        LOG.info(String.format("Running LoadIncrememntalHFiles with args: %s", Arrays.asList(args)));
        Assert.assertEquals((String)"Loading HFiles failed.", (long)0L, (long)ToolRunner.run((Tool)new LoadIncrementalHFiles(new Configuration(this.getConf())), (String[])args));
        Table table = null;
        Scan scan = new Scan(){
            {
                this.setCacheBlocks(false);
                this.setCaching(1000);
            }
        };
        try {
            table = util.getConnection().getTable(tableName);
            Iterator resultsIt = table.getScanner(scan).iterator();
            Iterator<KeyValue> expectedIt = simple_expected.iterator();
            while (resultsIt.hasNext() && expectedIt.hasNext()) {
                Result r = (Result)resultsIt.next();
                for (Cell actual : r.rawCells()) {
                    Assert.assertTrue((String)"Ran out of expected values prematurely!", (boolean)expectedIt.hasNext());
                    KeyValue expected = expectedIt.next();
                    Assert.assertEquals((String)"Scan produced surprising result", (long)0L, (long)CellComparator.getInstance().compare((Cell)expected, actual));
                }
            }
            Assert.assertFalse((String)"Did not consume all expected values.", (boolean)expectedIt.hasNext());
            Assert.assertFalse((String)"Did not consume all scan results.", (boolean)resultsIt.hasNext());
        }
        finally {
            if (null != table) {
                table.close();
            }
        }
    }

    protected static void validateDeletedPartitionsFile(Configuration conf) throws IOException {
        if (!conf.getBoolean("hbase.test.cluster.distributed", false)) {
            return;
        }
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path partitionsFile = new Path(TotalOrderPartitioner.getPartitionFile((Configuration)conf));
        Assert.assertFalse((String)"Failed to clean up partitions file.", (boolean)fs.exists(partitionsFile));
    }

    @Test
    public void testGenerateAndLoad() throws Exception {
        this.generateAndLoad(TableName.valueOf((String)this.name.getMethodName()));
    }

    void generateAndLoad(TableName table) throws Exception {
        LOG.info("Running test testGenerateAndLoad.");
        String cf = "d";
        Path hfiles = this.initGeneratedHFilePath(table);
        LOG.info("The folder where the HFiles will be generated: {}", (Object)hfiles.toString());
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("importtsv.bulk.output", hfiles.toString());
        args.put("importtsv.columns", String.format("HBASE_ROW_KEY,HBASE_TS_KEY,%s:c1,%s:c2", cf, cf));
        args.put(TestImportTsv.DELETE_AFTER_LOAD_CONF, "false");
        util.createTable(table, new String[]{cf});
        Tool t = TestImportTsv.doMROnTableTest((HBaseTestingUtility)util, (TableName)table, (String)cf, (String)simple_tsv, args);
        this.doLoadIncrementalHFiles(hfiles, table);
        IntegrationTestImportTsv.validateDeletedPartitionsFile(t.getConf());
        util.deleteTable(table);
        util.cleanupDataTestDirOnTestFS(table.getNameAsString());
        LOG.info("testGenerateAndLoad completed successfully.");
    }

    public int run(String[] args) throws Exception {
        if (args.length != 0) {
            System.err.println(String.format("%s [genericOptions]", NAME));
            System.err.println("  Runs ImportTsv integration tests against a distributed cluster.");
            System.err.println();
            System.err.println("  Use '-DIntegrationTestImportTsv.generatedHFileFolder=<path>' to define a");
            System.err.println("  base folder for the generated HFiles. If HDFS Transparent Encryption");
            System.err.println("  is configured, then make sure to set this parameter to a folder in");
            System.err.println("  the same encryption zone in HDFS as the HBase root directory,");
            System.err.println("  otherwise the bulkload will fail.");
            System.err.println();
            ToolRunner.printGenericCommandUsage((PrintStream)System.err);
            return 1;
        }
        IntegrationTestImportTsv.provisionCluster();
        TableName tableName = TableName.valueOf((String)"IntegrationTestImportTsv");
        if (util.getAdmin().tableExists(tableName)) {
            util.deleteTable(tableName);
        }
        this.generateAndLoad(tableName);
        IntegrationTestImportTsv.releaseCluster();
        return 0;
    }

    private Path initGeneratedHFilePath(TableName table) throws IOException {
        String folderParam = this.getConf().getTrimmed(GENERATED_HFILE_FOLDER_PARAM_KEY);
        if (folderParam == null || folderParam.isEmpty()) {
            return new Path(util.getDataTestDirOnTestFS(table.getNameAsString()), "hfiles");
        }
        Path hfiles = new Path(folderParam, UUID.randomUUID().toString());
        FileSystem fs = util.getTestFileSystem();
        String shouldPreserve = System.getProperty("hbase.testing.preserve.testdir", "false");
        if (!Boolean.parseBoolean(shouldPreserve)) {
            if (fs.getUri().getScheme().equals(FileSystem.getLocal((Configuration)this.getConf()).getUri().getScheme())) {
                File localFoler = new File(hfiles.toString());
                localFoler.deleteOnExit();
            } else {
                fs.deleteOnExit(hfiles);
            }
        }
        return hfiles;
    }

    public static void main(String[] args) throws Exception {
        Configuration conf = HBaseConfiguration.create();
        IntegrationTestingUtility.setUseDistributedCluster(conf);
        util = new IntegrationTestingUtility(conf);
        int status = ToolRunner.run((Configuration)conf, (Tool)new IntegrationTestImportTsv(), (String[])args);
        System.exit(status);
    }
}

