/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.chaos.actions;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.chaos.actions.Action;
import org.apache.hadoop.hbase.chaos.actions.ChangeSplitPolicyAction;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;

@Category(value={MediumTests.class})
public class TestChangeSplitPolicyAction {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestChangeSplitPolicyAction.class);
    private static final IntegrationTestingUtility TEST_UTIL = new IntegrationTestingUtility();
    private final TableName tableName = TableName.valueOf((String)"ChangeSplitPolicyAction");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(2);
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setUp() throws Exception {
        Admin admin = TEST_UTIL.getAdmin();
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)this.tableName);
        admin.createTable(builder.setColumnFamily(ColumnFamilyDescriptorBuilder.of((String)"fam")).build());
    }

    @Test
    public void testChangeSplitPolicyAction() throws Exception {
        Action.ActionContext ctx = (Action.ActionContext)Mockito.mock(Action.ActionContext.class);
        Mockito.when((Object)((Object)ctx.getHBaseIntegrationTestingUtility())).thenReturn((Object)TEST_UTIL);
        Mockito.when((Object)ctx.getHBaseCluster()).thenReturn((Object)TEST_UTIL.getHBaseCluster());
        ChangeSplitPolicyAction action = new ChangeSplitPolicyAction(this.tableName);
        action.init(ctx);
        action.perform();
    }
}

