/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClientSideRegionScanner;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.ProtocolStringList;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MapReduceProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotHelper;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.io.Writable;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TableSnapshotInputFormatImpl {
    public static final Log LOG = LogFactory.getLog(TableSnapshotInputFormatImpl.class);
    private static final String SNAPSHOT_NAME_KEY = "hbase.TableSnapshotInputFormat.snapshot.name";
    protected static final String RESTORE_DIR_KEY = "hbase.TableSnapshotInputFormat.restore.dir";
    private static final String LOCALITY_CUTOFF_MULTIPLIER = "hbase.tablesnapshotinputformat.locality.cutoff.multiplier";
    private static final float DEFAULT_LOCALITY_CUTOFF_MULTIPLIER = 0.8f;

    public static List<InputSplit> getSplits(Configuration conf) throws IOException {
        String snapshotName = TableSnapshotInputFormatImpl.getSnapshotName(conf);
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        SnapshotManifest manifest = TableSnapshotInputFormatImpl.getSnapshotManifest(conf, snapshotName, rootDir, fs);
        List<HRegionInfo> regionInfos = TableSnapshotInputFormatImpl.getRegionInfosFromManifest(manifest);
        Scan scan = TableSnapshotInputFormatImpl.extractScanFromConf(conf);
        Path restoreDir = new Path(conf.get(RESTORE_DIR_KEY));
        return TableSnapshotInputFormatImpl.getSplits(scan, manifest, regionInfos, restoreDir, conf);
    }

    public static List<HRegionInfo> getRegionInfosFromManifest(SnapshotManifest manifest) {
        List regionManifests = manifest.getRegionManifests();
        if (regionManifests == null) {
            throw new IllegalArgumentException("Snapshot seems empty");
        }
        ArrayList regionInfos = Lists.newArrayListWithCapacity((int)regionManifests.size());
        for (SnapshotProtos.SnapshotRegionManifest regionManifest : regionManifests) {
            HRegionInfo hri = HRegionInfo.convert((HBaseProtos.RegionInfo)regionManifest.getRegionInfo());
            if (hri.isOffline() && (hri.isSplit() || hri.isSplitParent())) continue;
            regionInfos.add(hri);
        }
        return regionInfos;
    }

    public static SnapshotManifest getSnapshotManifest(Configuration conf, String snapshotName, Path rootDir, FileSystem fs) throws IOException {
        Path snapshotDir = SnapshotDescriptionUtils.getCompletedSnapshotDir((String)snapshotName, (Path)rootDir);
        SnapshotProtos.SnapshotDescription snapshotDesc = SnapshotDescriptionUtils.readSnapshotInfo((FileSystem)fs, (Path)snapshotDir);
        return SnapshotManifest.open((Configuration)conf, (FileSystem)fs, (Path)snapshotDir, (SnapshotProtos.SnapshotDescription)snapshotDesc);
    }

    public static Scan extractScanFromConf(Configuration conf) throws IOException {
        Scan scan = null;
        if (conf.get("hbase.mapreduce.scan") != null) {
            scan = TableMapReduceUtil.convertStringToScan(conf.get("hbase.mapreduce.scan"));
        } else if (conf.get("hbase.mapred.tablecolumns") != null) {
            String[] columns = conf.get("hbase.mapred.tablecolumns").split(" ");
            scan = new Scan();
            for (String col : columns) {
                scan.addFamily(Bytes.toBytes((String)col));
            }
        } else {
            throw new IllegalArgumentException("Unable to create scan");
        }
        return scan;
    }

    public static List<InputSplit> getSplits(Scan scan, SnapshotManifest manifest, List<HRegionInfo> regionManifests, Path restoreDir, Configuration conf) throws IOException {
        TableDescriptor htd = manifest.getTableDescriptor();
        Path tableDir = FSUtils.getTableDir((Path)restoreDir, (TableName)htd.getTableName());
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (HRegionInfo hri : regionManifests) {
            if (!CellUtil.overlappingKeys((byte[])scan.getStartRow(), (byte[])scan.getStopRow(), (byte[])hri.getStartKey(), (byte[])hri.getEndKey())) continue;
            List<String> hosts = TableSnapshotInputFormatImpl.getBestLocations(conf, HRegion.computeHDFSBlocksDistribution((Configuration)conf, (TableDescriptor)htd, (HRegionInfo)hri, (Path)tableDir));
            int len = Math.min(3, hosts.size());
            hosts = hosts.subList(0, len);
            splits.add(new InputSplit(htd, hri, hosts, scan, restoreDir));
        }
        return splits;
    }

    public static List<String> getBestLocations(Configuration conf, HDFSBlocksDistribution blockDistribution) {
        ArrayList<String> locations = new ArrayList<String>(3);
        HDFSBlocksDistribution.HostAndWeight[] hostAndWeights = blockDistribution.getTopHostsWithWeights();
        if (hostAndWeights.length == 0) {
            return locations;
        }
        HDFSBlocksDistribution.HostAndWeight topHost = hostAndWeights[0];
        locations.add(topHost.getHost());
        double cutoffMultiplier = conf.getFloat(LOCALITY_CUTOFF_MULTIPLIER, 0.8f);
        double filterWeight = (double)topHost.getWeight() * cutoffMultiplier;
        for (int i = 1; i < hostAndWeights.length && (double)hostAndWeights[i].getWeight() >= filterWeight; ++i) {
            locations.add(hostAndWeights[i].getHost());
        }
        return locations;
    }

    private static String getSnapshotName(Configuration conf) {
        String snapshotName = conf.get(SNAPSHOT_NAME_KEY);
        if (snapshotName == null) {
            throw new IllegalArgumentException("Snapshot name must be provided");
        }
        return snapshotName;
    }

    public static void setInput(Configuration conf, String snapshotName, Path restoreDir) throws IOException {
        conf.set(SNAPSHOT_NAME_KEY, snapshotName);
        Path rootDir = FSUtils.getRootDir((Configuration)conf);
        FileSystem fs = rootDir.getFileSystem(conf);
        restoreDir = new Path(restoreDir, UUID.randomUUID().toString());
        RestoreSnapshotHelper.copySnapshotForScanner((Configuration)conf, (FileSystem)fs, (Path)rootDir, (Path)restoreDir, (String)snapshotName);
        conf.set(RESTORE_DIR_KEY, restoreDir.toString());
    }

    public static class RecordReader {
        private InputSplit split;
        private Scan scan;
        private Result result = null;
        private ImmutableBytesWritable row = null;
        private ClientSideRegionScanner scanner;

        public ClientSideRegionScanner getScanner() {
            return this.scanner;
        }

        public void initialize(InputSplit split, Configuration conf) throws IOException {
            this.scan = TableMapReduceUtil.convertStringToScan(split.getScan());
            this.split = split;
            TableDescriptor htd = split.htd;
            HRegionInfo hri = this.split.getRegionInfo();
            FileSystem fs = FSUtils.getCurrentFileSystem((Configuration)conf);
            this.scan.setIsolationLevel(IsolationLevel.READ_UNCOMMITTED);
            this.scan.setCacheBlocks(false);
            this.scanner = new ClientSideRegionScanner(conf, fs, new Path(split.restoreDir), htd, hri, this.scan, null);
        }

        public boolean nextKeyValue() throws IOException {
            this.result = this.scanner.next();
            if (this.result == null) {
                return false;
            }
            if (this.row == null) {
                this.row = new ImmutableBytesWritable();
            }
            this.row.set(this.result.getRow());
            return true;
        }

        public ImmutableBytesWritable getCurrentKey() {
            return this.row;
        }

        public Result getCurrentValue() {
            return this.result;
        }

        public long getPos() {
            return 0L;
        }

        public float getProgress() {
            return 0.0f;
        }

        public void close() {
            if (this.scanner != null) {
                this.scanner.close();
            }
        }
    }

    public static class InputSplit
    implements Writable {
        private TableDescriptor htd;
        private HRegionInfo regionInfo;
        private String[] locations;
        private String scan;
        private String restoreDir;

        public InputSplit() {
        }

        public InputSplit(TableDescriptor htd, HRegionInfo regionInfo, List<String> locations, Scan scan, Path restoreDir) {
            this.htd = htd;
            this.regionInfo = regionInfo;
            this.locations = locations == null || locations.isEmpty() ? new String[0] : locations.toArray(new String[locations.size()]);
            try {
                this.scan = scan != null ? TableMapReduceUtil.convertScanToString(scan) : "";
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to convert Scan to String", (Throwable)e);
            }
            this.restoreDir = restoreDir.toString();
        }

        public TableDescriptor getHtd() {
            return this.htd;
        }

        public String getScan() {
            return this.scan;
        }

        public String getRestoreDir() {
            return this.restoreDir;
        }

        public long getLength() {
            return 0L;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public TableDescriptor getTableDescriptor() {
            return this.htd;
        }

        public HRegionInfo getRegionInfo() {
            return this.regionInfo;
        }

        public void write(DataOutput out) throws IOException {
            MapReduceProtos.TableSnapshotRegionSplit.Builder builder = MapReduceProtos.TableSnapshotRegionSplit.newBuilder().setTable(ProtobufUtil.toTableSchema((TableDescriptor)this.htd)).setRegion(HRegionInfo.convert((HRegionInfo)this.regionInfo));
            for (String location : this.locations) {
                builder.addLocations(location);
            }
            MapReduceProtos.TableSnapshotRegionSplit split = builder.build();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            split.writeTo((OutputStream)baos);
            baos.close();
            byte[] buf = baos.toByteArray();
            out.writeInt(buf.length);
            out.write(buf);
            Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.scan));
            Bytes.writeByteArray((DataOutput)out, (byte[])Bytes.toBytes((String)this.restoreDir));
        }

        public void readFields(DataInput in) throws IOException {
            int len = in.readInt();
            byte[] buf = new byte[len];
            in.readFully(buf);
            MapReduceProtos.TableSnapshotRegionSplit split = (MapReduceProtos.TableSnapshotRegionSplit)MapReduceProtos.TableSnapshotRegionSplit.PARSER.parseFrom(buf);
            this.htd = ProtobufUtil.toTableDescriptor((HBaseProtos.TableSchema)split.getTable());
            this.regionInfo = HRegionInfo.convert((HBaseProtos.RegionInfo)split.getRegion());
            ProtocolStringList locationsList = split.getLocationsList();
            this.locations = locationsList.toArray(new String[locationsList.size()]);
            this.scan = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
            this.restoreDir = Bytes.toString((byte[])Bytes.readByteArray((DataInput)in));
        }
    }
}

