/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.hbase.util.MapReduceCell;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCellBasedWALPlayer2 {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static MiniHBaseCluster cluster;
    private static Path rootDir;
    private static Path walRootDir;
    private static FileSystem fs;
    private static FileSystem logFs;
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        rootDir = TEST_UTIL.createRootDir();
        walRootDir = TEST_UTIL.createWALRootDir();
        fs = FSUtils.getRootDirFileSystem((Configuration)conf);
        logFs = FSUtils.getWALFileSystem((Configuration)conf);
        cluster = TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
        fs.delete(rootDir, true);
        logFs.delete(walRootDir, true);
    }

    @Test
    public void testWALPlayer() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] COLUMN2 = Bytes.toBytes((String)"c2");
        byte[] ROW = Bytes.toBytes((String)"row");
        Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
        Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);
        Put p = new Put(ROW);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        p.addColumn(FAMILY, COLUMN2, COLUMN2);
        t1.put(p);
        Delete d = new Delete(ROW);
        d.addColumns(FAMILY, COLUMN1);
        t1.delete(d);
        WAL log = cluster.getRegionServer(0).getWAL(null);
        log.rollWriter();
        String walInputDir = new Path(cluster.getMaster().getMasterFileSystem().getWALRootDir(), "WALs").toString();
        Configuration configuration = TEST_UTIL.getConfiguration();
        WALPlayer player = new WALPlayer(configuration);
        String optionName = "_test_.name";
        configuration.set(optionName, "1000");
        player.setupTime(configuration, optionName);
        Assert.assertEquals((long)1000L, (long)configuration.getLong(optionName, 0L));
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)configuration, (Tool)player, (String[])new String[]{walInputDir, tableName1.getNameAsString(), tableName2.getNameAsString()}));
        Get g = new Get(ROW);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN2));
    }

    @Test
    public void testWALKeyValueMapper() throws Exception {
        this.testWALKeyValueMapper("wal.input.tables");
    }

    @Test
    public void testWALKeyValueMapperWithDeprecatedConfig() throws Exception {
        this.testWALKeyValueMapper("hlog.input.tables");
    }

    private void testWALKeyValueMapper(String tableConfigKey) throws Exception {
        Configuration configuration = new Configuration();
        configuration.set(tableConfigKey, "table");
        WALPlayer.WALCellMapper mapper = new WALPlayer.WALCellMapper();
        WALKey key = (WALKey)Mockito.mock(WALKey.class);
        Mockito.when((Object)key.getTablename()).thenReturn((Object)TableName.valueOf((String)"table"));
        Mapper.Context context = (Mapper.Context)Mockito.mock(Mapper.Context.class);
        Mockito.when((Object)context.getConfiguration()).thenReturn((Object)configuration);
        WALEdit value = (WALEdit)Mockito.mock(WALEdit.class);
        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
        KeyValue kv1 = new KeyValue(Bytes.toBytes((String)"row"), Bytes.toBytes((String)"family"), null);
        values.add(kv1);
        Mockito.when((Object)value.getCells()).thenReturn(values);
        mapper.setup(context);
        ((Mapper.Context)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ImmutableBytesWritable writer = (ImmutableBytesWritable)invocation.getArguments()[0];
                MapReduceCell key = (MapReduceCell)invocation.getArguments()[1];
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])writer.get()));
                Assert.assertEquals((Object)"row", (Object)Bytes.toString((byte[])CellUtil.cloneRow((Cell)key)));
                return null;
            }
        }).when((Object)context)).write(Matchers.any(ImmutableBytesWritable.class), Matchers.any(MapReduceCell.class));
        mapper.map(key, value, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        PrintStream oldPrintStream = System.err;
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        String[] args = new String[]{};
        System.setErr(new PrintStream(data));
        try {
            System.setErr(new PrintStream(data));
            try {
                WALPlayer.main((String[])args);
                Assert.fail((String)"should be SecurityException");
            }
            catch (SecurityException e) {
                Assert.assertEquals((long)-1L, (long)newSecurityManager.getExitCode());
                Assert.assertTrue((boolean)data.toString().contains("ERROR: Wrong number of arguments:"));
                Assert.assertTrue((boolean)data.toString().contains("Usage: WALPlayer [options] <wal inputdir> <tables> [<tableMappings>]"));
                Assert.assertTrue((boolean)data.toString().contains("-Dwal.bulk.output=/path/for/output"));
            }
        }
        finally {
            System.setErr(oldPrintStream);
            System.setSecurityManager(SECURITY_MANAGER);
        }
    }
}

