/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCopyTable {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyTableTest(boolean bulkload) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        try (Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
             Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);){
            for (int i = 0; i < 10; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(FAMILY, COLUMN1, COLUMN1);
                t1.put(p);
            }
            CopyTable copy = new CopyTable();
            int code = bulkload ? ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", tableName1.getNameAsString()}) : ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), tableName1.getNameAsString()});
            Assert.assertEquals((String)"copy job failed", (long)0L, (long)code);
            for (int i = 0; i < 10; ++i) {
                Get g = new Get(Bytes.toBytes((String)("row" + i)));
                Result r = t2.get(g);
                Assert.assertEquals((long)1L, (long)r.size());
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
            }
        }
        finally {
            TEST_UTIL.deleteTable(tableName1);
            TEST_UTIL.deleteTable(tableName2);
        }
    }

    @Test
    public void testCopyTable() throws Exception {
        this.doCopyTableTest(false);
    }

    @Test
    public void testCopyTableWithBulkload() throws Exception {
        this.doCopyTableTest(true);
    }

    @Test
    public void testStartStopRow() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] ROW0 = Bytes.toBytesBinary((String)"\\x01row0");
        byte[] ROW1 = Bytes.toBytesBinary((String)"\\x01row1");
        byte[] ROW2 = Bytes.toBytesBinary((String)"\\x01row2");
        Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
        Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);
        Put p = new Put(ROW0);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW1);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW2);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        CopyTable copy = new CopyTable();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2, "--startrow=\\x01row1", "--stoprow=\\x01row2", tableName1.getNameAsString()}));
        Get g = new Get(ROW1);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
        g = new Get(ROW0);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        g = new Get(ROW2);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t1.close();
        t2.close();
        TEST_UTIL.deleteTable(tableName1);
        TEST_UTIL.deleteTable(tableName2);
    }

    @Test
    public void testRenameFamily() throws Exception {
        TableName sourceTable = TableName.valueOf((String)(this.name.getMethodName() + "source"));
        TableName targetTable = TableName.valueOf((String)(this.name.getMethodName() + "-target"));
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        Table t = TEST_UTIL.createTable(sourceTable, (byte[][])families);
        Table t2 = TEST_UTIL.createTable(targetTable, (byte[][])families);
        Put p = new Put(ROW1);
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data11"));
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data12"));
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data13"));
        t.put(p);
        p = new Put(ROW2);
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Dat21"));
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data22"));
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data23"));
        t.put(p);
        long currentTime = System.currentTimeMillis();
        String[] args = new String[]{"--new.name=" + targetTable, "--families=a:b", "--all.cells", "--starttime=" + (currentTime - 100000L), "--endtime=" + (currentTime + 100000L), "--versions=1", sourceTable.getNameAsString()};
        Assert.assertNull((Object)t2.get(new Get(ROW1)).getRow());
        Assert.assertTrue((boolean)this.runCopy(args));
        Assert.assertNotNull((Object)t2.get(new Get(ROW1)).getRow());
        Result res = t2.get(new Get(ROW1));
        byte[] b1 = res.getValue(FAMILY_B, QUALIFIER);
        Assert.assertEquals((Object)"Data13", (Object)new String(b1));
        Assert.assertNotNull((Object)t2.get(new Get(ROW2)).getRow());
        res = t2.get(new Get(ROW2));
        b1 = res.getValue(FAMILY_A, QUALIFIER);
        Assert.assertNull((Object)b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        String[] emptyArgs = new String[]{"-h"};
        PrintStream oldWriter = System.err;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(data);
        System.setErr(writer);
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        try {
            CopyTable.main((String[])emptyArgs);
            Assert.fail((String)"should be exit");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
        }
        finally {
            System.setErr(oldWriter);
            System.setSecurityManager(SECURITY_MANAGER);
        }
        Assert.assertTrue((boolean)data.toString().contains("rs.class"));
        Assert.assertTrue((boolean)data.toString().contains("Usage:"));
    }

    private boolean runCopy(String[] args) throws Exception {
        int status = ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)new CopyTable(), (String[])args);
        return status == 0;
    }
}

