/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FirstKeyOnlyFilter;
import org.apache.hadoop.hbase.filter.MultiRowRangeFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class RowCounter
extends Configured
implements Tool {
    private static final Logger LOG = LoggerFactory.getLogger(RowCounter.class);
    static final String NAME = "rowcounter";
    private static final String JOB_NAME_CONF_KEY = "mapreduce.job.name";
    private static final String EXPECTED_COUNT_KEY = RowCounter.class.getName() + ".expected_count";

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        String tableName = args[0];
        List<MultiRowRangeFilter.RowRange> rowRangeList = null;
        long startTime = 0L;
        long endTime = 0L;
        StringBuilder sb = new StringBuilder();
        String rangeSwitch = "--range=";
        String startTimeArgKey = "--starttime=";
        String endTimeArgKey = "--endtime=";
        String expectedCountArg = "--expected-count=";
        for (int i = 1; i < args.length; ++i) {
            if (args[i].startsWith("--range=")) {
                try {
                    rowRangeList = RowCounter.parseRowRangeParameter(args[i], "--range=");
                    continue;
                }
                catch (IllegalArgumentException e) {
                    return null;
                }
            }
            if (args[i].startsWith("--starttime=")) {
                startTime = Long.parseLong(args[i].substring("--starttime=".length()));
                continue;
            }
            if (args[i].startsWith("--endtime=")) {
                endTime = Long.parseLong(args[i].substring("--endtime=".length()));
                continue;
            }
            if (args[i].startsWith("--expected-count=")) {
                conf.setLong(EXPECTED_COUNT_KEY, Long.parseLong(args[i].substring("--expected-count=".length())));
                continue;
            }
            sb.append(args[i]);
            sb.append(" ");
        }
        if (endTime < startTime) {
            RowCounter.printUsage("--endtime=" + endTime + " needs to be greater than --starttime=" + startTime);
            return null;
        }
        Job job = Job.getInstance((Configuration)conf, (String)conf.get(JOB_NAME_CONF_KEY, "rowcounter_" + tableName));
        job.setJarByClass(RowCounter.class);
        Scan scan = new Scan();
        scan.setCacheBlocks(false);
        RowCounter.setScanFilter(scan, rowRangeList);
        if (sb.length() > 0) {
            for (String columnName : sb.toString().trim().split(" ")) {
                String family = StringUtils.substringBefore((String)columnName, (String)":");
                String qualifier = StringUtils.substringAfter((String)columnName, (String)":");
                if (StringUtils.isBlank((CharSequence)qualifier)) {
                    scan.addFamily(Bytes.toBytes((String)family));
                    continue;
                }
                scan.addColumn(Bytes.toBytes((String)family), Bytes.toBytes((String)qualifier));
            }
        }
        scan.setTimeRange(startTime, endTime == 0L ? Long.MAX_VALUE : endTime);
        job.setOutputFormatClass(NullOutputFormat.class);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, RowCounterMapper.class, ImmutableBytesWritable.class, Result.class, job);
        job.setNumReduceTasks(0);
        return job;
    }

    private static List<MultiRowRangeFilter.RowRange> parseRowRangeParameter(String arg, String rangeSwitch) {
        String[] ranges = arg.substring(rangeSwitch.length()).split(";");
        ArrayList<MultiRowRangeFilter.RowRange> rangeList = new ArrayList<MultiRowRangeFilter.RowRange>();
        for (String range : ranges) {
            String[] startEnd = range.split(",", 2);
            if (startEnd.length != 2 || startEnd[1].contains(",")) {
                RowCounter.printUsage("Please specify range in such format as \"--range=a,b\" or, with only one boundary, \"--range=,b\" or \"--range=a,\"");
                throw new IllegalArgumentException("Wrong range specification: " + range);
            }
            String startKey = startEnd[0];
            String endKey = startEnd[1];
            rangeList.add(new MultiRowRangeFilter.RowRange(Bytes.toBytesBinary((String)startKey), true, Bytes.toBytesBinary((String)endKey), false));
        }
        return rangeList;
    }

    private static void setScanFilter(Scan scan, List<MultiRowRangeFilter.RowRange> rowRangeList) {
        int size;
        int n = size = rowRangeList == null ? 0 : rowRangeList.size();
        if (size <= 1) {
            scan.setFilter((Filter)new FirstKeyOnlyFilter());
        }
        if (size == 1) {
            MultiRowRangeFilter.RowRange range = rowRangeList.get(0);
            scan.setStartRow(range.getStartRow());
            scan.setStopRow(range.getStopRow());
        } else if (size > 1) {
            scan.setFilter((Filter)new MultiRowRangeFilter(rowRangeList));
        }
    }

    private static void printUsage(String errorMessage) {
        System.err.println("ERROR: " + errorMessage);
        RowCounter.printUsage();
    }

    private static void printUsage() {
        System.err.println("Usage: RowCounter [options] <tablename> [--starttime=[start] --endtime=[end] [--range=[startKey],[endKey][;[startKey],[endKey]...]] [<column1> <column2>...]");
        System.err.println("For performance consider the following options:\n-Dhbase.client.scanner.caching=100\n-Dmapreduce.map.speculative=false");
    }

    public int run(String[] args) throws Exception {
        if (args.length < 1) {
            RowCounter.printUsage("Wrong number of parameters: " + args.length);
            return -1;
        }
        Job job = RowCounter.createSubmittableJob(this.getConf(), args);
        if (job == null) {
            return -1;
        }
        boolean success = job.waitForCompletion(true);
        long expectedCount = this.getConf().getLong(EXPECTED_COUNT_KEY, -1L);
        if (success && expectedCount != -1L) {
            Counter counter = job.getCounters().findCounter((Enum)RowCounterMapper.Counters.ROWS);
            boolean bl = success = expectedCount == counter.getValue();
            if (!success) {
                LOG.error("Failing job because count of '" + counter.getValue() + "' does not match expected count of '" + expectedCount + "'");
            }
        }
        return success ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int errCode = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new RowCounter(), (String[])args);
        System.exit(errCode);
    }

    static class RowCounterMapper
    extends TableMapper<ImmutableBytesWritable, Result> {
        RowCounterMapper() {
        }

        public void map(ImmutableBytesWritable row, Result values, Mapper.Context context) throws IOException {
            context.getCounter((Enum)Counters.ROWS).increment(1L);
        }

        public static enum Counters {
            ROWS;

        }
    }
}

