/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableInputFormat
extends TableInputFormatBase
implements Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(TableInputFormat.class);
    public static final String INPUT_TABLE = "hbase.mapreduce.inputtable";
    private static final String SPLIT_TABLE = "hbase.mapreduce.splittable";
    public static final String SCAN = "hbase.mapreduce.scan";
    public static final String SCAN_ROW_START = "hbase.mapreduce.scan.row.start";
    public static final String SCAN_ROW_STOP = "hbase.mapreduce.scan.row.stop";
    public static final String SCAN_COLUMN_FAMILY = "hbase.mapreduce.scan.column.family";
    public static final String SCAN_COLUMNS = "hbase.mapreduce.scan.columns";
    public static final String SCAN_TIMESTAMP = "hbase.mapreduce.scan.timestamp";
    public static final String SCAN_TIMERANGE_START = "hbase.mapreduce.scan.timerange.start";
    public static final String SCAN_TIMERANGE_END = "hbase.mapreduce.scan.timerange.end";
    public static final String SCAN_MAXVERSIONS = "hbase.mapreduce.scan.maxversions";
    public static final String SCAN_CACHEBLOCKS = "hbase.mapreduce.scan.cacheblocks";
    public static final String SCAN_CACHEDROWS = "hbase.mapreduce.scan.cachedrows";
    public static final String SCAN_BATCHSIZE = "hbase.mapreduce.scan.batchsize";
    public static final String SHUFFLE_MAPS = "hbase.mapreduce.inputtable.shufflemaps";
    private Configuration conf = null;

    public Configuration getConf() {
        return this.conf;
    }

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Intentional")
    public void setConf(Configuration configuration) {
        this.conf = configuration;
        Scan scan = null;
        if (this.conf.get(SCAN) != null) {
            try {
                scan = TableMapReduceUtil.convertStringToScan(this.conf.get(SCAN));
            }
            catch (IOException e) {
                LOG.error("An error occurred.", (Throwable)e);
            }
        } else {
            try {
                scan = TableInputFormat.createScanFromConfiguration(this.conf);
            }
            catch (Exception e) {
                LOG.error(StringUtils.stringifyException((Throwable)e));
            }
        }
        this.setScan(scan);
    }

    public static Scan createScanFromConfiguration(Configuration conf) throws IOException {
        Scan scan = new Scan();
        if (conf.get(SCAN_ROW_START) != null) {
            scan.setStartRow(Bytes.toBytesBinary((String)conf.get(SCAN_ROW_START)));
        }
        if (conf.get(SCAN_ROW_STOP) != null) {
            scan.setStopRow(Bytes.toBytesBinary((String)conf.get(SCAN_ROW_STOP)));
        }
        if (conf.get(SCAN_COLUMNS) != null) {
            TableInputFormat.addColumns(scan, conf.get(SCAN_COLUMNS));
        }
        for (String columnFamily : conf.getTrimmedStrings(SCAN_COLUMN_FAMILY)) {
            scan.addFamily(Bytes.toBytes((String)columnFamily));
        }
        if (conf.get(SCAN_TIMESTAMP) != null) {
            scan.setTimeStamp(Long.parseLong(conf.get(SCAN_TIMESTAMP)));
        }
        if (conf.get(SCAN_TIMERANGE_START) != null && conf.get(SCAN_TIMERANGE_END) != null) {
            scan.setTimeRange(Long.parseLong(conf.get(SCAN_TIMERANGE_START)), Long.parseLong(conf.get(SCAN_TIMERANGE_END)));
        }
        if (conf.get(SCAN_MAXVERSIONS) != null) {
            scan.setMaxVersions(Integer.parseInt(conf.get(SCAN_MAXVERSIONS)));
        }
        if (conf.get(SCAN_CACHEDROWS) != null) {
            scan.setCaching(Integer.parseInt(conf.get(SCAN_CACHEDROWS)));
        }
        if (conf.get(SCAN_BATCHSIZE) != null) {
            scan.setBatch(Integer.parseInt(conf.get(SCAN_BATCHSIZE)));
        }
        scan.setCacheBlocks(conf.getBoolean(SCAN_CACHEBLOCKS, false));
        return scan;
    }

    @Override
    protected void initialize(JobContext context) throws IOException {
        TableName tableName = TableName.valueOf((String)this.conf.get(INPUT_TABLE));
        try {
            this.initializeTable(ConnectionFactory.createConnection((Configuration)new Configuration(this.conf)), tableName);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
        }
    }

    private static void addColumn(Scan scan, byte[] familyAndQualifier) {
        byte[][] fq = CellUtil.parseColumn((byte[])familyAndQualifier);
        if (fq.length == 1) {
            scan.addFamily(fq[0]);
        } else if (fq.length == 2) {
            scan.addColumn(fq[0], fq[1]);
        } else {
            throw new IllegalArgumentException("Invalid familyAndQualifier provided.");
        }
    }

    public static void addColumns(Scan scan, byte[][] columns) {
        for (byte[] column : columns) {
            TableInputFormat.addColumn(scan, column);
        }
    }

    @Override
    public List<InputSplit> getSplits(JobContext context) throws IOException {
        List<InputSplit> splits = super.getSplits(context);
        if (this.conf.get(SHUFFLE_MAPS) != null && "true".equals(this.conf.get(SHUFFLE_MAPS).toLowerCase(Locale.ROOT))) {
            Collections.shuffle(splits);
        }
        return splits;
    }

    private static void addColumns(Scan scan, String columns) {
        String[] cols;
        for (String col : cols = columns.split(" ")) {
            TableInputFormat.addColumn(scan, Bytes.toBytes((String)col));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void configureSplitTable(Job job, TableName tableName) {
        job.getConfiguration().set(SPLIT_TABLE, tableName.getNameAsString());
    }
}

