/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hadoop.hbase.mapreduce.TestImportTsv;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestImportTSVWithTTLs
implements Configurable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestImportTSVWithTTLs.class);
    protected static final Logger LOG = LoggerFactory.getLogger(TestImportTSVWithTTLs.class);
    protected static final String NAME = TestImportTsv.class.getSimpleName();
    protected static HBaseTestingUtility util = new HBaseTestingUtility();
    protected static final String DELETE_AFTER_LOAD_CONF = NAME + ".deleteAfterLoad";
    protected static final String FORCE_COMBINER_CONF = NAME + ".forceCombiner";
    private final String FAMILY = "FAM";
    private static Configuration conf;
    @Rule
    public TestName name = new TestName();

    public Configuration getConf() {
        return util.getConfiguration();
    }

    public void setConf(Configuration conf) {
        throw new IllegalArgumentException("setConf not supported");
    }

    @BeforeClass
    public static void provisionCluster() throws Exception {
        conf = util.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.region.classes", TTLCheckingObserver.class.getName());
        util.startMiniCluster();
    }

    @AfterClass
    public static void releaseCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    @Test
    public void testMROnTable() throws Exception {
        TableName tableName = TableName.valueOf((String)(this.name.getMethodName() + UUID.randomUUID()));
        String[] args = new String[]{"-Dimporttsv.mapper.class=org.apache.hadoop.hbase.mapreduce.TsvImporterMapper", "-Dimporttsv.columns=HBASE_ROW_KEY,FAM:A,FAM:B,HBASE_CELL_TTL", "-Dimporttsv.separator=\u001b", tableName.getNameAsString()};
        String data = "KEY\u001bVALUE1\u001bVALUE2\u001b1000000\n";
        util.createTable(tableName, "FAM");
        TestImportTSVWithTTLs.doMROnTableTest(util, "FAM", data, args, 1);
        util.deleteTable(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Tool doMROnTableTest(HBaseTestingUtility util, String family, String data, String[] args, int valueMultiplier) throws Exception {
        TableName table = TableName.valueOf((String)args[args.length - 1]);
        Configuration conf = new Configuration(util.getConfiguration());
        FileSystem fs = FileSystem.get((Configuration)conf);
        Path inputPath = fs.makeQualified(new Path(util.getDataTestDirOnTestFS(table.getNameAsString()), "input.dat"));
        FSDataOutputStream op = fs.create(inputPath, true);
        op.write(Bytes.toBytes((String)data));
        op.close();
        LOG.debug(String.format("Wrote test data to file: %s", inputPath));
        if (conf.getBoolean(FORCE_COMBINER_CONF, true)) {
            LOG.debug("Forcing combiner.");
            conf.setInt("mapreduce.map.combine.minspills", 1);
        }
        ArrayList<String> argv = new ArrayList<String>(Arrays.asList(args));
        argv.add(inputPath.toString());
        ImportTsv tool = new ImportTsv();
        LOG.debug("Running ImportTsv with arguments: " + argv);
        try {
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)conf, (Tool)tool, (String[])argv.toArray(args)));
        }
        finally {
            if (conf.getBoolean(DELETE_AFTER_LOAD_CONF, true)) {
                LOG.debug("Deleting test subdirectory");
                util.cleanupDataTestDirOnTestFS(table.getNameAsString());
            }
        }
        return tool;
    }

    public static class TTLCheckingObserver
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            Region region = ((RegionCoprocessorEnvironment)e.getEnvironment()).getRegion();
            if (!region.getRegionInfo().isMetaRegion() && !region.getRegionInfo().getTable().isSystemTable()) {
                if (put.getTTL() != Long.MAX_VALUE) {
                    return;
                }
                throw new IOException("Operation does not have TTL set");
            }
        }
    }
}

