/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, MediumTests.class})
public class TestHRegionPartitioner {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHRegionPartitioner.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testHRegionPartitioner() throws Exception {
        byte[][] families = new byte[][]{Bytes.toBytes((String)"familyA"), Bytes.toBytes((String)"familyB")};
        UTIL.createTable(TableName.valueOf((String)this.name.getMethodName()), (byte[][])families, 1, Bytes.toBytes((String)"aa"), Bytes.toBytes((String)"cc"), 3);
        HRegionPartitioner partitioner = new HRegionPartitioner();
        Configuration configuration = UTIL.getConfiguration();
        configuration.set("hbase.mapred.outputtable", this.name.getMethodName());
        partitioner.setConf(configuration);
        ImmutableBytesWritable writable = new ImmutableBytesWritable(Bytes.toBytes((String)"bb"));
        Assert.assertEquals((long)1L, (long)partitioner.getPartition(writable, (Object)10L, 3));
        Assert.assertEquals((long)0L, (long)partitioner.getPartition(writable, (Object)10L, 1));
    }
}

