/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TestTableSnapshotScanner;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatTestBase;
import org.apache.hadoop.hbase.snapshot.SnapshotTestingUtils;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.VerySlowMapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={VerySlowMapReduceTests.class, LargeTests.class})
public class TestTableSnapshotInputFormat
extends TableSnapshotInputFormatTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableSnapshotInputFormat.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestTableSnapshotInputFormat.class);
    private static final byte[] bbb = Bytes.toBytes((String)"bbb");
    private static final byte[] yyy = Bytes.toBytes((String)"yyy");
    private static final byte[] bbc = Bytes.toBytes((String)"bbc");
    private static final byte[] yya = Bytes.toBytes((String)"yya");
    @Rule
    public TestName name = new TestName();

    @Override
    protected byte[] getStartRow() {
        return bbb;
    }

    @Override
    protected byte[] getEndRow() {
        return yyy;
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGetBestLocations() throws IOException {
        TableSnapshotInputFormatImpl tsif = new TableSnapshotInputFormatImpl();
        Configuration conf = this.UTIL.getConfiguration();
        HDFSBlocksDistribution blockDistribution = new HDFSBlocksDistribution();
        Assert.assertEquals(null, (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution = new HDFSBlocksDistribution();
        blockDistribution.addHostsAndBlockWeight(new String[]{"h1"}, 10L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 7L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 5L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 1L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 2L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h1", "h2"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h2"}, 3L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h1"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
        blockDistribution.addHostsAndBlockWeight(new String[]{"h3"}, 6L);
        blockDistribution.addHostsAndBlockWeight(new String[]{"h4"}, 9L);
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"h2", "h3", "h4"}), (Object)TableSnapshotInputFormatImpl.getBestLocations((Configuration)conf, (HDFSBlocksDistribution)blockDistribution));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInitTableSnapshotMapperJobConfig() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        String snapshotName = "foo";
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 1);
            Job job = new Job(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            Assert.assertEquals((String)"Snapshot job should be configured for default LruBlockCache.", (double)0.4f, (double)job.getConfiguration().getFloat("hfile.block.cache.size", -1.0f), (double)0.01);
            Assert.assertEquals((String)"Snapshot job should not use BucketCache.", (double)0.0, (double)job.getConfiguration().getFloat("hbase.bucketcache.size", -1.0f), (double)0.01);
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    @Override
    public void testRestoreSnapshotDoesNotCreateBackRefLinksInit(TableName tableName, String snapshotName, Path tmpTableDir) throws Exception {
        Job job = new Job(this.UTIL.getConfiguration());
        TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)new Scan(), TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testWithMockedMapReduce(HBaseTestingUtility util, String snapshotName, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean setLocalityEnabledTo) throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), numRegions);
            Configuration conf = util.getConfiguration();
            conf.setBoolean("hbase.TableSnapshotInputFormat.locality.enabled", setLocalityEnabledTo);
            Job job = new Job(conf);
            Path tmpTableDir = util.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(this.getStartRow(), this.getEndRow());
            if (numSplitsPerRegion > 1) {
                TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)numSplitsPerRegion);
            } else {
                TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            }
            this.verifyWithMockedMapReduce(job, numRegions, expectedNumSplits, this.getStartRow(), this.getEndRow());
        }
        finally {
            util.getAdmin().deleteSnapshot(snapshotName);
            util.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMockedMapReduceWithSplitsPerRegion() throws Exception {
        this.setupCluster();
        String snapshotName = "testWithMockedMapReduceMultiRegion";
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 10);
            Configuration conf = this.UTIL.getConfiguration();
            conf.setBoolean("hbase.TableSnapshotInputFormat.locality.enabled", false);
            Job job = new Job(conf);
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan(bbc, yya);
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)5);
            this.verifyWithMockedMapReduce(job, 10, 40, bbc, yya);
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWithMockedMapReduceWithNoStartRowStopRow() throws Exception {
        this.setupCluster();
        String snapshotName = "testWithMockedMapReduceMultiRegion";
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try {
            TestTableSnapshotInputFormat.createTableAndSnapshot(this.UTIL, tableName, snapshotName, this.getStartRow(), this.getEndRow(), 10);
            Configuration conf = this.UTIL.getConfiguration();
            conf.setBoolean("hbase.TableSnapshotInputFormat.locality.enabled", false);
            Job job = new Job(conf);
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan2 = new Scan();
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan2, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)5);
            this.verifyWithMockedMapReduce(job, 10, 50, HConstants.EMPTY_START_ROW, HConstants.EMPTY_START_ROW);
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoDuplicateResultsWhenSplitting() throws Exception {
        this.setupCluster();
        TableName tableName = TableName.valueOf((String)"testNoDuplicateResultsWhenSplitting");
        String snapshotName = "testSnapshotBug";
        try {
            if (this.UTIL.getAdmin().tableExists(tableName)) {
                this.UTIL.deleteTable(tableName);
            }
            this.UTIL.createTable(tableName, FAMILIES);
            Admin admin = this.UTIL.getAdmin();
            Table table = this.UTIL.getConnection().getTable(tableName);
            this.UTIL.loadTable(table, FAMILIES);
            admin.split(tableName, Bytes.toBytes((String)"eee"));
            TestTableSnapshotScanner.blockUntilSplitFinished((HBaseTestingUtility)this.UTIL, (TableName)tableName, (int)2);
            Path rootDir = FSUtils.getRootDir((Configuration)this.UTIL.getConfiguration());
            FileSystem fs = rootDir.getFileSystem(this.UTIL.getConfiguration());
            SnapshotTestingUtils.createSnapshotAndValidate((Admin)admin, (TableName)tableName, Arrays.asList(FAMILIES), null, (String)snapshotName, (Path)rootDir, (FileSystem)fs, (boolean)true);
            byte[] value = Bytes.toBytes((String)"after_snapshot_value");
            this.UTIL.loadTable(table, FAMILIES, value);
            admin.flush(tableName);
            table.close();
            Job job = new Job(this.UTIL.getConfiguration());
            Path tmpTableDir = this.UTIL.getDataTestDirOnTestFS(snapshotName);
            Scan scan = new Scan().withStartRow(this.getStartRow()).withStopRow(this.getEndRow());
            TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)false, (Path)tmpTableDir);
            this.verifyWithMockedMapReduce(job, 2, 2, this.getStartRow(), this.getEndRow());
        }
        finally {
            this.UTIL.getAdmin().deleteSnapshot(snapshotName);
            this.UTIL.deleteTable(tableName);
            this.tearDownCluster();
        }
    }

    private void verifyWithMockedMapReduce(Job job, int numRegions, int expectedNumSplits, byte[] startRow, byte[] stopRow) throws IOException, InterruptedException {
        TableSnapshotInputFormat tsif = new TableSnapshotInputFormat();
        List splits = tsif.getSplits((JobContext)job);
        Assert.assertEquals((long)expectedNumSplits, (long)splits.size());
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(startRow, stopRow.length > 0 ? stopRow : Bytes.toBytes((String)"\uffff"));
        boolean localityEnabled = job.getConfiguration().getBoolean("hbase.TableSnapshotInputFormat.locality.enabled", true);
        for (int i = 0; i < splits.size(); ++i) {
            InputSplit split = (InputSplit)splits.get(i);
            Assert.assertTrue((boolean)(split instanceof TableSnapshotInputFormat.TableSnapshotRegionSplit));
            TableSnapshotInputFormat.TableSnapshotRegionSplit snapshotRegionSplit = (TableSnapshotInputFormat.TableSnapshotRegionSplit)split;
            if (localityEnabled) {
                Assert.assertTrue((split.getLocations() != null && split.getLocations().length != 0 ? 1 : 0) != 0);
            } else {
                Assert.assertTrue((split.getLocations() != null && split.getLocations().length == 0 ? 1 : 0) != 0);
            }
            Scan scan = TableMapReduceUtil.convertStringToScan((String)snapshotRegionSplit.getDelegate().getScan());
            if (startRow.length > 0) {
                Assert.assertTrue((String)(Bytes.toStringBinary((byte[])startRow) + " should <= " + Bytes.toStringBinary((byte[])scan.getStartRow())), (Bytes.compareTo((byte[])startRow, (byte[])scan.getStartRow()) <= 0 ? 1 : 0) != 0);
            }
            if (stopRow.length > 0) {
                Assert.assertTrue((String)(Bytes.toStringBinary((byte[])stopRow) + " should >= " + Bytes.toStringBinary((byte[])scan.getStopRow())), (Bytes.compareTo((byte[])stopRow, (byte[])scan.getStopRow()) >= 0 ? 1 : 0) != 0);
            }
            Assert.assertTrue((String)"startRow should < stopRow", (Bytes.compareTo((byte[])scan.getStartRow(), (byte[])scan.getStopRow()) < 0 ? 1 : 0) != 0);
            TaskAttemptContext taskAttemptContext = (TaskAttemptContext)Mockito.mock(TaskAttemptContext.class);
            Mockito.when((Object)taskAttemptContext.getConfiguration()).thenReturn((Object)job.getConfiguration());
            RecordReader rr = tsif.createRecordReader(split, taskAttemptContext);
            rr.initialize(split, taskAttemptContext);
            while (rr.nextKeyValue()) {
                byte[] row = ((ImmutableBytesWritable)rr.getCurrentKey()).get();
                TestTableSnapshotInputFormat.verifyRowFromMap((ImmutableBytesWritable)rr.getCurrentKey(), (Result)rr.getCurrentValue());
                rowTracker.addRow(row);
            }
            rr.close();
        }
        rowTracker.validate();
    }

    @Override
    protected void testWithMapReduceImpl(HBaseTestingUtility util, TableName tableName, String snapshotName, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        TestTableSnapshotInputFormat.doTestWithMapReduce(util, tableName, snapshotName, this.getStartRow(), this.getEndRow(), tableDir, numRegions, numSplitsPerRegion, expectedNumSplits, shutdownCluster);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doTestWithMapReduce(HBaseTestingUtility util, TableName tableName, String snapshotName, byte[] startRow, byte[] endRow, Path tableDir, int numRegions, int numSplitsPerRegion, int expectedNumSplits, boolean shutdownCluster) throws Exception {
        LOG.info("testing with MapReduce");
        LOG.info("create the table and snapshot");
        TestTableSnapshotInputFormat.createTableAndSnapshot(util, tableName, snapshotName, startRow, endRow, numRegions);
        if (shutdownCluster) {
            LOG.info("shutting down hbase cluster.");
            util.shutdownMiniHBaseCluster();
        }
        try {
            Job job = new Job(util.getConfiguration());
            Scan scan = new Scan(startRow, endRow);
            job.setJarByClass(util.getClass());
            TableMapReduceUtil.addDependencyJarsForClasses((Configuration)job.getConfiguration(), (Class[])new Class[]{TestTableSnapshotInputFormat.class});
            if (numSplitsPerRegion > 1) {
                TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)true, (Path)tableDir, (RegionSplitter.SplitAlgorithm)new RegionSplitter.UniformSplit(), (int)numSplitsPerRegion);
            } else {
                TableMapReduceUtil.initTableSnapshotMapperJob((String)snapshotName, (Scan)scan, TestTableSnapshotMapper.class, ImmutableBytesWritable.class, NullWritable.class, (Job)job, (boolean)true, (Path)tableDir);
            }
            job.setReducerClass(TestTableSnapshotReducer.class);
            job.setNumReduceTasks(1);
            job.setOutputFormatClass(NullOutputFormat.class);
            Assert.assertTrue((boolean)job.waitForCompletion(true));
        }
        finally {
            if (!shutdownCluster) {
                util.getAdmin().deleteSnapshot(snapshotName);
                util.deleteTable(tableName);
            }
        }
    }

    static /* synthetic */ byte[] access$000() {
        return bbb;
    }

    static /* synthetic */ byte[] access$100() {
        return yyy;
    }

    public static class TestTableSnapshotReducer
    extends Reducer<ImmutableBytesWritable, NullWritable, NullWritable, NullWritable> {
        HBaseTestingUtility.SeenRowTracker rowTracker = new HBaseTestingUtility.SeenRowTracker(TestTableSnapshotInputFormat.access$000(), TestTableSnapshotInputFormat.access$100());

        protected void reduce(ImmutableBytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.addRow(key.get());
        }

        protected void cleanup(Reducer.Context context) throws IOException, InterruptedException {
            this.rowTracker.validate();
        }
    }

    public static class TestTableSnapshotMapper
    extends TableMapper<ImmutableBytesWritable, NullWritable> {
        protected void map(ImmutableBytesWritable key, Result value, Mapper.Context context) throws IOException, InterruptedException {
            TableSnapshotInputFormatTestBase.verifyRowFromMap(key, value);
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static enum TestTableSnapshotCounters {
        VALIDATION_ERROR;

    }
}

