/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileWriterImpl;
import org.apache.hadoop.hbase.mapreduce.CellSerialization;
import org.apache.hadoop.hbase.mapreduce.CellSortReducer;
import org.apache.hadoop.hbase.mapreduce.MultiTableHFileOutputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutSortReducer;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TextSortReducer;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileWriter;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.MapReduceExtendedCell;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.partition.TotalOrderPartitioner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class HFileOutputFormat2
extends FileOutputFormat<ImmutableBytesWritable, Cell> {
    private static final Logger LOG = LoggerFactory.getLogger(HFileOutputFormat2.class);
    protected static final byte[] tableSeparator = Bytes.toBytes((String)";");
    static final String COMPRESSION_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.compression";
    static final String BLOOM_TYPE_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomtype";
    static final String BLOOM_PARAM_FAMILIES_CONF_KEY = "hbase.hfileoutputformat.families.bloomparam";
    static final String BLOCK_SIZE_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.blocksize";
    static final String DATABLOCK_ENCODING_FAMILIES_CONF_KEY = "hbase.mapreduce.hfileoutputformat.families.datablock.encoding";
    public static final String DATABLOCK_ENCODING_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.datablock.encoding";
    public static final String COMPRESSION_OVERRIDE_CONF_KEY = "hbase.mapreduce.hfileoutputformat.compression";
    public static final String LOCALITY_SENSITIVE_CONF_KEY = "hbase.bulkload.locality.sensitive.enabled";
    private static final boolean DEFAULT_LOCALITY_SENSITIVE = true;
    static final String OUTPUT_TABLE_NAME_CONF_KEY = "hbase.mapreduce.hfileoutputformat.table.name";
    static final String MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY = "hbase.mapreduce.use.multi.table.hfileoutputformat";
    public static final String REMOTE_CLUSTER_ZOOKEEPER_QUORUM_CONF_KEY = "hbase.hfileoutputformat.remote.cluster.zookeeper.quorum";
    public static final String REMOTE_CLUSTER_ZOOKEEPER_CLIENT_PORT_CONF_KEY = "hbase.hfileoutputformat.remote.cluster.zookeeper.clientPort";
    public static final String REMOTE_CLUSTER_ZOOKEEPER_ZNODE_PARENT_CONF_KEY = "hbase.hfileoutputformat.remote.cluster.zookeeper.znode.parent";
    public static final String STORAGE_POLICY_PROPERTY = "hbase.hstore.block.storage.policy";
    public static final String STORAGE_POLICY_PROPERTY_CF_PREFIX = "hbase.hstore.block.storage.policy.";
    @InterfaceAudience.Private
    static Function<ColumnFamilyDescriptor, String> compressionDetails = familyDescriptor -> familyDescriptor.getCompressionType().getName();
    @InterfaceAudience.Private
    static Function<ColumnFamilyDescriptor, String> blockSizeDetails = familyDescriptor -> String.valueOf(familyDescriptor.getBlocksize());
    @InterfaceAudience.Private
    static Function<ColumnFamilyDescriptor, String> bloomTypeDetails = familyDescriptor -> {
        String bloomType = familyDescriptor.getBloomFilterType().toString();
        if (bloomType == null) {
            bloomType = ColumnFamilyDescriptorBuilder.DEFAULT_BLOOMFILTER.name();
        }
        return bloomType;
    };
    @InterfaceAudience.Private
    static Function<ColumnFamilyDescriptor, String> bloomParamDetails = familyDescriptor -> {
        BloomType bloomType = familyDescriptor.getBloomFilterType();
        String bloomParam = "";
        if (bloomType == BloomType.ROWPREFIX_FIXED_LENGTH) {
            bloomParam = familyDescriptor.getConfigurationValue("RowPrefixBloomFilter.prefix_length");
        }
        return bloomParam;
    };
    @InterfaceAudience.Private
    static Function<ColumnFamilyDescriptor, String> dataBlockEncodingDetails = familyDescriptor -> {
        DataBlockEncoding encoding = familyDescriptor.getDataBlockEncoding();
        if (encoding == null) {
            encoding = DataBlockEncoding.NONE;
        }
        return encoding.toString();
    };

    protected static byte[] combineTableNameSuffix(byte[] tableName, byte[] suffix) {
        return Bytes.add((byte[])tableName, (byte[])tableSeparator, (byte[])suffix);
    }

    public RecordWriter<ImmutableBytesWritable, Cell> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return HFileOutputFormat2.createRecordWriter(context, this.getOutputCommitter(context));
    }

    protected static byte[] getTableNameSuffixedWithFamily(byte[] tableName, byte[] family) {
        return HFileOutputFormat2.combineTableNameSuffix(tableName, family);
    }

    static <V extends Cell> RecordWriter<ImmutableBytesWritable, V> createRecordWriter(final TaskAttemptContext context, OutputCommitter committer) throws IOException {
        final Path outputDir = ((FileOutputCommitter)committer).getWorkPath();
        final Configuration conf = context.getConfiguration();
        final boolean writeMultipleTables = conf.getBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, false);
        final String writeTableNames = conf.get(OUTPUT_TABLE_NAME_CONF_KEY);
        if (writeTableNames == null || writeTableNames.isEmpty()) {
            throw new IllegalArgumentException("hbase.mapreduce.hfileoutputformat.table.name cannot be empty");
        }
        final FileSystem fs = outputDir.getFileSystem(conf);
        final long maxsize = conf.getLong("hbase.hregion.max.filesize", 0x280000000L);
        String defaultCompressionStr = conf.get("hfile.compression", Compression.Algorithm.NONE.getName());
        final Compression.Algorithm defaultCompression = HFileWriterImpl.compressionByName((String)defaultCompressionStr);
        String compressionStr = conf.get(COMPRESSION_OVERRIDE_CONF_KEY);
        final Compression.Algorithm overriddenCompression = compressionStr != null ? Compression.getCompressionAlgorithmByName((String)compressionStr) : null;
        final boolean compactionExclude = conf.getBoolean("hbase.mapreduce.hfileoutputformat.compaction.exclude", false);
        final Set allTableNames = Arrays.stream(writeTableNames.split(Bytes.toString((byte[])tableSeparator))).collect(Collectors.toSet());
        final Map<byte[], Compression.Algorithm> compressionMap = HFileOutputFormat2.createFamilyCompressionMap(conf);
        final Map<byte[], BloomType> bloomTypeMap = HFileOutputFormat2.createFamilyBloomTypeMap(conf);
        final Map<byte[], String> bloomParamMap = HFileOutputFormat2.createFamilyBloomParamMap(conf);
        final Map<byte[], Integer> blockSizeMap = HFileOutputFormat2.createFamilyBlockSizeMap(conf);
        String dataBlockEncodingStr = conf.get(DATABLOCK_ENCODING_OVERRIDE_CONF_KEY);
        final Map<byte[], DataBlockEncoding> datablockEncodingMap = HFileOutputFormat2.createFamilyDataBlockEncodingMap(conf);
        final DataBlockEncoding overriddenEncoding = dataBlockEncodingStr != null ? DataBlockEncoding.valueOf((String)dataBlockEncodingStr) : null;
        return new RecordWriter<ImmutableBytesWritable, V>(){
            private final Map<byte[], WriterLength> writers = new TreeMap<byte[], WriterLength>(Bytes.BYTES_COMPARATOR);
            private final Map<byte[], byte[]> previousRows = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
            private final long now = EnvironmentEdgeManager.currentTime();

            public void write(ImmutableBytesWritable row, V cell) throws IOException {
                Object kv = cell;
                if (row == null && kv == null) {
                    this.rollWriters(null);
                    return;
                }
                byte[] rowKey = CellUtil.cloneRow(kv);
                int length = PrivateCellUtil.estimatedSerializedSizeOf(kv) - 4;
                byte[] family = CellUtil.cloneFamily(kv);
                byte[] tableNameBytes = null;
                if (writeMultipleTables) {
                    tableNameBytes = MultiTableHFileOutputFormat.getTableName(row.get());
                    if (!allTableNames.contains(Bytes.toString((byte[])(tableNameBytes = TableName.valueOf((byte[])tableNameBytes).toBytes())))) {
                        throw new IllegalArgumentException("TableName " + Bytes.toString((byte[])tableNameBytes) + " not expected");
                    }
                } else {
                    tableNameBytes = Bytes.toBytes((String)writeTableNames);
                }
                Path tableRelPath = this.getTableRelativePath(tableNameBytes);
                byte[] tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableNameBytes, family);
                WriterLength wl = this.writers.get(tableAndFamily);
                if (wl == null) {
                    Path writerPath = null;
                    writerPath = writeMultipleTables ? new Path(outputDir, new Path(tableRelPath, Bytes.toString((byte[])family))) : new Path(outputDir, Bytes.toString((byte[])family));
                    fs.mkdirs(writerPath);
                    HFileOutputFormat2.configureStoragePolicy(conf, fs, tableAndFamily, writerPath);
                }
                if (wl != null && wl.written + (long)length >= maxsize && Bytes.compareTo((byte[])this.previousRows.get(family), (byte[])rowKey) != 0) {
                    this.rollWriters(wl);
                }
                if (wl == null || wl.writer == null) {
                    if (conf.getBoolean(HFileOutputFormat2.LOCALITY_SENSITIVE_CONF_KEY, true)) {
                        HRegionLocation loc = null;
                        String tableName = Bytes.toString((byte[])tableNameBytes);
                        if (tableName != null) {
                            try (Connection connection = ConnectionFactory.createConnection((Configuration)this.createRemoteClusterConf(conf));
                                 RegionLocator locator = connection.getRegionLocator(TableName.valueOf((String)tableName));){
                                loc = locator.getRegionLocation(rowKey);
                            }
                            catch (Throwable e) {
                                LOG.warn("Something wrong locating rowkey {} in {}", new Object[]{Bytes.toString((byte[])rowKey), tableName, e});
                                loc = null;
                            }
                        }
                        if (null == loc) {
                            LOG.trace("Failed get of location, use default writer {}", (Object)Bytes.toString((byte[])rowKey));
                            wl = this.getNewWriter(tableNameBytes, family, conf, null);
                        } else {
                            LOG.debug("First rowkey: [{}]", (Object)Bytes.toString((byte[])rowKey));
                            InetSocketAddress initialIsa = new InetSocketAddress(loc.getHostname(), loc.getPort());
                            if (initialIsa.isUnresolved()) {
                                LOG.trace("Failed resolve address {}, use default writer", (Object)loc.getHostnamePort());
                                wl = this.getNewWriter(tableNameBytes, family, conf, null);
                            } else {
                                LOG.debug("Use favored nodes writer: {}", (Object)initialIsa.getHostString());
                                wl = this.getNewWriter(tableNameBytes, family, conf, new InetSocketAddress[]{initialIsa});
                            }
                        }
                    } else {
                        wl = this.getNewWriter(tableNameBytes, family, conf, null);
                    }
                }
                PrivateCellUtil.updateLatestStamp(cell, (long)this.now);
                wl.writer.append(kv);
                wl.written += (long)length;
                this.previousRows.put(family, rowKey);
            }

            private Path getTableRelativePath(byte[] tableNameBytes) {
                String tableName = Bytes.toString((byte[])tableNameBytes);
                String[] tableNameParts = tableName.split(":");
                Path tableRelPath = new Path(tableName.split(":")[0]);
                if (tableNameParts.length > 1) {
                    tableRelPath = new Path(tableRelPath, tableName.split(":")[1]);
                }
                return tableRelPath;
            }

            private void rollWriters(WriterLength writerLength) throws IOException {
                if (writerLength != null) {
                    this.closeWriter(writerLength);
                } else {
                    for (WriterLength wl : this.writers.values()) {
                        this.closeWriter(wl);
                    }
                }
            }

            private void closeWriter(WriterLength wl) throws IOException {
                if (wl.writer != null) {
                    LOG.info("Writer=" + wl.writer.getPath() + (wl.written == 0L ? "" : ", wrote=" + wl.written));
                    this.close(wl.writer);
                    wl.writer = null;
                }
                wl.written = 0L;
            }

            private Configuration createRemoteClusterConf(Configuration conf2) {
                Configuration newConf = new Configuration(conf2);
                String quorum = conf2.get(HFileOutputFormat2.REMOTE_CLUSTER_ZOOKEEPER_QUORUM_CONF_KEY);
                String clientPort = conf2.get(HFileOutputFormat2.REMOTE_CLUSTER_ZOOKEEPER_CLIENT_PORT_CONF_KEY);
                String parent = conf2.get(HFileOutputFormat2.REMOTE_CLUSTER_ZOOKEEPER_ZNODE_PARENT_CONF_KEY);
                if (quorum != null && clientPort != null && parent != null) {
                    newConf.set("hbase.zookeeper.quorum", quorum);
                    newConf.setInt("hbase.zookeeper.property.clientPort", Integer.parseInt(clientPort));
                    newConf.set("zookeeper.znode.parent", parent);
                }
                return newConf;
            }

            @SuppressWarnings(value={"BX_UNBOXING_IMMEDIATELY_REBOXED"}, justification="Not important")
            private WriterLength getNewWriter(byte[] tableName, byte[] family, Configuration conf2, InetSocketAddress[] favoredNodes) throws IOException {
                Integer blockSize;
                byte[] tableAndFamily = HFileOutputFormat2.getTableNameSuffixedWithFamily(tableName, family);
                Path familydir = new Path(outputDir, Bytes.toString((byte[])family));
                if (writeMultipleTables) {
                    familydir = new Path(outputDir, new Path(this.getTableRelativePath(tableName), Bytes.toString((byte[])family)));
                }
                WriterLength wl = new WriterLength();
                Compression.Algorithm compression = overriddenCompression;
                compression = compression == null ? (Compression.Algorithm)compressionMap.get(tableAndFamily) : compression;
                compression = compression == null ? defaultCompression : compression;
                BloomType bloomType = (BloomType)bloomTypeMap.get(tableAndFamily);
                bloomType = bloomType == null ? BloomType.NONE : bloomType;
                String bloomParam = (String)bloomParamMap.get(tableAndFamily);
                if (bloomType == BloomType.ROWPREFIX_FIXED_LENGTH) {
                    conf2.set("RowPrefixBloomFilter.prefix_length", bloomParam);
                }
                blockSize = (blockSize = (Integer)blockSizeMap.get(tableAndFamily)) == null ? 65536 : blockSize;
                DataBlockEncoding encoding = overriddenEncoding;
                encoding = encoding == null ? (DataBlockEncoding)datablockEncodingMap.get(tableAndFamily) : encoding;
                encoding = encoding == null ? DataBlockEncoding.NONE : encoding;
                HFileContextBuilder contextBuilder = new HFileContextBuilder().withCompression(compression).withDataBlockEncoding(encoding).withChecksumType(StoreUtils.getChecksumType((Configuration)conf2)).withBytesPerCheckSum(StoreUtils.getBytesPerChecksum((Configuration)conf2)).withBlockSize(blockSize.intValue()).withColumnFamily(family).withTableName(tableName);
                if (HFile.getFormatVersion((Configuration)conf2) >= 3) {
                    contextBuilder.withIncludesTags(true);
                }
                HFileContext hFileContext = contextBuilder.build();
                wl.writer = null == favoredNodes ? new StoreFileWriter.Builder(conf2, CacheConfig.DISABLED, fs).withOutputDir(familydir).withBloomType(bloomType).withFileContext(hFileContext).build() : new StoreFileWriter.Builder(conf2, CacheConfig.DISABLED, (FileSystem)new HFileSystem(fs)).withOutputDir(familydir).withBloomType(bloomType).withFileContext(hFileContext).withFavoredNodes(favoredNodes).build();
                this.writers.put(tableAndFamily, wl);
                return wl;
            }

            private void close(StoreFileWriter w) throws IOException {
                if (w != null) {
                    w.appendFileInfo(HStoreFile.BULKLOAD_TIME_KEY, Bytes.toBytes((long)System.currentTimeMillis()));
                    w.appendFileInfo(HStoreFile.BULKLOAD_TASK_KEY, Bytes.toBytes((String)context.getTaskAttemptID().toString()));
                    w.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes((boolean)true));
                    w.appendFileInfo(HStoreFile.EXCLUDE_FROM_MINOR_COMPACTION_KEY, Bytes.toBytes((boolean)compactionExclude));
                    w.appendTrackedTimestampsToMetadata();
                    w.close();
                }
            }

            public void close(TaskAttemptContext c) throws IOException, InterruptedException {
                for (WriterLength wl : this.writers.values()) {
                    this.close(wl.writer);
                }
            }
        };
    }

    static void configureStoragePolicy(Configuration conf, FileSystem fs, byte[] tableAndFamily, Path cfPath) {
        if (null == conf || null == fs || null == tableAndFamily || null == cfPath) {
            return;
        }
        String policy = conf.get(STORAGE_POLICY_PROPERTY_CF_PREFIX + Bytes.toString((byte[])tableAndFamily), conf.get(STORAGE_POLICY_PROPERTY));
        CommonFSUtils.setStoragePolicy((FileSystem)fs, (Path)cfPath, (String)policy);
    }

    private static List<ImmutableBytesWritable> getRegionStartKeys(List<RegionLocator> regionLocators, boolean writeMultipleTables) throws IOException {
        ArrayList<ImmutableBytesWritable> ret = new ArrayList<ImmutableBytesWritable>();
        for (RegionLocator regionLocator : regionLocators) {
            byte[][] byteKeys;
            TableName tableName = regionLocator.getName();
            LOG.info("Looking up current regions for table " + tableName);
            byte[][] byArray = byteKeys = regionLocator.getStartKeys();
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] byteKey;
                byte[] fullKey = byteKey = byArray[i];
                if (writeMultipleTables) {
                    fullKey = HFileOutputFormat2.combineTableNameSuffix(tableName.getName(), byteKey);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SplitPoint startkey for " + tableName + ": " + Bytes.toStringBinary((byte[])fullKey));
                }
                ret.add(new ImmutableBytesWritable(fullKey));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePartitions(Configuration conf, Path partitionsPath, List<ImmutableBytesWritable> startKeys, boolean writeMultipleTables) throws IOException {
        LOG.info("Writing partition information to " + partitionsPath);
        if (startKeys.isEmpty()) {
            throw new IllegalArgumentException("No regions passed");
        }
        TreeSet<ImmutableBytesWritable> sorted = new TreeSet<ImmutableBytesWritable>(startKeys);
        ImmutableBytesWritable first = sorted.first();
        if (writeMultipleTables) {
            first = new ImmutableBytesWritable(MultiTableHFileOutputFormat.getSuffix(sorted.first().get()));
        }
        if (!first.equals((Object)HConstants.EMPTY_BYTE_ARRAY)) {
            throw new IllegalArgumentException("First region of table should have empty start key. Instead has: " + Bytes.toStringBinary((byte[])first.get()));
        }
        sorted.remove(sorted.first());
        FileSystem fs = partitionsPath.getFileSystem(conf);
        try (SequenceFile.Writer writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)partitionsPath, ImmutableBytesWritable.class, NullWritable.class);){
            for (ImmutableBytesWritable startKey : sorted) {
                writer.append((Writable)startKey, (Writable)NullWritable.get());
            }
        }
    }

    public static void configureIncrementalLoad(Job job, Table table, RegionLocator regionLocator) throws IOException {
        HFileOutputFormat2.configureIncrementalLoad(job, table.getDescriptor(), regionLocator);
        HFileOutputFormat2.configureRemoteCluster(job, table.getConfiguration());
    }

    public static void configureIncrementalLoad(Job job, TableDescriptor tableDescriptor, RegionLocator regionLocator) throws IOException {
        ArrayList<TableInfo> singleTableInfo = new ArrayList<TableInfo>();
        singleTableInfo.add(new TableInfo(tableDescriptor, regionLocator));
        HFileOutputFormat2.configureIncrementalLoad(job, singleTableInfo, HFileOutputFormat2.class);
    }

    static void configureIncrementalLoad(Job job, List<TableInfo> multiTableInfo, Class<? extends OutputFormat<?, ?>> cls) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(MapReduceExtendedCell.class);
        job.setOutputFormatClass(cls);
        if (multiTableInfo.stream().distinct().count() != (long)multiTableInfo.size()) {
            throw new IllegalArgumentException("Duplicate entries found in TableInfo argument");
        }
        boolean writeMultipleTables = false;
        if (MultiTableHFileOutputFormat.class.equals(cls)) {
            writeMultipleTables = true;
            conf.setBoolean(MULTI_TABLE_HFILEOUTPUTFORMAT_CONF_KEY, true);
        }
        if (KeyValue.class.equals((Object)job.getMapOutputValueClass()) || MapReduceExtendedCell.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(CellSortReducer.class);
        } else if (Put.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(PutSortReducer.class);
        } else if (Text.class.equals((Object)job.getMapOutputValueClass())) {
            job.setReducerClass(TextSortReducer.class);
        } else {
            LOG.warn("Unknown map output value type:" + job.getMapOutputValueClass());
        }
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        if (conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
            LOG.info("bulkload locality sensitive enabled");
        }
        ArrayList<String> allTableNames = new ArrayList<String>(multiTableInfo.size());
        ArrayList<RegionLocator> regionLocators = new ArrayList<RegionLocator>(multiTableInfo.size());
        ArrayList<TableDescriptor> tableDescriptors = new ArrayList<TableDescriptor>(multiTableInfo.size());
        for (TableInfo tableInfo : multiTableInfo) {
            regionLocators.add(tableInfo.getRegionLocator());
            allTableNames.add(tableInfo.getRegionLocator().getName().getNameAsString());
            tableDescriptors.add(tableInfo.getTableDescriptor());
        }
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, StringUtils.join(allTableNames, (String)Bytes.toString((byte[])tableSeparator)));
        List<ImmutableBytesWritable> startKeys = HFileOutputFormat2.getRegionStartKeys(regionLocators, writeMultipleTables);
        LOG.info("Configuring " + startKeys.size() + " reduce partitions to match current region count for all tables");
        job.setNumReduceTasks(startKeys.size());
        HFileOutputFormat2.configurePartitioner(job, startKeys, writeMultipleTables);
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, tableDescriptors));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, tableDescriptors));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, tableDescriptors));
        conf.set(BLOOM_PARAM_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomParamDetails, tableDescriptors));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, tableDescriptors));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info("Incremental output configured for tables: " + StringUtils.join(allTableNames, (String)","));
    }

    public static void configureIncrementalLoadMap(Job job, TableDescriptor tableDescriptor) throws IOException {
        Configuration conf = job.getConfiguration();
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(MapReduceExtendedCell.class);
        job.setOutputFormatClass(HFileOutputFormat2.class);
        ArrayList<TableDescriptor> singleTableDescriptor = new ArrayList<TableDescriptor>(1);
        singleTableDescriptor.add(tableDescriptor);
        conf.set(OUTPUT_TABLE_NAME_CONF_KEY, tableDescriptor.getTableName().getNameAsString());
        conf.set(COMPRESSION_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(compressionDetails, singleTableDescriptor));
        conf.set(BLOCK_SIZE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(blockSizeDetails, singleTableDescriptor));
        conf.set(BLOOM_TYPE_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomTypeDetails, singleTableDescriptor));
        conf.set(BLOOM_PARAM_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(bloomParamDetails, singleTableDescriptor));
        conf.set(DATABLOCK_ENCODING_FAMILIES_CONF_KEY, HFileOutputFormat2.serializeColumnFamilyAttribute(dataBlockEncodingDetails, singleTableDescriptor));
        TableMapReduceUtil.addDependencyJars(job);
        TableMapReduceUtil.initCredentials(job);
        LOG.info("Incremental table " + tableDescriptor.getTableName() + " output configured.");
    }

    public static void configureRemoteCluster(Job job, Configuration clusterConf) {
        Configuration conf = job.getConfiguration();
        if (!conf.getBoolean(LOCALITY_SENSITIVE_CONF_KEY, true)) {
            return;
        }
        String quorum = clusterConf.get("hbase.zookeeper.quorum");
        int clientPort = clusterConf.getInt("hbase.zookeeper.property.clientPort", 2181);
        String parent = clusterConf.get("zookeeper.znode.parent", "/hbase");
        conf.set(REMOTE_CLUSTER_ZOOKEEPER_QUORUM_CONF_KEY, quorum);
        conf.setInt(REMOTE_CLUSTER_ZOOKEEPER_CLIENT_PORT_CONF_KEY, clientPort);
        conf.set(REMOTE_CLUSTER_ZOOKEEPER_ZNODE_PARENT_CONF_KEY, parent);
        LOG.info("ZK configs for remote cluster of bulkload is configured: " + quorum + ":" + clientPort + "/" + parent);
    }

    @InterfaceAudience.Private
    static Map<byte[], Compression.Algorithm> createFamilyCompressionMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, COMPRESSION_FAMILIES_CONF_KEY);
        TreeMap<byte[], Compression.Algorithm> compressionMap = new TreeMap<byte[], Compression.Algorithm>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Compression.Algorithm algorithm = HFileWriterImpl.compressionByName((String)e.getValue());
            compressionMap.put(e.getKey(), algorithm);
        }
        return compressionMap;
    }

    @InterfaceAudience.Private
    static Map<byte[], BloomType> createFamilyBloomTypeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOOM_TYPE_FAMILIES_CONF_KEY);
        TreeMap<byte[], BloomType> bloomTypeMap = new TreeMap<byte[], BloomType>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            BloomType bloomType = BloomType.valueOf((String)e.getValue());
            bloomTypeMap.put(e.getKey(), bloomType);
        }
        return bloomTypeMap;
    }

    @InterfaceAudience.Private
    static Map<byte[], String> createFamilyBloomParamMap(Configuration conf) {
        return HFileOutputFormat2.createFamilyConfValueMap(conf, BLOOM_PARAM_FAMILIES_CONF_KEY);
    }

    @InterfaceAudience.Private
    static Map<byte[], Integer> createFamilyBlockSizeMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, BLOCK_SIZE_FAMILIES_CONF_KEY);
        TreeMap<byte[], Integer> blockSizeMap = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            Integer blockSize = Integer.parseInt(e.getValue());
            blockSizeMap.put(e.getKey(), blockSize);
        }
        return blockSizeMap;
    }

    @InterfaceAudience.Private
    static Map<byte[], DataBlockEncoding> createFamilyDataBlockEncodingMap(Configuration conf) {
        Map<byte[], String> stringMap = HFileOutputFormat2.createFamilyConfValueMap(conf, DATABLOCK_ENCODING_FAMILIES_CONF_KEY);
        TreeMap<byte[], DataBlockEncoding> encoderMap = new TreeMap<byte[], DataBlockEncoding>(Bytes.BYTES_COMPARATOR);
        for (Map.Entry<byte[], String> e : stringMap.entrySet()) {
            encoderMap.put(e.getKey(), DataBlockEncoding.valueOf((String)e.getValue()));
        }
        return encoderMap;
    }

    private static Map<byte[], String> createFamilyConfValueMap(Configuration conf, String confName) {
        TreeMap<byte[], String> confValMap = new TreeMap<byte[], String>(Bytes.BYTES_COMPARATOR);
        String confVal = conf.get(confName, "");
        for (String familyConf : confVal.split("&")) {
            String[] familySplit = familyConf.split("=");
            if (familySplit.length != 2) continue;
            try {
                confValMap.put(Bytes.toBytes((String)URLDecoder.decode(familySplit[0], "UTF-8")), URLDecoder.decode(familySplit[1], "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)e);
            }
        }
        return confValMap;
    }

    static void configurePartitioner(Job job, List<ImmutableBytesWritable> splitPoints, boolean writeMultipleTables) throws IOException {
        Configuration conf = job.getConfiguration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        String hbaseTmpFsDir = conf.get("hbase.fs.tmp.dir", HConstants.DEFAULT_TEMPORARY_HDFS_DIRECTORY);
        Path partitionsPath = new Path(hbaseTmpFsDir, "partitions_" + UUID.randomUUID());
        fs.makeQualified(partitionsPath);
        HFileOutputFormat2.writePartitions(conf, partitionsPath, splitPoints, writeMultipleTables);
        fs.deleteOnExit(partitionsPath);
        job.setPartitionerClass(TotalOrderPartitioner.class);
        TotalOrderPartitioner.setPartitionFile((Configuration)conf, (Path)partitionsPath);
    }

    @InterfaceAudience.Private
    @SuppressWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"})
    static String serializeColumnFamilyAttribute(Function<ColumnFamilyDescriptor, String> fn, List<TableDescriptor> allTables) throws UnsupportedEncodingException {
        StringBuilder attributeValue = new StringBuilder();
        int i = 0;
        for (TableDescriptor tableDescriptor : allTables) {
            if (tableDescriptor == null) {
                return "";
            }
            for (ColumnFamilyDescriptor familyDescriptor : tableDescriptor.getColumnFamilies()) {
                if (i++ > 0) {
                    attributeValue.append('&');
                }
                attributeValue.append(URLEncoder.encode(Bytes.toString((byte[])HFileOutputFormat2.combineTableNameSuffix(tableDescriptor.getTableName().getName(), familyDescriptor.getName())), "UTF-8"));
                attributeValue.append('=');
                attributeValue.append(URLEncoder.encode(fn.apply(familyDescriptor), "UTF-8"));
            }
        }
        return attributeValue.toString();
    }

    static class WriterLength {
        long written = 0L;
        StoreFileWriter writer = null;

        WriterLength() {
        }
    }

    static class TableInfo {
        private TableDescriptor tableDesctiptor;
        private RegionLocator regionLocator;

        public TableInfo(TableDescriptor tableDesctiptor, RegionLocator regionLocator) {
            this.tableDesctiptor = tableDesctiptor;
            this.regionLocator = regionLocator;
        }

        @Deprecated
        public HTableDescriptor getHTableDescriptor() {
            return new HTableDescriptor(this.tableDesctiptor);
        }

        public TableDescriptor getTableDescriptor() {
            return this.tableDesctiptor;
        }

        public RegionLocator getRegionLocator() {
            return this.regionLocator;
        }
    }
}

