/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ArrayBackedTag;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.TagUtil;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.CellCreator;
import org.apache.hadoop.hbase.security.visibility.CellVisibility;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.StringUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public class PutSortReducer
extends Reducer<ImmutableBytesWritable, Put, ImmutableBytesWritable, KeyValue> {
    private CellCreator kvCreator;

    protected void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration conf = context.getConfiguration();
        this.kvCreator = new CellCreator(conf);
    }

    protected void reduce(ImmutableBytesWritable row, Iterable<Put> puts, Reducer.Context context) throws IOException, InterruptedException {
        long threshold = context.getConfiguration().getLong("putsortreducer.row.threshold", 0x40000000L);
        Iterator<Put> iter = puts.iterator();
        while (iter.hasNext()) {
            TreeSet<KeyValue> map = new TreeSet<KeyValue>((Comparator<KeyValue>)CellComparator.getInstance());
            long curSize = 0L;
            ArrayList<Tag> tags = new ArrayList<Tag>();
            while (iter.hasNext() && curSize < threshold) {
                byte[] acl;
                tags.clear();
                Put p = iter.next();
                long t = p.getTTL();
                if (t != Long.MAX_VALUE) {
                    tags.add((Tag)new ArrayBackedTag(8, Bytes.toBytes((long)t)));
                }
                if ((acl = p.getACL()) != null) {
                    tags.add((Tag)new ArrayBackedTag(1, acl));
                }
                try {
                    CellVisibility cellVisibility = p.getCellVisibility();
                    if (cellVisibility != null) {
                        tags.addAll(this.kvCreator.getVisibilityExpressionResolver().createVisibilityExpTags(cellVisibility.getExpression()));
                    }
                }
                catch (DeserializationException e) {
                    throw new IOException("Invalid visibility expression found in mutation " + p, e);
                }
                for (List cells : p.getFamilyCellMap().values()) {
                    for (Cell cell : cells) {
                        KeyValue kv = null;
                        TagUtil.carryForwardTags(tags, (Cell)cell);
                        kv = !tags.isEmpty() ? (KeyValue)this.kvCreator.create(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), tags) : KeyValueUtil.ensureKeyValue((Cell)cell);
                        if (!map.add(kv)) continue;
                        curSize += kv.heapSize();
                    }
                }
            }
            context.setStatus("Read " + map.size() + " entries of " + map.getClass() + "(" + StringUtils.humanReadableInt((long)curSize) + ")");
            int index = 0;
            for (KeyValue kv : map) {
                context.write((Object)row, (Object)kv);
                if (++index % 100 != 0) continue;
                context.setStatus("Wrote " + index);
            }
            if (!iter.hasNext()) continue;
            context.write(null, null);
        }
    }
}

