/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.codahale.metrics.MetricRegistry;
import com.google.protobuf.Message;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.http.HttpServer;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.mapreduce.CellSerialization;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.mapreduce.JarFinder;
import org.apache.hadoop.hbase.mapreduce.JobUtil;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutCombiner;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.replication.ReplicationUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.unsafe.HBasePlatformDependent;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.RegionSplitter;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hbase.thirdparty.com.google.gson.GsonBuilder;
import org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.hbase.thirdparty.io.netty.channel.Channel;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class TableMapReduceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TableMapReduceUtil.class);
    public static final String TABLE_INPUT_CLASS_KEY = "hbase.table.input.class";

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(TableName table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table.getNameAsString(), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, true, inputFormatClass);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, boolean initCredentials, Class<? extends InputFormat> inputFormatClass) throws IOException {
        job.setInputFormatClass(inputFormatClass);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        if (Put.class.equals(outputValueClass)) {
            job.setCombinerClass(PutCombiner.class);
        }
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        conf.set("hbase.mapreduce.inputtable", table);
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString(scan));
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), CellSerialization.class.getName()});
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        if (initCredentials) {
            TableMapReduceUtil.initCredentials(job);
        }
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, inputFormatClass);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString((byte[])table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableMapReduceUtil.getConfiguredInputFormat(job));
    }

    private static Class<? extends InputFormat> getConfiguredInputFormat(Job job) {
        return job.getConfiguration().getClass(TABLE_INPUT_CLASS_KEY, TableInputFormat.class);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableMapReduceUtil.getConfiguredInputFormat(job));
    }

    public static void resetCacheConfig(Configuration conf) {
        conf.setFloat("hfile.block.cache.size", 0.4f);
        conf.setFloat("hbase.bucketcache.size", 0.0f);
        conf.unset("hbase.bucketcache.ioengine");
    }

    public static void initMultiTableSnapshotMapperJob(Map<String, Collection<Scan>> snapshotScans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        MultiTableSnapshotInputFormat.setInput(job.getConfiguration(), snapshotScans, tmpRestoreDir);
        job.setInputFormatClass(MultiTableSnapshotInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
            TableMapReduceUtil.addDependencyJarsForClasses(job.getConfiguration(), MetricRegistry.class);
        }
        TableMapReduceUtil.resetCacheConfig(job.getConfiguration());
    }

    public static void initTableSnapshotMapperJob(String snapshotName, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        TableSnapshotInputFormat.setInput(job, snapshotName, tmpRestoreDir);
        TableMapReduceUtil.initTableMapperJob(snapshotName, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, false, TableSnapshotInputFormat.class);
        TableMapReduceUtil.resetCacheConfig(job.getConfiguration());
    }

    public static void initTableSnapshotMapperJob(String snapshotName, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Path tmpRestoreDir, RegionSplitter.SplitAlgorithm splitAlgo, int numSplitsPerRegion) throws IOException {
        TableSnapshotInputFormat.setInput(job, snapshotName, tmpRestoreDir, splitAlgo, numSplitsPerRegion);
        TableMapReduceUtil.initTableMapperJob(snapshotName, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, false, TableSnapshotInputFormat.class);
        TableMapReduceUtil.resetCacheConfig(job.getConfiguration());
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, boolean initCredentials) throws IOException {
        job.setInputFormatClass(MultiTableInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        ArrayList<String> scanStrings = new ArrayList<String>();
        for (Scan scan : scans) {
            scanStrings.add(TableMapReduceUtil.convertScanToString(scan));
        }
        job.getConfiguration().setStrings("hbase.mapreduce.scans", scanStrings.toArray(new String[scanStrings.size()]));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        if (initCredentials) {
            TableMapReduceUtil.initCredentials(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCredentials(Job job) throws IOException {
        UserProvider userProvider = UserProvider.instantiate((Configuration)job.getConfiguration());
        if (userProvider.isHadoopSecurityEnabled() && System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            job.getConfiguration().set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (userProvider.isHBaseSecurityEnabled()) {
            try {
                String quorumAddress = job.getConfiguration().get("hbase.mapred.output.quorum");
                User user = userProvider.getCurrent();
                if (quorumAddress != null) {
                    Configuration peerConf = HBaseConfiguration.createClusterConf((Configuration)job.getConfiguration(), (String)quorumAddress, (String)"hbase.mapred.output.");
                    try (Connection peerConn = ConnectionFactory.createConnection((Configuration)peerConf);){
                        TokenUtil.addTokenForJob((Connection)peerConn, (User)user, (Job)job);
                    }
                }
                try (Connection conn = ConnectionFactory.createConnection((Configuration)job.getConfiguration());){
                    TokenUtil.addTokenForJob((Connection)conn, (User)user, (Job)job);
                }
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted obtaining user authentication token");
                Thread.currentThread().interrupt();
            }
        }
    }

    @Deprecated
    public static void initCredentialsForCluster(Job job, String quorumAddress) throws IOException {
        Configuration peerConf = HBaseConfiguration.createClusterConf((Configuration)job.getConfiguration(), (String)quorumAddress);
        TableMapReduceUtil.initCredentialsForCluster(job, peerConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCredentialsForCluster(Job job, Configuration conf) throws IOException {
        UserProvider userProvider = UserProvider.instantiate((Configuration)conf);
        if (userProvider.isHBaseSecurityEnabled()) {
            try (Connection peerConn = ConnectionFactory.createConnection((Configuration)conf);){
                TokenUtil.addTokenForJob((Connection)peerConn, (User)userProvider.getCurrent(), (Job)job);
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted obtaining user authentication token");
                Thread.interrupted();
            }
        }
    }

    public static String convertScanToString(Scan scan) throws IOException {
        ClientProtos.Scan proto = ProtobufUtil.toScan((Scan)scan);
        return Bytes.toString((byte[])Base64.getEncoder().encode(proto.toByteArray()));
    }

    public static Scan convertStringToScan(String base64) throws IOException {
        byte[] decoded = Base64.getDecoder().decode(base64);
        return ProtobufUtil.toScan((ClientProtos.Scan)ClientProtos.Scan.parseFrom((byte[])decoded));
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, null, null, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, quorumAddress, serverClass, serverImpl, true);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl, boolean addDependencyJars) throws IOException {
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge((Configuration)conf, (Configuration)HBaseConfiguration.create((Configuration)conf));
        job.setOutputFormatClass(TableOutputFormat.class);
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        conf.set("hbase.mapred.outputtable", table);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        if (quorumAddress != null) {
            ZKConfig.validateClusterKey((String)quorumAddress);
            conf.set("hbase.mapred.output.quorum", quorumAddress);
        }
        if (serverClass != null && serverImpl != null) {
            conf.set("hbase.mapred.output.rs.class", serverClass);
            conf.set("hbase.mapred.output.rs.impl", serverImpl);
        }
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Writable.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            int regions = TableMapReduceUtil.getRegionCount(conf, TableName.valueOf((String)table));
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(regions);
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void limitNumReduceTasks(String table, Job job) throws IOException {
        int regions = TableMapReduceUtil.getRegionCount(job.getConfiguration(), TableName.valueOf((String)table));
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, Job job) throws IOException {
        job.setNumReduceTasks(TableMapReduceUtil.getRegionCount(job.getConfiguration(), TableName.valueOf((String)table)));
    }

    public static void setScannerCaching(Job job, int batchSize) {
        job.getConfiguration().setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addHBaseDependencyJars(Configuration conf) throws IOException {
        TableMapReduceUtil.addDependencyJarsForClasses(conf, HConstants.class, org.apache.hadoop.hbase.protobuf.generated.ClientProtos.class, ClientProtos.class, Put.class, RpcServer.class, CompatibilityFactory.class, JobUtil.class, TableMapper.class, FastLongHistogram.class, Snapshot.class, ReplicationUtils.class, HttpServer.class, Procedure.class, ZKWatcher.class, Lists.class, GsonBuilder.class, UnsafeByteOperations.class, Channel.class, HBasePlatformDependent.class, ZooKeeper.class, Message.class, MetricRegistry.class, ArrayUtils.class, Span.class, SemanticAttributes.class);
    }

    public static String buildDependencyClasspath(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("Must provide a configuration object.");
        }
        HashSet paths = new HashSet(conf.getStringCollection("tmpjars"));
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("Configuration contains no tmpjars.");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : paths) {
            int idx = s.indexOf(":");
            if (idx != -1) {
                s = s.substring(idx + 1);
            }
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static void addDependencyJars(Job job) throws IOException {
        TableMapReduceUtil.addHBaseDependencyJars(job.getConfiguration());
        try {
            TableMapReduceUtil.addDependencyJarsForClasses(job.getConfiguration(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    @Deprecated
    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LOG.warn("The addDependencyJars(Configuration, Class<?>...) method has been deprecated since it is easy to use incorrectly. Most users should rely on addDependencyJars(Job) instead. See HBASE-8386 for more details.");
        TableMapReduceUtil.addDependencyJarsForClasses(conf, classes);
    }

    @InterfaceAudience.Private
    public static void addDependencyJarsForClasses(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = TableMapReduceUtil.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn("Could not validate jar file " + path + " for class " + clazz);
                continue;
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    private static Path findOrCreateJar(Class<?> my_class, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = TableMapReduceUtil.findContainingJar(my_class, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = TableMapReduceUtil.getJar(my_class);
            TableMapReduceUtil.updateMap(jar, packagedClasses);
        }
        if (null == jar || jar.isEmpty()) {
            return null;
        }
        LOG.debug(String.format("For class %s, using jar %s", my_class.getName(), jar));
        return new Path(jar).makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (null == jar || jar.isEmpty()) {
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(jar);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
        finally {
            if (null != zip) {
                zip.close();
            }
        }
    }

    private static String findContainingJar(Class<?> my_class, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        if (loader != null) {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> my_class) {
        String ret = null;
        try {
            ret = JarFinder.getJar(my_class);
        }
        catch (Exception e) {
            throw new RuntimeException("getJar invocation failed.", e);
        }
        return ret;
    }

    /*
     * Exception decompiling
     */
    private static int getRegionCount(Configuration conf, TableName tableName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

