/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hadoop.hbase.mob.MobTestUtil;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MapReduceTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.LauncherSecurityManager;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MapReduceTests.class, LargeTests.class})
public class TestCopyTable {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestCopyTable.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] ROW1 = Bytes.toBytes((String)"row1");
    private static final byte[] ROW2 = Bytes.toBytes((String)"row2");
    private static final String FAMILY_A_STRING = "a";
    private static final String FAMILY_B_STRING = "b";
    private static final byte[] FAMILY_A = Bytes.toBytes((String)"a");
    private static final byte[] FAMILY_B = Bytes.toBytes((String)"b");
    private static final byte[] QUALIFIER = Bytes.toBytes((String)"q");
    @Rule
    public TestName name = new TestName();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(3);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyTableTest(boolean bulkload) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        try (Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
             Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);){
            this.loadData(t1, FAMILY, COLUMN1);
            CopyTable copy = new CopyTable();
            int code = bulkload ? ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", tableName1.getNameAsString()}) : ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), tableName1.getNameAsString()});
            Assert.assertEquals((String)"copy job failed", (long)0L, (long)code);
            this.verifyRows(t2, FAMILY, COLUMN1);
        }
        finally {
            TEST_UTIL.deleteTable(tableName1);
            TEST_UTIL.deleteTable(tableName2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopyTableTestWithMob(boolean bulkload) throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"mob");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        ColumnFamilyDescriptorBuilder cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])FAMILY);
        cfd.setMobEnabled(true);
        cfd.setMobThreshold(5L);
        TableDescriptor desc1 = TableDescriptorBuilder.newBuilder((TableName)tableName1).setColumnFamily(cfd.build()).build();
        TableDescriptor desc2 = TableDescriptorBuilder.newBuilder((TableName)tableName2).setColumnFamily(cfd.build()).build();
        try (Table t1 = TEST_UTIL.createTable(desc1, (byte[][])null);
             Table t2 = TEST_UTIL.createTable(desc2, (byte[][])null);){
            for (int i = 0; i < 10; ++i) {
                Put p = new Put(Bytes.toBytes((String)("row" + i)));
                p.addColumn(FAMILY, COLUMN1, COLUMN1);
                t1.put(p);
            }
            CopyTable copy = new CopyTable();
            int code = bulkload ? ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), "--bulkload", tableName1.getNameAsString()}) : ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2.getNameAsString(), tableName1.getNameAsString()});
            Assert.assertEquals((String)"copy job failed", (long)0L, (long)code);
            for (int i = 0; i < 10; ++i) {
                Get g = new Get(Bytes.toBytes((String)("row" + i)));
                Result r = t2.get(g);
                Assert.assertEquals((long)1L, (long)r.size());
                Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
                Assert.assertEquals((String)"compare row values between two tables", (Object)t1.getDescriptor().getValue("row" + i), (Object)t2.getDescriptor().getValue("row" + i));
            }
            Assert.assertEquals((String)"compare count of mob rows after table copy", (long)MobTestUtil.countMobRows((HBaseTestingUtility)TEST_UTIL, (Table)t1), (long)MobTestUtil.countMobRows((HBaseTestingUtility)TEST_UTIL, (Table)t2));
            Assert.assertEquals((String)"compare count of mob row values between two tables", (long)t1.getDescriptor().getValues().size(), (long)t2.getDescriptor().getValues().size());
            Assert.assertTrue((String)"The mob row count is 0 but should be > 0", (MobTestUtil.countMobRows((HBaseTestingUtility)TEST_UTIL, (Table)t2) > 0 ? 1 : 0) != 0);
        }
        finally {
            TEST_UTIL.deleteTable(tableName1);
            TEST_UTIL.deleteTable(tableName2);
        }
    }

    @Test
    public void testCopyTable() throws Exception {
        this.doCopyTableTest(false);
    }

    @Test
    public void testCopyTableWithBulkload() throws Exception {
        this.doCopyTableTest(true);
    }

    @Test
    public void testCopyTableWithMob() throws Exception {
        this.doCopyTableTestWithMob(false);
    }

    @Test
    public void testCopyTableWithBulkloadWithMob() throws Exception {
        this.doCopyTableTestWithMob(true);
    }

    @Test
    public void testStartStopRow() throws Exception {
        TableName tableName1 = TableName.valueOf((String)(this.name.getMethodName() + "1"));
        TableName tableName2 = TableName.valueOf((String)(this.name.getMethodName() + "2"));
        byte[] FAMILY = Bytes.toBytes((String)"family");
        byte[] COLUMN1 = Bytes.toBytes((String)"c1");
        byte[] ROW0 = Bytes.toBytesBinary((String)"\\x01row0");
        byte[] ROW1 = Bytes.toBytesBinary((String)"\\x01row1");
        byte[] ROW2 = Bytes.toBytesBinary((String)"\\x01row2");
        Table t1 = TEST_UTIL.createTable(tableName1, FAMILY);
        Table t2 = TEST_UTIL.createTable(tableName2, FAMILY);
        Put p = new Put(ROW0);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW1);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        p = new Put(ROW2);
        p.addColumn(FAMILY, COLUMN1, COLUMN1);
        t1.put(p);
        CopyTable copy = new CopyTable();
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)copy, (String[])new String[]{"--new.name=" + tableName2, "--startrow=\\x01row1", "--stoprow=\\x01row2", tableName1.getNameAsString()}));
        Get g = new Get(ROW1);
        Result r = t2.get(g);
        Assert.assertEquals((long)1L, (long)r.size());
        Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)r.rawCells()[0], (byte[])COLUMN1));
        g = new Get(ROW0);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        g = new Get(ROW2);
        r = t2.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t1.close();
        t2.close();
        TEST_UTIL.deleteTable(tableName1);
        TEST_UTIL.deleteTable(tableName2);
    }

    @Test
    public void testRenameFamily() throws Exception {
        TableName sourceTable = TableName.valueOf((String)(this.name.getMethodName() + "source"));
        TableName targetTable = TableName.valueOf((String)(this.name.getMethodName() + "-target"));
        byte[][] families = new byte[][]{FAMILY_A, FAMILY_B};
        Table t = TEST_UTIL.createTable(sourceTable, (byte[][])families);
        Table t2 = TEST_UTIL.createTable(targetTable, (byte[][])families);
        Put p = new Put(ROW1);
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data11"));
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data12"));
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data13"));
        t.put(p);
        p = new Put(ROW2);
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Dat21"));
        p.addColumn(FAMILY_A, QUALIFIER, Bytes.toBytes((String)"Data22"));
        p.addColumn(FAMILY_B, QUALIFIER, Bytes.toBytes((String)"Data23"));
        t.put(p);
        long currentTime = EnvironmentEdgeManager.currentTime();
        String[] args = new String[]{"--new.name=" + targetTable, "--families=a:b", "--all.cells", "--starttime=" + (currentTime - 100000L), "--endtime=" + (currentTime + 100000L), "--versions=1", sourceTable.getNameAsString()};
        Assert.assertNull((Object)t2.get(new Get(ROW1)).getRow());
        Assert.assertTrue((boolean)this.runCopy(args));
        Assert.assertNotNull((Object)t2.get(new Get(ROW1)).getRow());
        Result res = t2.get(new Get(ROW1));
        byte[] b1 = res.getValue(FAMILY_B, QUALIFIER);
        Assert.assertEquals((Object)"Data13", (Object)new String(b1));
        Assert.assertNotNull((Object)t2.get(new Get(ROW2)).getRow());
        res = t2.get(new Get(ROW2));
        b1 = res.getValue(FAMILY_A, QUALIFIER);
        Assert.assertNull((Object)b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMainMethod() throws Exception {
        String[] emptyArgs = new String[]{"-h"};
        PrintStream oldWriter = System.err;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(data);
        System.setErr(writer);
        SecurityManager SECURITY_MANAGER = System.getSecurityManager();
        LauncherSecurityManager newSecurityManager = new LauncherSecurityManager();
        System.setSecurityManager((SecurityManager)newSecurityManager);
        try {
            CopyTable.main((String[])emptyArgs);
            Assert.fail((String)"should be exit");
        }
        catch (SecurityException e) {
            Assert.assertEquals((long)1L, (long)newSecurityManager.getExitCode());
        }
        finally {
            System.setErr(oldWriter);
            System.setSecurityManager(SECURITY_MANAGER);
        }
        Assert.assertTrue((boolean)data.toString().contains("rs.class"));
        Assert.assertTrue((boolean)data.toString().contains("Usage:"));
    }

    private boolean runCopy(String[] args) throws Exception {
        int status = ToolRunner.run((Configuration)new Configuration(TEST_UTIL.getConfiguration()), (Tool)new CopyTable(), (String[])args);
        return status == 0;
    }

    private void loadData(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Put p = new Put(row);
            p.addColumn(family, column, row);
            t.put(p);
        }
    }

    private void verifyRows(Table t, byte[] family, byte[] column) throws IOException {
        for (int i = 0; i < 10; ++i) {
            byte[] row = Bytes.toBytes((String)("row" + i));
            Get g = new Get(row).addFamily(family);
            Result r = t.get(g);
            Assert.assertNotNull((Object)r);
            Assert.assertEquals((long)1L, (long)r.size());
            Cell cell = r.rawCells()[0];
            Assert.assertTrue((boolean)CellUtil.matchingQualifier((Cell)cell, (byte[])column));
            Assert.assertEquals((long)Bytes.compareTo((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)cell.getValueLength(), (byte[])row, (int)0, (int)row.length), (long)0L);
        }
    }

    private Table createTable(TableName tableName, byte[] family, boolean isMob) throws IOException {
        if (isMob) {
            ColumnFamilyDescriptor cfd = ColumnFamilyDescriptorBuilder.newBuilder((byte[])family).setMobEnabled(true).setMobThreshold(1L).build();
            TableDescriptor desc = TableDescriptorBuilder.newBuilder((TableName)tableName).setColumnFamily(cfd).build();
            return TEST_UTIL.createTable(desc, (byte[][])null);
        }
        return TEST_UTIL.createTable(tableName, family);
    }

    private void testCopyTableBySnapshot(String tablePrefix, boolean bulkLoad, boolean isMob) throws Exception {
        TableName table1 = TableName.valueOf((String)(tablePrefix + 1));
        TableName table2 = TableName.valueOf((String)(tablePrefix + 2));
        Table t1 = this.createTable(table1, FAMILY_A, isMob);
        Table t2 = this.createTable(table2, FAMILY_A, isMob);
        this.loadData(t1, FAMILY_A, Bytes.toBytes((String)"qualifier"));
        String snapshot = tablePrefix + "_snapshot";
        TEST_UTIL.getAdmin().snapshot(snapshot, table1);
        boolean success = bulkLoad ? this.runCopy(new String[]{"--snapshot", "--new.name=" + table2, "--bulkload", snapshot}) : this.runCopy(new String[]{"--snapshot", "--new.name=" + table2, snapshot});
        Assert.assertTrue((boolean)success);
        this.verifyRows(t2, FAMILY_A, Bytes.toBytes((String)"qualifier"));
    }

    @Test
    public void testLoadingSnapshotToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotToTable", false, false);
    }

    @Test
    public void tsetLoadingSnapshotToMobTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotToMobTable", false, true);
    }

    @Test
    public void testLoadingSnapshotAndBulkLoadToTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotAndBulkLoadToTable", true, false);
    }

    @Test
    public void testLoadingSnapshotAndBulkLoadToMobTable() throws Exception {
        this.testCopyTableBySnapshot("testLoadingSnapshotAndBulkLoadToMobTable", true, true);
    }

    @Test
    public void testLoadingSnapshotToRemoteCluster() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "--peerAdr=hbase://remoteHBase", "sourceSnapshotName"}));
    }

    @Test
    public void testLoadingSnapshotWithoutSnapshotName() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "--peerAdr=hbase://remoteHBase"}));
    }

    @Test
    public void testLoadingSnapshotWithoutDestTable() throws Exception {
        Assert.assertFalse((boolean)this.runCopy(new String[]{"--snapshot", "sourceSnapshotName"}));
    }
}

