/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hadoop.hbase.metrics.impl.CounterImpl;
import org.apache.hadoop.hbase.metrics.impl.FastLongHistogram;

@InterfaceAudience.Private
public class HistogramImpl
implements Histogram {
    protected final FastLongHistogram histogram;
    private final CounterImpl counter;

    public HistogramImpl() {
        this(-4L);
    }

    public HistogramImpl(long maxExpected) {
        this(255, 1L, maxExpected);
    }

    public HistogramImpl(int numBins, long min, long maxExpected) {
        this.counter = new CounterImpl();
        this.histogram = new FastLongHistogram(numBins, min, maxExpected);
    }

    protected HistogramImpl(CounterImpl counter, FastLongHistogram histogram) {
        this.counter = counter;
        this.histogram = histogram;
    }

    public void update(int value) {
        this.counter.increment();
        this.histogram.add(value, 1L);
    }

    public void update(long value) {
        this.counter.increment();
        this.histogram.add(value, 1L);
    }

    public long getCount() {
        return this.counter.getCount();
    }

    public long getMax() {
        return this.histogram.getMax();
    }

    public Snapshot snapshot() {
        return this.histogram.snapshotAndReset();
    }
}

