/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.hbase.metrics.impl.DropwizardMeter;
import org.apache.hadoop.hbase.metrics.impl.HistogramImpl;

@InterfaceAudience.Private
public class TimerImpl
implements Timer {
    private final HistogramImpl histogram = new HistogramImpl();
    private final DropwizardMeter meter = new DropwizardMeter();
    private static final TimeUnit DEFAULT_UNIT = TimeUnit.MICROSECONDS;

    public void update(long duration, TimeUnit unit) {
        if (duration >= 0L) {
            this.histogram.update(DEFAULT_UNIT.convert(duration, unit));
            this.meter.mark();
        }
    }

    public HistogramImpl getHistogram() {
        return this.histogram;
    }

    public DropwizardMeter getMeter() {
        return this.meter;
    }

    public void updateMillis(long durationMillis) {
        this.update(durationMillis, TimeUnit.NANOSECONDS);
    }

    public void updateMicros(long durationMicros) {
        this.update(durationMicros, TimeUnit.MICROSECONDS);
    }

    public void updateNanos(long durationNanos) {
        this.update(durationNanos, TimeUnit.NANOSECONDS);
    }
}

