/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode.row;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.hadoop.hbase.util.vint.UVIntTool;

@InterfaceAudience.Private
public class RowNodeReader {
    protected byte[] block;
    protected int offset;
    protected int fanIndex;
    protected int numCells;
    protected int tokenOffset;
    protected int tokenLength;
    protected int fanOffset;
    protected int fanOut;
    protected int familyOffsetsOffset;
    protected int qualifierOffsetsOffset;
    protected int timestampIndexesOffset;
    protected int mvccVersionIndexesOffset;
    protected int operationTypesOffset;
    protected int valueOffsetsOffset;
    protected int valueLengthsOffset;
    protected int nextNodeOffsetsOffset;

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block, int offset) {
        this.block = block;
        this.offset = offset;
        this.resetFanIndex();
        this.tokenLength = UVIntTool.getInt(block, offset);
        this.tokenOffset = offset + UVIntTool.numBytes(this.tokenLength);
        this.fanOut = UVIntTool.getInt(block, this.tokenOffset + this.tokenLength);
        this.fanOffset = this.tokenOffset + this.tokenLength + UVIntTool.numBytes(this.fanOut);
        this.numCells = UVIntTool.getInt(block, this.fanOffset + this.fanOut);
        this.familyOffsetsOffset = this.fanOffset + this.fanOut + UVIntTool.numBytes(this.numCells);
        this.qualifierOffsetsOffset = this.familyOffsetsOffset + this.numCells * blockMeta.getFamilyOffsetWidth();
        this.timestampIndexesOffset = this.qualifierOffsetsOffset + this.numCells * blockMeta.getQualifierOffsetWidth();
        this.mvccVersionIndexesOffset = this.timestampIndexesOffset + this.numCells * blockMeta.getTimestampIndexWidth();
        this.operationTypesOffset = this.mvccVersionIndexesOffset + this.numCells * blockMeta.getMvccVersionIndexWidth();
        this.valueOffsetsOffset = this.operationTypesOffset + this.numCells * blockMeta.getKeyValueTypeWidth();
        this.valueLengthsOffset = this.valueOffsetsOffset + this.numCells * blockMeta.getValueOffsetWidth();
        this.nextNodeOffsetsOffset = this.valueLengthsOffset + this.numCells * blockMeta.getValueLengthWidth();
    }

    public boolean isLeaf() {
        return this.fanOut == 0;
    }

    public boolean isNub() {
        return this.fanOut > 0 && this.numCells > 0;
    }

    public boolean isBranch() {
        return this.fanOut > 0 && this.numCells == 0;
    }

    public boolean hasOccurrences() {
        return this.numCells > 0;
    }

    public int getTokenArrayOffset() {
        return this.tokenOffset;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public byte getFanByte(int i) {
        return this.block[this.fanOffset + i];
    }

    protected String getFanByteReadable(int i) {
        return Bytes.toStringBinary((byte[])this.block, (int)(this.fanOffset + i), (int)1);
    }

    public int getFamilyOffset(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getFamilyOffsetWidth();
        int startIndex = this.familyOffsetsOffset + fIntWidth * index;
        return (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
    }

    public int getColumnOffset(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getQualifierOffsetWidth();
        int startIndex = this.qualifierOffsetsOffset + fIntWidth * index;
        return (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
    }

    public int getTimestampIndex(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getTimestampIndexWidth();
        int startIndex = this.timestampIndexesOffset + fIntWidth * index;
        return (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
    }

    public int getMvccVersionIndex(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getMvccVersionIndexWidth();
        int startIndex = this.mvccVersionIndexesOffset + fIntWidth * index;
        return (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
    }

    public int getType(int index, PrefixTreeBlockMeta blockMeta) {
        if (blockMeta.isAllSameType()) {
            return blockMeta.getAllTypes();
        }
        return this.block[this.operationTypesOffset + index];
    }

    public int getValueOffset(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getValueOffsetWidth();
        int startIndex = this.valueOffsetsOffset + fIntWidth * index;
        int offset = (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
        return offset;
    }

    public int getValueLength(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getValueLengthWidth();
        int startIndex = this.valueLengthsOffset + fIntWidth * index;
        int length = (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
        return length;
    }

    public int getNextNodeOffset(int index, PrefixTreeBlockMeta blockMeta) {
        int fIntWidth = blockMeta.getNextNodeOffsetWidth();
        int startIndex = this.nextNodeOffsetsOffset + fIntWidth * index;
        return (int)UFIntTool.fromBytes(this.block, startIndex, fIntWidth);
    }

    public String getBranchNubLeafIndicator() {
        if (this.isNub()) {
            return "N";
        }
        return this.isBranch() ? "B" : "L";
    }

    public boolean hasChildren() {
        return this.fanOut > 0;
    }

    public int getLastFanIndex() {
        return this.fanOut - 1;
    }

    public int getLastCellIndex() {
        return this.numCells - 1;
    }

    public int getNumCells() {
        return this.numCells;
    }

    public int getFanOut() {
        return this.fanOut;
    }

    public byte[] getToken() {
        return new ByteRange(this.block, this.tokenOffset, this.tokenLength).deepCopyToNewArray();
    }

    public int getOffset() {
        return this.offset;
    }

    public int whichFanNode(byte searchForByte) {
        if (!this.hasFan()) {
            throw new IllegalStateException("This row node has no fan, so can't search it");
        }
        int fanIndexInBlock = Bytes.unsignedBinarySearch((byte[])this.block, (int)this.fanOffset, (int)(this.fanOffset + this.fanOut), (byte)searchForByte);
        if (fanIndexInBlock >= 0) {
            return fanIndexInBlock - this.fanOffset;
        }
        return fanIndexInBlock + this.fanOffset + 1;
    }

    public void resetFanIndex() {
        this.fanIndex = -1;
    }

    public int getFanIndex() {
        return this.fanIndex;
    }

    public void setFanIndex(int fanIndex) {
        this.fanIndex = fanIndex;
    }

    public boolean hasFan() {
        return this.fanOut > 0;
    }

    public boolean hasPreviousFanNodes() {
        return this.fanOut > 0 && this.fanIndex > 0;
    }

    public boolean hasMoreFanNodes() {
        return this.fanIndex < this.getLastFanIndex();
    }

    public boolean isOnLastFanNode() {
        return !this.hasMoreFanNodes();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("fan:" + Bytes.toStringBinary((byte[])this.block, (int)this.fanOffset, (int)this.fanOut));
        sb.append(",token:" + Bytes.toStringBinary((byte[])this.block, (int)this.tokenOffset, (int)this.tokenLength));
        sb.append(",numCells:" + this.numCells);
        sb.append(",fanIndex:" + this.fanIndex);
        if (this.fanIndex >= 0) {
            sb.append("(" + this.getFanByteReadable(this.fanIndex) + ")");
        }
        return sb.toString();
    }
}

