/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.decode.DecoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArraySearcher;

@InterfaceAudience.Private
public class ArraySearcherPool {
    private static final Integer MAX_POOL_SIZE = 1000;
    protected Queue<PrefixTreeArraySearcher> pool = new LinkedBlockingQueue<PrefixTreeArraySearcher>(MAX_POOL_SIZE);

    public PrefixTreeArraySearcher checkOut(ByteBuffer buffer, boolean includesMvccVersion) {
        PrefixTreeArraySearcher searcher = this.pool.poll();
        searcher = DecoderFactory.ensureArraySearcherValid(buffer, searcher, includesMvccVersion);
        return searcher;
    }

    public void checkIn(PrefixTreeArraySearcher searcher) {
        searcher.releaseBlockReference();
        this.pool.offer(searcher);
    }

    public String toString() {
        return "poolSize:" + this.pool.size();
    }
}

