/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode.column;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.column.ColumnNodeReader;

@InterfaceAudience.Private
public class ColumnReader {
    protected PrefixTreeBlockMeta blockMeta;
    protected byte[] columnBuffer;
    protected int columnOffset;
    protected int columnLength;
    protected boolean familyVsQualifier;
    protected ColumnNodeReader columnNodeReader;

    public ColumnReader(byte[] columnBuffer, boolean familyVsQualifier) {
        this.columnBuffer = columnBuffer;
        this.familyVsQualifier = familyVsQualifier;
        this.columnNodeReader = new ColumnNodeReader(columnBuffer, familyVsQualifier);
    }

    public void initOnBlock(PrefixTreeBlockMeta blockMeta, byte[] block) {
        this.blockMeta = blockMeta;
        this.clearColumnBuffer();
        this.columnNodeReader.initOnBlock(blockMeta, block);
    }

    public ColumnReader populateBuffer(int offsetIntoColumnData) {
        this.clearColumnBuffer();
        int nextRelativeOffset = offsetIntoColumnData;
        while (true) {
            int absoluteOffset = this.familyVsQualifier ? this.blockMeta.getAbsoluteFamilyOffset() + nextRelativeOffset : this.blockMeta.getAbsoluteQualifierOffset() + nextRelativeOffset;
            this.columnNodeReader.positionAt(absoluteOffset);
            this.columnOffset -= this.columnNodeReader.getTokenLength();
            this.columnLength += this.columnNodeReader.getTokenLength();
            this.columnNodeReader.prependTokenToBuffer(this.columnOffset);
            if (this.columnNodeReader.isRoot()) {
                return this;
            }
            nextRelativeOffset = this.columnNodeReader.getParentStartPosition();
        }
    }

    public byte[] copyBufferToNewArray() {
        byte[] out = new byte[this.columnLength];
        System.arraycopy(this.columnBuffer, this.columnOffset, out, 0, out.length);
        return out;
    }

    public int getColumnLength() {
        return this.columnLength;
    }

    public void clearColumnBuffer() {
        this.columnOffset = this.columnBuffer.length;
        this.columnLength = 0;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }
}

