/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode;

import java.io.OutputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderFactory;
import org.apache.hadoop.hbase.codec.prefixtree.encode.EncoderPool;
import org.apache.hadoop.hbase.codec.prefixtree.encode.PrefixTreeEncoder;

@InterfaceAudience.Private
public class ThreadLocalEncoderPool
implements EncoderPool {
    private static final ThreadLocal<PrefixTreeEncoder> ENCODER = new ThreadLocal();

    @Override
    public PrefixTreeEncoder checkOut(OutputStream os, boolean includeMvccVersion) {
        PrefixTreeEncoder builder = ENCODER.get();
        builder = EncoderFactory.prepareEncoder(builder, os, includeMvccVersion);
        ENCODER.set(builder);
        return builder;
    }

    @Override
    public void checkIn(PrefixTreeEncoder encoder) {
    }
}

