/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.encode.column.ColumnSectionWriter;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.CellTypeEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.ColumnNodeType;
import org.apache.hadoop.hbase.codec.prefixtree.encode.other.LongEncoder;
import org.apache.hadoop.hbase.codec.prefixtree.encode.row.RowSectionWriter;
import org.apache.hadoop.hbase.codec.prefixtree.encode.tokenize.Tokenizer;
import org.apache.hadoop.hbase.io.CellOutputStream;
import org.apache.hadoop.hbase.util.ArrayUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.hadoop.hbase.util.byterange.ByteRangeSet;
import org.apache.hadoop.hbase.util.byterange.impl.ByteRangeHashSet;
import org.apache.hadoop.hbase.util.vint.UFIntTool;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class PrefixTreeEncoder
implements CellOutputStream {
    protected static final Log LOG = LogFactory.getLog(PrefixTreeEncoder.class);
    public static final boolean MULITPLE_FAMILIES_POSSIBLE = false;
    private static final boolean USE_HASH_COLUMN_SORTER = true;
    private static final int INITIAL_PER_CELL_ARRAY_SIZES = 256;
    private static final int VALUE_BUFFER_INIT_SIZE = 65536;
    protected long numResets = 0L;
    protected OutputStream outputStream;
    protected boolean includeMvccVersion;
    protected ByteRange rowRange;
    protected ByteRange familyRange;
    protected ByteRange qualifierRange;
    protected ByteRange tagsRange;
    protected long[] timestamps;
    protected long[] mvccVersions;
    protected byte[] typeBytes;
    protected int[] valueOffsets;
    protected int[] tagsOffsets;
    protected byte[] values;
    protected byte[] tags;
    protected PrefixTreeBlockMeta blockMeta = new PrefixTreeBlockMeta();
    protected LongEncoder timestampEncoder;
    protected LongEncoder mvccVersionEncoder;
    protected CellTypeEncoder cellTypeEncoder;
    protected ByteRangeSet familyDeduplicator;
    protected ByteRangeSet qualifierDeduplicator;
    protected ByteRangeSet tagsDeduplicator;
    protected Tokenizer rowTokenizer;
    protected Tokenizer familyTokenizer;
    protected Tokenizer qualifierTokenizer;
    protected Tokenizer tagsTokenizer;
    protected RowSectionWriter rowWriter;
    protected ColumnSectionWriter familyWriter;
    protected ColumnSectionWriter qualifierWriter;
    protected ColumnSectionWriter tagsWriter;
    protected int totalCells = 0;
    protected int totalUnencodedBytes = 0;
    protected int totalValueBytes = 0;
    protected int totalTagBytes = 0;
    protected int maxValueLength = 0;
    protected int maxTagLength = 0;
    protected int totalBytes = 0;

    public PrefixTreeEncoder(OutputStream outputStream, boolean includeMvccVersion) {
        this.rowRange = new SimpleMutableByteRange();
        this.familyRange = new SimpleMutableByteRange();
        this.qualifierRange = new SimpleMutableByteRange();
        this.timestamps = new long[256];
        this.mvccVersions = new long[256];
        this.typeBytes = new byte[256];
        this.valueOffsets = new int[256];
        this.values = new byte[65536];
        this.familyDeduplicator = new ByteRangeHashSet();
        this.qualifierDeduplicator = new ByteRangeHashSet();
        this.timestampEncoder = new LongEncoder();
        this.mvccVersionEncoder = new LongEncoder();
        this.cellTypeEncoder = new CellTypeEncoder();
        this.rowTokenizer = new Tokenizer();
        this.familyTokenizer = new Tokenizer();
        this.qualifierTokenizer = new Tokenizer();
        this.rowWriter = new RowSectionWriter();
        this.familyWriter = new ColumnSectionWriter();
        this.qualifierWriter = new ColumnSectionWriter();
        this.initializeTagHelpers();
        this.reset(outputStream, includeMvccVersion);
    }

    public void reset(OutputStream outputStream, boolean includeMvccVersion) {
        ++this.numResets;
        this.includeMvccVersion = includeMvccVersion;
        this.outputStream = outputStream;
        this.valueOffsets[0] = 0;
        this.familyDeduplicator.reset();
        this.qualifierDeduplicator.reset();
        this.tagsDeduplicator.reset();
        this.tagsWriter.reset();
        this.tagsTokenizer.reset();
        this.rowTokenizer.reset();
        this.timestampEncoder.reset();
        this.mvccVersionEncoder.reset();
        this.cellTypeEncoder.reset();
        this.familyTokenizer.reset();
        this.qualifierTokenizer.reset();
        this.rowWriter.reset();
        this.familyWriter.reset();
        this.qualifierWriter.reset();
        this.totalCells = 0;
        this.totalUnencodedBytes = 0;
        this.totalValueBytes = 0;
        this.maxValueLength = 0;
        this.totalBytes = 0;
    }

    protected void initializeTagHelpers() {
        this.tagsRange = new SimpleMutableByteRange();
        this.tagsDeduplicator = new ByteRangeHashSet();
        this.tagsTokenizer = new Tokenizer();
        this.tagsWriter = new ColumnSectionWriter();
    }

    protected void ensurePerCellCapacities() {
        int neededCapacity = this.totalCells + 2;
        int currentCapacity = this.valueOffsets.length;
        if (neededCapacity < currentCapacity) {
            return;
        }
        int padding = neededCapacity;
        this.timestamps = ArrayUtils.growIfNecessary((long[])this.timestamps, (int)neededCapacity, (int)padding);
        this.mvccVersions = ArrayUtils.growIfNecessary((long[])this.mvccVersions, (int)neededCapacity, (int)padding);
        this.typeBytes = ArrayUtils.growIfNecessary((byte[])this.typeBytes, (int)neededCapacity, (int)padding);
        this.valueOffsets = ArrayUtils.growIfNecessary((int[])this.valueOffsets, (int)neededCapacity, (int)padding);
    }

    public void writeWithRepeatRow(Cell cell) {
        this.ensurePerCellCapacities();
        this.rowTokenizer.incrementNumOccurrencesOfLatestValue();
        this.addFamilyPart(cell);
        this.addQualifierPart(cell);
        this.addAfterRowFamilyQualifier(cell);
    }

    public void write(Cell cell) {
        this.ensurePerCellCapacities();
        this.rowTokenizer.addSorted(CellUtil.fillRowRange((Cell)cell, (ByteRange)this.rowRange));
        this.addFamilyPart(cell);
        this.addQualifierPart(cell);
        this.addTagPart(cell);
        this.addAfterRowFamilyQualifier(cell);
    }

    private void addTagPart(Cell cell) {
        CellUtil.fillTagRange((Cell)cell, (ByteRange)this.tagsRange);
        this.tagsDeduplicator.add(this.tagsRange);
    }

    private void addAfterRowFamilyQualifier(Cell cell) {
        this.timestamps[this.totalCells] = cell.getTimestamp();
        this.timestampEncoder.add(cell.getTimestamp());
        if (this.includeMvccVersion) {
            this.mvccVersions[this.totalCells] = cell.getMvccVersion();
            this.mvccVersionEncoder.add(cell.getMvccVersion());
            this.totalUnencodedBytes += WritableUtils.getVIntSize((long)cell.getMvccVersion());
        } else {
            this.mvccVersions[this.totalCells] = 0L;
            if (this.totalCells == 0) {
                this.mvccVersionEncoder.add(0L);
            }
        }
        this.typeBytes[this.totalCells] = cell.getTypeByte();
        this.cellTypeEncoder.add(cell.getTypeByte());
        this.totalValueBytes += cell.getValueLength();
        this.values = ArrayUtils.growIfNecessary((byte[])this.values, (int)this.totalValueBytes, (int)(2 * this.totalValueBytes));
        CellUtil.copyValueTo((Cell)cell, (byte[])this.values, (int)this.valueOffsets[this.totalCells]);
        if (cell.getValueLength() > this.maxValueLength) {
            this.maxValueLength = cell.getValueLength();
        }
        this.valueOffsets[this.totalCells + 1] = this.totalValueBytes;
        this.totalUnencodedBytes += KeyValueUtil.length((Cell)cell);
        ++this.totalCells;
    }

    private void addFamilyPart(Cell cell) {
        if (this.totalCells == 0) {
            CellUtil.fillFamilyRange((Cell)cell, (ByteRange)this.familyRange);
            this.familyDeduplicator.add(this.familyRange);
        }
    }

    private void addQualifierPart(Cell cell) {
        CellUtil.fillQualifierRange((Cell)cell, (ByteRange)this.qualifierRange);
        this.qualifierDeduplicator.add(this.qualifierRange);
    }

    public void flush() throws IOException {
        this.compile();
        this.blockMeta.writeVariableBytesToOutputStream(this.outputStream);
        this.rowWriter.writeBytes(this.outputStream);
        this.familyWriter.writeBytes(this.outputStream);
        this.qualifierWriter.writeBytes(this.outputStream);
        this.tagsWriter.writeBytes(this.outputStream);
        this.timestampEncoder.writeBytes(this.outputStream);
        this.mvccVersionEncoder.writeBytes(this.outputStream);
        this.outputStream.write(this.values, 0, this.totalValueBytes);
    }

    protected void compile() {
        this.blockMeta.setNumKeyValueBytes(this.totalUnencodedBytes);
        int lastValueOffset = this.valueOffsets[this.totalCells];
        this.blockMeta.setValueOffsetWidth(UFIntTool.numBytes(lastValueOffset));
        this.blockMeta.setValueLengthWidth(UFIntTool.numBytes(this.maxValueLength));
        this.blockMeta.setNumValueBytes(this.totalValueBytes);
        this.totalBytes += this.totalTagBytes + this.totalValueBytes;
        this.compileTypes();
        this.compileMvccVersions();
        this.compileTimestamps();
        this.compileTags();
        this.compileQualifiers();
        this.compileFamilies();
        this.compileRows();
        int numMetaBytes = this.blockMeta.calculateNumMetaBytes();
        this.blockMeta.setNumMetaBytes(numMetaBytes);
        this.totalBytes += numMetaBytes;
    }

    protected void compileTypes() {
        this.blockMeta.setAllSameType(this.cellTypeEncoder.areAllSameType());
        if (this.cellTypeEncoder.areAllSameType()) {
            this.blockMeta.setAllTypes(this.cellTypeEncoder.getOnlyType());
        }
    }

    protected void compileMvccVersions() {
        this.mvccVersionEncoder.compile();
        this.blockMeta.setMvccVersionFields(this.mvccVersionEncoder);
        int numMvccVersionBytes = this.mvccVersionEncoder.getOutputArrayLength();
        this.totalBytes += numMvccVersionBytes;
    }

    protected void compileTimestamps() {
        this.timestampEncoder.compile();
        this.blockMeta.setTimestampFields(this.timestampEncoder);
        int numTimestampBytes = this.timestampEncoder.getOutputArrayLength();
        this.totalBytes += numTimestampBytes;
    }

    protected void compileQualifiers() {
        this.blockMeta.setNumUniqueQualifiers(this.qualifierDeduplicator.size());
        this.qualifierDeduplicator.compile();
        this.qualifierTokenizer.addAll(this.qualifierDeduplicator.getSortedRanges());
        this.qualifierWriter.reconstruct(this.blockMeta, this.qualifierTokenizer, ColumnNodeType.QUALIFIER);
        this.qualifierWriter.compile();
        int numQualifierBytes = this.qualifierWriter.getNumBytes();
        this.blockMeta.setNumQualifierBytes(numQualifierBytes);
        this.totalBytes += numQualifierBytes;
    }

    protected void compileFamilies() {
        this.blockMeta.setNumUniqueFamilies(this.familyDeduplicator.size());
        this.familyDeduplicator.compile();
        this.familyTokenizer.addAll(this.familyDeduplicator.getSortedRanges());
        this.familyWriter.reconstruct(this.blockMeta, this.familyTokenizer, ColumnNodeType.FAMILY);
        this.familyWriter.compile();
        int numFamilyBytes = this.familyWriter.getNumBytes();
        this.blockMeta.setNumFamilyBytes(numFamilyBytes);
        this.totalBytes += numFamilyBytes;
    }

    protected void compileTags() {
        this.blockMeta.setNumUniqueTags(this.tagsDeduplicator.size());
        this.tagsDeduplicator.compile();
        this.tagsTokenizer.addAll(this.tagsDeduplicator.getSortedRanges());
        this.tagsWriter.reconstruct(this.blockMeta, this.tagsTokenizer, ColumnNodeType.TAGS);
        this.tagsWriter.compile();
        int numTagBytes = this.tagsWriter.getNumBytes();
        this.blockMeta.setNumTagsBytes(numTagBytes);
        this.totalBytes += numTagBytes;
    }

    protected void compileRows() {
        this.rowWriter.reconstruct(this);
        this.rowWriter.compile();
        int numRowBytes = this.rowWriter.getNumBytes();
        this.blockMeta.setNumRowBytes(numRowBytes);
        this.blockMeta.setRowTreeDepth(this.rowTokenizer.getTreeDepth());
        this.totalBytes += numRowBytes;
    }

    public long getValueOffset(int index) {
        return this.valueOffsets[index];
    }

    public int getValueLength(int index) {
        return this.valueOffsets[index + 1] - this.valueOffsets[index];
    }

    public PrefixTreeBlockMeta getBlockMeta() {
        return this.blockMeta;
    }

    public Tokenizer getRowTokenizer() {
        return this.rowTokenizer;
    }

    public LongEncoder getTimestampEncoder() {
        return this.timestampEncoder;
    }

    public int getTotalBytes() {
        return this.totalBytes;
    }

    public long[] getTimestamps() {
        return this.timestamps;
    }

    public long[] getMvccVersions() {
        return this.mvccVersions;
    }

    public byte[] getTypeBytes() {
        return this.typeBytes;
    }

    public LongEncoder getMvccVersionEncoder() {
        return this.mvccVersionEncoder;
    }

    public ByteRangeSet getFamilySorter() {
        return this.familyDeduplicator;
    }

    public ByteRangeSet getQualifierSorter() {
        return this.qualifierDeduplicator;
    }

    public ByteRangeSet getTagSorter() {
        return this.tagsDeduplicator;
    }

    public ColumnSectionWriter getFamilyWriter() {
        return this.familyWriter;
    }

    public ColumnSectionWriter getQualifierWriter() {
        return this.qualifierWriter;
    }

    public ColumnSectionWriter getTagWriter() {
        return this.tagsWriter;
    }

    public RowSectionWriter getRowWriter() {
        return this.rowWriter;
    }

    public ByteRange getValueByteRange() {
        return new SimpleMutableByteRange(this.values, 0, this.totalValueBytes);
    }
}

