/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util.byterange;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.ArrayUtils;
import org.apache.hadoop.hbase.util.ByteRange;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;

@InterfaceAudience.Private
public abstract class ByteRangeSet {
    protected byte[] byteAppender = new byte[0];
    protected int numBytes;
    protected Map<ByteRange, Integer> uniqueIndexByUniqueRange;
    protected ArrayList<ByteRange> uniqueRanges = Lists.newArrayList();
    protected int numUniqueRanges = 0;
    protected int[] uniqueRangeIndexByInsertionId = new int[0];
    protected int numInputs;
    protected List<Integer> sortedIndexByUniqueIndex = Lists.newArrayList();
    protected int[] sortedIndexByInsertionId = new int[0];
    protected ArrayList<ByteRange> sortedRanges = Lists.newArrayList();

    protected ByteRangeSet() {
    }

    public void reset() {
        this.numBytes = 0;
        this.uniqueIndexByUniqueRange.clear();
        this.numUniqueRanges = 0;
        this.numInputs = 0;
        this.sortedIndexByUniqueIndex.clear();
        this.sortedRanges.clear();
    }

    public abstract void addToSortedRanges();

    public void add(ByteRange bytes) {
        Integer index = this.uniqueIndexByUniqueRange.get(bytes);
        if (index == null) {
            index = this.store(bytes);
        }
        int minLength = this.numInputs + 1;
        this.uniqueRangeIndexByInsertionId = ArrayUtils.growIfNecessary((int[])this.uniqueRangeIndexByInsertionId, (int)minLength, (int)(2 * minLength));
        this.uniqueRangeIndexByInsertionId[this.numInputs] = index;
        ++this.numInputs;
    }

    protected int store(ByteRange bytes) {
        int indexOfNewElement = this.numUniqueRanges;
        if (this.uniqueRanges.size() <= this.numUniqueRanges) {
            this.uniqueRanges.add((ByteRange)new SimpleMutableByteRange());
        }
        ByteRange storedRange = this.uniqueRanges.get(this.numUniqueRanges);
        int neededBytes = this.numBytes + bytes.getLength();
        this.byteAppender = ArrayUtils.growIfNecessary((byte[])this.byteAppender, (int)neededBytes, (int)(2 * neededBytes));
        bytes.deepCopyTo(this.byteAppender, this.numBytes);
        storedRange.set(this.byteAppender, this.numBytes, bytes.getLength());
        this.numBytes += bytes.getLength();
        this.uniqueIndexByUniqueRange.put(storedRange, indexOfNewElement);
        int newestUniqueIndex = this.numUniqueRanges++;
        return newestUniqueIndex;
    }

    public ByteRangeSet compile() {
        int i;
        this.addToSortedRanges();
        for (i = 0; i < this.sortedRanges.size(); ++i) {
            this.sortedIndexByUniqueIndex.add(null);
        }
        for (i = 0; i < this.sortedIndexByUniqueIndex.size(); ++i) {
            int uniqueIndex = this.uniqueIndexByUniqueRange.get(this.sortedRanges.get(i));
            this.sortedIndexByUniqueIndex.set(uniqueIndex, i);
        }
        this.sortedIndexByInsertionId = ArrayUtils.growIfNecessary((int[])this.sortedIndexByInsertionId, (int)this.numInputs, (int)this.numInputs);
        for (i = 0; i < this.numInputs; ++i) {
            int sortedIndex;
            int uniqueRangeIndex = this.uniqueRangeIndexByInsertionId[i];
            this.sortedIndexByInsertionId[i] = sortedIndex = this.sortedIndexByUniqueIndex.get(uniqueRangeIndex).intValue();
        }
        return this;
    }

    public int getSortedIndexForInsertionId(int insertionId) {
        return this.sortedIndexByInsertionId[insertionId];
    }

    public int size() {
        return this.uniqueIndexByUniqueRange.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (ByteRange r : this.sortedRanges) {
            if (i > 0) {
                sb.append("\n");
            }
            sb.append(i + " " + Bytes.toStringBinary((byte[])r.deepCopyToNewArray()));
            ++i;
        }
        sb.append("\ntotalSize:" + this.numBytes);
        sb.append("\navgSize:" + this.getAvgSize());
        return sb.toString();
    }

    public ArrayList<ByteRange> getSortedRanges() {
        return this.sortedRanges;
    }

    public long getAvgSize() {
        return this.numBytes / this.numUniqueRanges;
    }
}

