/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.decode;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.codec.prefixtree.PrefixTreeBlockMeta;
import org.apache.hadoop.hbase.codec.prefixtree.decode.PrefixTreeArrayReversibleScanner;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellScannerPosition;
import org.apache.hadoop.hbase.codec.prefixtree.scanner.CellSearcher;
import org.apache.hadoop.hbase.shaded.com.google.common.primitives.UnsignedBytes;

@InterfaceAudience.Private
public class PrefixTreeArraySearcher
extends PrefixTreeArrayReversibleScanner
implements CellSearcher {
    public PrefixTreeArraySearcher(PrefixTreeBlockMeta blockMeta, int rowTreeDepth, int rowBufferLength, int qualifierBufferLength, int tagsBufferLength) {
        super(blockMeta, rowTreeDepth, rowBufferLength, qualifierBufferLength, tagsBufferLength);
    }

    @Override
    public boolean positionAt(Cell key) {
        return CellScannerPosition.AT == this.positionAtOrAfter(key);
    }

    @Override
    public CellScannerPosition positionAtOrBefore(Cell key) {
        this.reInitFirstNode();
        int fanIndex = -1;
        while (true) {
            int currentNodeDepth = this.rowLength;
            int rowTokenComparison = this.compareToCurrentToken(key);
            if (rowTokenComparison != 0) {
                return this.fixRowTokenMissReverse(rowTokenComparison);
            }
            if (this.rowMatchesAfterCurrentPosition(key)) {
                return this.positionAtQualifierTimestamp(key, true);
            }
            if (!this.currentRowNode.hasFan()) {
                if (this.hasOccurrences()) {
                    this.populateLastNonRowFields();
                    return CellScannerPosition.BEFORE;
                }
                return this.fixRowFanMissReverse(0);
            }
            byte searchForByte = CellUtil.getRowByte((Cell)key, (int)currentNodeDepth);
            fanIndex = this.currentRowNode.whichFanNode(searchForByte);
            if (fanIndex < 0) {
                int insertionPoint = -fanIndex - 1;
                return this.fixRowFanMissReverse(insertionPoint);
            }
            this.followFan(fanIndex);
        }
    }

    @Override
    public CellScannerPosition positionAtOrAfter(Cell key) {
        this.reInitFirstNode();
        int fanIndex = -1;
        while (true) {
            int currentNodeDepth = this.rowLength;
            int rowTokenComparison = this.compareToCurrentToken(key);
            if (rowTokenComparison != 0) {
                return this.fixRowTokenMissForward(rowTokenComparison);
            }
            if (this.rowMatchesAfterCurrentPosition(key)) {
                return this.positionAtQualifierTimestamp(key, false);
            }
            if (!this.currentRowNode.hasFan()) {
                if (this.hasOccurrences()) {
                    if (this.rowLength < key.getRowLength()) {
                        this.nextRow();
                    } else {
                        this.populateFirstNonRowFields();
                    }
                    return CellScannerPosition.AFTER;
                }
                return this.fixRowFanMissForward(0);
            }
            byte searchForByte = CellUtil.getRowByte((Cell)key, (int)currentNodeDepth);
            fanIndex = this.currentRowNode.whichFanNode(searchForByte);
            if (fanIndex < 0) {
                int insertionPoint = -fanIndex - 1;
                return this.fixRowFanMissForward(insertionPoint);
            }
            this.followFan(fanIndex);
        }
    }

    @Override
    public boolean seekForwardTo(Cell key) {
        if (this.currentPositionIsAfter(key)) {
            return false;
        }
        return this.positionAt(key);
    }

    @Override
    public CellScannerPosition seekForwardToOrBefore(Cell key) {
        if (this.currentPositionIsAfter(key)) {
            return CellScannerPosition.AFTER;
        }
        return this.positionAtOrBefore(key);
    }

    @Override
    public CellScannerPosition seekForwardToOrAfter(Cell key) {
        if (this.currentPositionIsAfter(key)) {
            return CellScannerPosition.AFTER;
        }
        return this.positionAtOrAfter(key);
    }

    @Override
    public void positionAfterLastCell() {
        this.resetToBeforeFirstEntry();
        this.beforeFirst = false;
        this.afterLast = true;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected boolean currentPositionIsAfter(Cell cell) {
        return this.compareTo(cell) > 0;
    }

    protected CellScannerPosition positionAtQualifierTimestamp(Cell key, boolean beforeOnMiss) {
        int diff;
        int minIndex = 0;
        int maxIndex = this.currentRowNode.getLastCellIndex();
        while (true) {
            int midIndex;
            if ((diff = this.populateNonRowFieldsAndCompareTo(midIndex = (maxIndex + minIndex) / 2, key)) == 0) {
                return CellScannerPosition.AT;
            }
            if (minIndex == maxIndex) break;
            if (minIndex + 1 == maxIndex) {
                diff = this.populateNonRowFieldsAndCompareTo(maxIndex, key);
                if (diff <= 0) break;
                diff = this.populateNonRowFieldsAndCompareTo(minIndex, key);
                break;
            }
            if (diff < 0) {
                minIndex = this.currentCellIndex;
                continue;
            }
            maxIndex = this.currentCellIndex;
        }
        if (diff == 0) {
            return CellScannerPosition.AT;
        }
        if (diff < 0) {
            if (beforeOnMiss) {
                return CellScannerPosition.BEFORE;
            }
            if (this.advance()) {
                return CellScannerPosition.AFTER;
            }
            return CellScannerPosition.AFTER_LAST;
        }
        if (!beforeOnMiss) {
            return CellScannerPosition.AFTER;
        }
        if (this.previous()) {
            return CellScannerPosition.BEFORE;
        }
        return CellScannerPosition.BEFORE_FIRST;
    }

    protected boolean rowMatchesAfterCurrentPosition(Cell key) {
        if (!this.currentRowNode.hasOccurrences()) {
            return false;
        }
        short thatRowLength = key.getRowLength();
        return this.rowLength == thatRowLength;
    }

    protected int compareToCurrentToken(Cell key) {
        int startIndex = this.rowLength - this.currentRowNode.getTokenLength();
        int endIndexExclusive = startIndex + this.currentRowNode.getTokenLength();
        for (int i = startIndex; i < endIndexExclusive; ++i) {
            byte thisByte;
            if (i >= key.getRowLength()) {
                return -1;
            }
            byte keyByte = CellUtil.getRowByte((Cell)key, (int)i);
            if (keyByte == (thisByte = this.rowBuffer[i])) continue;
            return UnsignedBytes.compare((byte)keyByte, (byte)thisByte);
        }
        if (!this.currentRowNode.hasOccurrences() && this.rowLength >= key.getRowLength()) {
            return -1;
        }
        return 0;
    }

    protected void followLastFansUntilExhausted() {
        while (this.currentRowNode.hasFan()) {
            this.followLastFan();
        }
    }

    protected CellScannerPosition fixRowTokenMissReverse(int searcherIsAfterInputKey) {
        if (searcherIsAfterInputKey < 0) {
            boolean foundPreviousRow = this.previousRow(true);
            if (foundPreviousRow) {
                this.populateLastNonRowFields();
                return CellScannerPosition.BEFORE;
            }
            return CellScannerPosition.BEFORE_FIRST;
        }
        if (this.currentRowNode.hasOccurrences()) {
            this.populateFirstNonRowFields();
            return CellScannerPosition.BEFORE;
        }
        boolean foundNextRow = this.nextRow();
        if (foundNextRow) {
            return CellScannerPosition.AFTER;
        }
        return CellScannerPosition.AFTER_LAST;
    }

    protected CellScannerPosition fixRowTokenMissForward(int searcherIsAfterInputKey) {
        if (searcherIsAfterInputKey < 0) {
            if (this.currentRowNode.hasOccurrences()) {
                this.populateFirstNonRowFields();
                return CellScannerPosition.AFTER;
            }
            boolean foundNextRow = this.nextRow();
            if (foundNextRow) {
                return CellScannerPosition.AFTER;
            }
            return CellScannerPosition.AFTER_LAST;
        }
        this.discardCurrentRowNode(true);
        boolean foundNextRow = this.nextRow();
        if (foundNextRow) {
            return CellScannerPosition.AFTER;
        }
        return CellScannerPosition.AFTER_LAST;
    }

    protected CellScannerPosition fixRowFanMissReverse(int fanInsertionPoint) {
        if (fanInsertionPoint == 0) {
            if (this.currentRowNode.hasOccurrences()) {
                this.populateLastNonRowFields();
                return CellScannerPosition.BEFORE;
            }
            boolean foundPreviousRow = this.previousRow(true);
            if (foundPreviousRow) {
                this.populateLastNonRowFields();
                return CellScannerPosition.BEFORE;
            }
            return CellScannerPosition.BEFORE_FIRST;
        }
        this.followFan(fanInsertionPoint - 1);
        this.followLastFansUntilExhausted();
        this.populateLastNonRowFields();
        return CellScannerPosition.BEFORE;
    }

    protected CellScannerPosition fixRowFanMissForward(int fanInsertionPoint) {
        if (fanInsertionPoint >= this.currentRowNode.getFanOut()) {
            this.discardCurrentRowNode(true);
            if (!this.nextRow()) {
                return CellScannerPosition.AFTER_LAST;
            }
            return CellScannerPosition.AFTER;
        }
        this.followFan(fanInsertionPoint);
        if (this.hasOccurrences()) {
            this.populateFirstNonRowFields();
            return CellScannerPosition.AFTER;
        }
        if (this.nextRowInternal()) {
            this.populateFirstNonRowFields();
            return CellScannerPosition.AFTER;
        }
        return CellScannerPosition.AFTER_LAST;
    }
}

