/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.codec.prefixtree.encode.other;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Joiner;
import org.apache.hadoop.hbase.util.ArrayUtils;
import org.apache.hadoop.hbase.util.CollectionUtils;
import org.apache.hadoop.hbase.util.vint.UFIntTool;

@InterfaceAudience.Private
public class LongEncoder {
    protected HashSet<Long> uniqueValues = new HashSet();
    protected long[] sortedUniqueValues;
    protected long min;
    protected long max;
    protected long maxDelta;
    protected int bytesPerDelta;
    protected int bytesPerIndex;
    protected int totalCompressedBytes;

    public void reset() {
        this.uniqueValues.clear();
        this.sortedUniqueValues = null;
        this.min = Long.MAX_VALUE;
        this.max = Long.MIN_VALUE;
        this.maxDelta = Long.MIN_VALUE;
        this.bytesPerIndex = 0;
        this.bytesPerDelta = 0;
        this.totalCompressedBytes = 0;
    }

    public void add(long timestamp) {
        this.uniqueValues.add(timestamp);
    }

    public LongEncoder compile() {
        int numUnique = this.uniqueValues.size();
        if (numUnique == 1) {
            this.min = (Long)CollectionUtils.getFirst(this.uniqueValues);
            this.sortedUniqueValues = new long[]{this.min};
            return this;
        }
        this.sortedUniqueValues = new long[numUnique];
        int lastIndex = -1;
        for (long value : this.uniqueValues) {
            this.sortedUniqueValues[++lastIndex] = value;
        }
        Arrays.sort(this.sortedUniqueValues);
        this.min = ArrayUtils.getFirst((long[])this.sortedUniqueValues);
        this.max = ArrayUtils.getLast((long[])this.sortedUniqueValues);
        this.maxDelta = this.max - this.min;
        this.bytesPerDelta = this.maxDelta > 0L ? UFIntTool.numBytes(this.maxDelta) : 0;
        int maxIndex = numUnique - 1;
        this.bytesPerIndex = UFIntTool.numBytes(maxIndex);
        this.totalCompressedBytes = numUnique * this.bytesPerDelta;
        return this;
    }

    public long getDelta(int index) {
        if (this.sortedUniqueValues.length == 0) {
            return 0L;
        }
        return this.sortedUniqueValues[index] - this.min;
    }

    public int getIndex(long value) {
        return Arrays.binarySearch(this.sortedUniqueValues, value);
    }

    public void writeBytes(OutputStream os) throws IOException {
        for (int i = 0; i < this.sortedUniqueValues.length; ++i) {
            long delta = this.sortedUniqueValues[i] - this.min;
            UFIntTool.writeBytes(this.bytesPerDelta, delta, os);
        }
    }

    public byte[] getByteArray() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.writeBytes(baos);
        return baos.toByteArray();
    }

    public int getOutputArrayLength() {
        return this.sortedUniqueValues.length * this.bytesPerDelta;
    }

    public int getNumUniqueValues() {
        return this.sortedUniqueValues.length;
    }

    public String toString() {
        if (ArrayUtils.isEmpty((long[])this.sortedUniqueValues)) {
            return "[]";
        }
        return "[" + Joiner.on((String)",").join((Iterable)ArrayUtils.toList((long[])this.sortedUniqueValues)) + "]";
    }

    public long getMin() {
        return this.min;
    }

    public int getBytesPerDelta() {
        return this.bytesPerDelta;
    }

    public int getBytesPerIndex() {
        return this.bytesPerIndex;
    }

    public int getTotalCompressedBytes() {
        return this.totalCompressedBytes;
    }

    public long[] getSortedUniqueTimestamps() {
        return this.sortedUniqueValues;
    }
}

