/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureStoreTracker {
    private final TreeMap<Long, BitSetNode> map = new TreeMap();
    private boolean keepDeletes = false;
    private boolean partial = false;
    private long minUpdatedProcId = Long.MAX_VALUE;
    private long maxUpdatedProcId = Long.MIN_VALUE;

    public void insert(long procId) {
        BitSetNode node = this.getOrCreateNode(procId);
        node.update(procId);
        this.trackProcIds(procId);
    }

    public void insert(long procId, long[] subProcIds) {
        this.update(procId);
        for (int i = 0; i < subProcIds.length; ++i) {
            this.insert(subProcIds[i]);
        }
    }

    public void update(long procId) {
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        assert (entry != null) : "expected node to update procId=" + procId;
        BitSetNode node = entry.getValue();
        assert (node.contains(procId));
        node.update(procId);
        this.trackProcIds(procId);
    }

    public void delete(long procId) {
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        assert (entry != null) : "expected node to delete procId=" + procId;
        BitSetNode node = entry.getValue();
        assert (node.contains(procId)) : "expected procId in the node";
        node.delete(procId);
        if (!this.keepDeletes && node.isEmpty()) {
            this.map.remove(entry.getKey());
        }
        this.trackProcIds(procId);
    }

    private void trackProcIds(long procId) {
        this.minUpdatedProcId = Math.min(this.minUpdatedProcId, procId);
        this.maxUpdatedProcId = Math.max(this.maxUpdatedProcId, procId);
    }

    public long getUpdatedMinProcId() {
        return this.minUpdatedProcId;
    }

    public long getUpdatedMaxProcId() {
        return this.maxUpdatedProcId;
    }

    @InterfaceAudience.Private
    public void setDeleted(long procId, boolean isDeleted) {
        BitSetNode node = this.getOrCreateNode(procId);
        assert (node.contains(procId)) : "expected procId=" + procId + " in the node=" + node;
        node.updateState(procId, isDeleted);
    }

    public void clear() {
        this.map.clear();
        this.resetUpdates();
    }

    public DeleteState isDeleted(long procId) {
        Map.Entry<Long, BitSetNode> entry = this.map.floorEntry(procId);
        if (entry != null && entry.getValue().contains(procId)) {
            BitSetNode node = entry.getValue();
            DeleteState state = node.isDeleted(procId);
            return this.partial && !node.isUpdated(procId) ? DeleteState.MAYBE : state;
        }
        return this.partial ? DeleteState.MAYBE : DeleteState.YES;
    }

    public long getMinProcId() {
        Map.Entry<Long, BitSetNode> entry = this.map.firstEntry();
        return entry == null ? 0L : entry.getValue().getMinProcId();
    }

    public void setKeepDeletes(boolean keepDeletes) {
        this.keepDeletes = keepDeletes;
        if (!keepDeletes) {
            Iterator<Map.Entry<Long, BitSetNode>> it = this.map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Long, BitSetNode> entry = it.next();
                if (!entry.getValue().isEmpty()) continue;
                it.remove();
            }
        }
    }

    public void setPartialFlag(boolean isPartial) {
        if (this.partial && !isPartial) {
            for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
                entry.getValue().unsetPartialFlag();
            }
        }
        this.partial = isPartial;
    }

    public boolean isEmpty() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isUpdated() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            if (entry.getValue().isUpdated()) continue;
            return false;
        }
        return true;
    }

    public boolean isTracking(long minId, long maxId) {
        return this.map.floorEntry(minId) != null || this.map.floorEntry(maxId) != null;
    }

    public void resetUpdates() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            entry.getValue().resetUpdates();
        }
        this.minUpdatedProcId = Long.MAX_VALUE;
        this.maxUpdatedProcId = Long.MIN_VALUE;
    }

    public void undeleteAll() {
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            entry.getValue().undeleteAll();
        }
    }

    private BitSetNode getOrCreateNode(long procId) {
        BitSetNode leftNode = null;
        boolean leftCanGrow = false;
        Map.Entry<Long, BitSetNode> leftEntry = this.map.floorEntry(procId);
        if (leftEntry != null) {
            leftNode = leftEntry.getValue();
            if (leftNode.contains(procId)) {
                return leftNode;
            }
            leftCanGrow = leftNode.canGrow(procId);
        }
        BitSetNode rightNode = null;
        boolean rightCanGrow = false;
        Map.Entry<Long, BitSetNode> rightEntry = this.map.ceilingEntry(procId);
        if (rightEntry != null) {
            rightNode = rightEntry.getValue();
            rightCanGrow = rightNode.canGrow(procId);
            if (leftNode != null) {
                if (leftNode.canMerge(rightNode)) {
                    return this.mergeNodes(leftNode, rightNode);
                }
                if (leftCanGrow && rightCanGrow) {
                    if (procId - leftNode.getEnd() <= rightNode.getStart() - procId) {
                        return this.growNode(leftNode, procId);
                    }
                    return this.growNode(rightNode, procId);
                }
            }
        }
        if (leftCanGrow) {
            return this.growNode(leftNode, procId);
        }
        if (rightCanGrow) {
            return this.growNode(rightNode, procId);
        }
        BitSetNode node = new BitSetNode(procId, this.partial);
        this.map.put(node.getStart(), node);
        return node;
    }

    private BitSetNode growNode(BitSetNode node, long procId) {
        this.map.remove(node.getStart());
        node.grow(procId);
        this.map.put(node.getStart(), node);
        return node;
    }

    private BitSetNode mergeNodes(BitSetNode leftNode, BitSetNode rightNode) {
        assert (leftNode.getStart() < rightNode.getStart());
        leftNode.merge(rightNode);
        this.map.remove(rightNode.getStart());
        return leftNode;
    }

    public void dump() {
        System.out.println("map " + this.map.size());
        System.out.println("isUpdated " + this.isUpdated());
        System.out.println("isEmpty " + this.isEmpty());
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            entry.getValue().dump();
        }
    }

    public void writeTo(OutputStream stream) throws IOException {
        ProcedureProtos.ProcedureStoreTracker.Builder builder = ProcedureProtos.ProcedureStoreTracker.newBuilder();
        for (Map.Entry<Long, BitSetNode> entry : this.map.entrySet()) {
            builder.addNode(entry.getValue().convert());
        }
        builder.build().writeDelimitedTo(stream);
    }

    public void readFrom(InputStream stream) throws IOException {
        ProcedureProtos.ProcedureStoreTracker data = ProcedureProtos.ProcedureStoreTracker.parseDelimitedFrom((InputStream)stream);
        this.map.clear();
        for (ProcedureProtos.ProcedureStoreTracker.TrackerNode protoNode : data.getNodeList()) {
            BitSetNode node = BitSetNode.convert(protoNode);
            this.map.put(node.getStart(), node);
        }
    }

    public static class BitSetNode {
        private static final long WORD_MASK = -1L;
        private static final int ADDRESS_BITS_PER_WORD = 6;
        private static final int BITS_PER_WORD = 64;
        private static final int MAX_NODE_SIZE = 64;
        private final boolean partial;
        private long[] updated;
        private long[] deleted;
        private long start;

        public void dump() {
            int j;
            int i;
            System.out.printf("%06d:%06d min=%d max=%d%n", this.getStart(), this.getEnd(), this.getMinProcId(), this.getMaxProcId());
            System.out.println("Update:");
            for (i = 0; i < this.updated.length; ++i) {
                for (j = 0; j < 64; ++j) {
                    System.out.print((this.updated[i] & 1L << j) != 0L ? "1" : "0");
                }
                System.out.println(" " + i);
            }
            System.out.println();
            System.out.println("Delete:");
            for (i = 0; i < this.deleted.length; ++i) {
                for (j = 0; j < 64; ++j) {
                    System.out.print((this.deleted[i] & 1L << j) != 0L ? "1" : "0");
                }
                System.out.println(" " + i);
            }
            System.out.println();
        }

        public BitSetNode(long procId, boolean partial) {
            this.start = BitSetNode.alignDown(procId);
            int count = 1;
            this.updated = new long[count];
            this.deleted = new long[count];
            for (int i = 0; i < count; ++i) {
                this.updated[i] = 0L;
                this.deleted[i] = partial ? 0L : -1L;
            }
            this.partial = partial;
            this.updateState(procId, false);
        }

        protected BitSetNode(long start, long[] updated, long[] deleted) {
            this.start = start;
            this.updated = updated;
            this.deleted = deleted;
            this.partial = false;
        }

        public void update(long procId) {
            this.updateState(procId, false);
        }

        public void delete(long procId) {
            this.updateState(procId, true);
        }

        public Long getStart() {
            return this.start;
        }

        public Long getEnd() {
            return this.start + (long)(this.updated.length << 6) - 1L;
        }

        public boolean contains(long procId) {
            return this.start <= procId && procId <= this.getEnd();
        }

        public DeleteState isDeleted(long procId) {
            int bitmapIndex = this.getBitmapIndex(procId);
            int wordIndex = bitmapIndex >> 6;
            if (wordIndex >= this.deleted.length) {
                return DeleteState.MAYBE;
            }
            return (this.deleted[wordIndex] & 1L << bitmapIndex) != 0L ? DeleteState.YES : DeleteState.NO;
        }

        private boolean isUpdated(long procId) {
            int bitmapIndex = this.getBitmapIndex(procId);
            int wordIndex = bitmapIndex >> 6;
            if (wordIndex >= this.updated.length) {
                return false;
            }
            return (this.updated[wordIndex] & 1L << bitmapIndex) != 0L;
        }

        public boolean isUpdated() {
            for (int i = 0; i < this.updated.length; ++i) {
                if ((this.updated[i] | this.deleted[i]) == -1L) continue;
                return false;
            }
            return true;
        }

        public boolean isEmpty() {
            for (int i = 0; i < this.deleted.length; ++i) {
                if (this.deleted[i] == -1L) continue;
                return false;
            }
            return true;
        }

        public void resetUpdates() {
            for (int i = 0; i < this.updated.length; ++i) {
                this.updated[i] = 0L;
            }
        }

        public void undeleteAll() {
            for (int i = 0; i < this.updated.length; ++i) {
                this.deleted[i] = 0L;
            }
        }

        public void unsetPartialFlag() {
            for (int i = 0; i < this.updated.length; ++i) {
                for (int j = 0; j < 64; ++j) {
                    if ((this.updated[i] & 1L << j) != 0L) continue;
                    int n = i;
                    this.deleted[n] = this.deleted[n] | 1L << j;
                }
            }
        }

        public ProcedureProtos.ProcedureStoreTracker.TrackerNode convert() {
            ProcedureProtos.ProcedureStoreTracker.TrackerNode.Builder builder = ProcedureProtos.ProcedureStoreTracker.TrackerNode.newBuilder();
            builder.setStartId(this.start);
            for (int i = 0; i < this.updated.length; ++i) {
                builder.addUpdated(this.updated[i]);
                builder.addDeleted(this.deleted[i]);
            }
            return builder.build();
        }

        public static BitSetNode convert(ProcedureProtos.ProcedureStoreTracker.TrackerNode data) {
            long start = data.getStartId();
            int size = data.getUpdatedCount();
            long[] updated = new long[size];
            long[] deleted = new long[size];
            for (int i = 0; i < size; ++i) {
                updated[i] = data.getUpdated(i);
                deleted[i] = data.getDeleted(i);
            }
            return new BitSetNode(start, updated, deleted);
        }

        public boolean canGrow(long procId) {
            return Math.abs(procId - this.start) < 64L;
        }

        public boolean canMerge(BitSetNode rightNode) {
            assert (this.start < rightNode.getEnd());
            return rightNode.getEnd() - this.start < 64L;
        }

        public void grow(long procId) {
            int i;
            int offset;
            int delta;
            if (procId < this.start) {
                long newStart = BitSetNode.alignDown(procId);
                offset = delta = (int)(this.start - newStart) >> 6;
                this.start = newStart;
            } else {
                long newEnd = BitSetNode.alignUp(procId + 1L);
                delta = (int)(newEnd - this.getEnd()) >> 6;
                offset = 0;
            }
            int oldSize = this.updated.length;
            long[] newBitmap = new long[oldSize + delta];
            for (i = 0; i < newBitmap.length; ++i) {
                newBitmap[i] = 0L;
            }
            System.arraycopy(this.updated, 0, newBitmap, offset, oldSize);
            this.updated = newBitmap;
            newBitmap = new long[this.deleted.length + delta];
            for (i = 0; i < newBitmap.length; ++i) {
                newBitmap[i] = this.partial ? 0L : -1L;
            }
            System.arraycopy(this.deleted, 0, newBitmap, offset, oldSize);
            this.deleted = newBitmap;
        }

        public void merge(BitSetNode rightNode) {
            int delta = (int)(rightNode.getEnd() - this.getEnd()) >> 6;
            int oldSize = this.updated.length;
            int newSize = delta - rightNode.updated.length;
            int offset = oldSize + newSize;
            long[] newBitmap = new long[oldSize + delta];
            System.arraycopy(this.updated, 0, newBitmap, 0, oldSize);
            System.arraycopy(rightNode.updated, 0, newBitmap, offset, rightNode.updated.length);
            this.updated = newBitmap;
            newBitmap = new long[oldSize + delta];
            System.arraycopy(this.deleted, 0, newBitmap, 0, oldSize);
            System.arraycopy(rightNode.deleted, 0, newBitmap, offset, rightNode.deleted.length);
            this.deleted = newBitmap;
            for (int i = 0; i < newSize; ++i) {
                this.updated[offset + i] = 0L;
                this.deleted[offset + i] = this.partial ? 0L : -1L;
            }
        }

        public String toString() {
            return "BitSetNode(" + this.getStart() + "-" + this.getEnd() + ")";
        }

        public long getMinProcId() {
            long minProcId = this.start;
            for (int i = 0; i < this.deleted.length; ++i) {
                if (this.deleted[i] == 0L) {
                    return minProcId;
                }
                if (this.deleted[i] != -1L) {
                    for (int j = 0; j < 64; ++j) {
                        if ((this.deleted[i] & 1L << j) == 0L) continue;
                        return minProcId + (long)j;
                    }
                }
                minProcId += 64L;
            }
            return minProcId;
        }

        public long getMaxProcId() {
            long maxProcId = this.getEnd();
            for (int i = this.deleted.length - 1; i >= 0; --i) {
                if (this.deleted[i] == 0L) {
                    return maxProcId;
                }
                if (this.deleted[i] != -1L) {
                    for (int j = 63; j >= 0; --j) {
                        if ((this.deleted[i] & 1L << j) != 0L) continue;
                        return maxProcId - (long)(63 - j);
                    }
                }
                maxProcId -= 64L;
            }
            return maxProcId;
        }

        private int getBitmapIndex(long procId) {
            return (int)(procId - this.start);
        }

        private void updateState(long procId, boolean isDeleted) {
            int bitmapIndex = this.getBitmapIndex(procId);
            int wordIndex = bitmapIndex >> 6;
            long value = 1L << bitmapIndex;
            if (isDeleted) {
                int n = wordIndex;
                this.updated[n] = this.updated[n] | value;
                int n2 = wordIndex;
                this.deleted[n2] = this.deleted[n2] | value;
            } else {
                int n = wordIndex;
                this.updated[n] = this.updated[n] | value;
                int n3 = wordIndex;
                this.deleted[n3] = this.deleted[n3] & (value ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }

        private static long alignUp(long x) {
            return x + 63L & 0xFFFFFFFFFFFFFFC0L;
        }

        private static long alignDown(long x) {
            return x & 0xFFFFFFFFFFFFFFC0L;
        }
    }

    public static enum DeleteState {
        YES,
        NO,
        MAYBE;

    }
}

