/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.SequentialProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestProcedureExecution {
    private static final Log LOG = LogFactory.getLog(TestProcedureExecution.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static final Procedure NULL_PROC = null;
    private ProcedureExecutor<Void> procExecutor;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.fs, this.logDir);
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), null, this.procStore);
        this.procStore.start(1);
        this.procExecutor.start(1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test(timeout=30000L)
    public void testBadSubprocList() {
        ArrayList<String> state = new ArrayList<String>();
        TestSequentialProcedure subProc2 = new TestSequentialProcedure("subProc2", state, new Procedure[0]);
        TestSequentialProcedure subProc1 = new TestSequentialProcedure("subProc1", state, new Procedure[]{subProc2, NULL_PROC});
        TestSequentialProcedure rootProc = new TestSequentialProcedure("rootProc", state, new Procedure[]{subProc1});
        long rootId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)rootProc);
        LOG.info(state);
        ProcedureInfo result = this.procExecutor.getResult(rootId);
        Assert.assertTrue((String)((Object)state).toString(), (boolean)result.isFailed());
        ProcedureTestingUtility.assertIsIllegalArgumentException(result);
        Assert.assertEquals((String)((Object)state).toString(), (long)4L, (long)state.size());
        Assert.assertEquals((Object)"rootProc-execute", state.get(0));
        Assert.assertEquals((Object)"subProc1-execute", state.get(1));
        Assert.assertEquals((Object)"subProc1-rollback", state.get(2));
        Assert.assertEquals((Object)"rootProc-rollback", state.get(3));
    }

    @Test(timeout=30000L)
    public void testSingleSequentialProc() {
        ArrayList<String> state = new ArrayList<String>();
        TestSequentialProcedure subProc2 = new TestSequentialProcedure("subProc2", state, new Procedure[0]);
        TestSequentialProcedure subProc1 = new TestSequentialProcedure("subProc1", state, new Procedure[]{subProc2});
        TestSequentialProcedure rootProc = new TestSequentialProcedure("rootProc", state, new Procedure[]{subProc1});
        long rootId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)rootProc);
        LOG.info(state);
        ProcedureInfo result = this.procExecutor.getResult(rootId);
        ProcedureTestingUtility.assertProcNotFailed(result);
        Assert.assertEquals((String)((Object)state).toString(), (long)3L, (long)state.size());
    }

    @Test(timeout=30000L)
    public void testSingleSequentialProcRollback() {
        ArrayList<String> state = new ArrayList<String>();
        TestSequentialProcedure subProc2 = new TestSequentialProcedure("subProc2", state, new TestProcedureException("fail test"));
        TestSequentialProcedure subProc1 = new TestSequentialProcedure("subProc1", state, new Procedure[]{subProc2});
        TestSequentialProcedure rootProc = new TestSequentialProcedure("rootProc", state, new Procedure[]{subProc1});
        long rootId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)rootProc);
        LOG.info(state);
        ProcedureInfo result = this.procExecutor.getResult(rootId);
        Assert.assertTrue((String)((Object)state).toString(), (boolean)result.isFailed());
        LOG.info((Object)result.getExceptionFullMessage());
        Throwable cause = ProcedureTestingUtility.getExceptionCause(result);
        Assert.assertTrue((String)("expected TestProcedureException, got " + cause), (boolean)(cause instanceof TestProcedureException));
        Assert.assertEquals((String)((Object)state).toString(), (long)6L, (long)state.size());
        Assert.assertEquals((Object)"rootProc-execute", state.get(0));
        Assert.assertEquals((Object)"subProc1-execute", state.get(1));
        Assert.assertEquals((Object)"subProc2-execute", state.get(2));
        Assert.assertEquals((Object)"subProc2-rollback", state.get(3));
        Assert.assertEquals((Object)"subProc1-rollback", state.get(4));
        Assert.assertEquals((Object)"rootProc-rollback", state.get(5));
    }

    @Test(timeout=30000L)
    public void testRollbackRetriableFailure() {
        long procId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)new TestFaultyRollback());
        ProcedureInfo result = this.procExecutor.getResult(procId);
        Assert.assertTrue((String)"expected a failure", (boolean)result.isFailed());
        LOG.info((Object)result.getExceptionFullMessage());
        Throwable cause = ProcedureTestingUtility.getExceptionCause(result);
        Assert.assertTrue((String)("expected TestProcedureException, got " + cause), (boolean)(cause instanceof TestProcedureException));
    }

    @Test(timeout=30000L)
    public void testAbortTimeout() {
        int PROC_TIMEOUT_MSEC = 2500;
        ArrayList<String> state = new ArrayList<String>();
        TestWaitingProcedure proc = new TestWaitingProcedure("wproc", state, false);
        proc.setTimeout(2500);
        long startTime = EnvironmentEdgeManager.currentTime();
        long rootId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)proc);
        long execTime = EnvironmentEdgeManager.currentTime() - startTime;
        LOG.info(state);
        Assert.assertTrue((String)("we didn't wait enough execTime=" + execTime), (execTime >= 2500L ? 1 : 0) != 0);
        ProcedureInfo result = this.procExecutor.getResult(rootId);
        Assert.assertTrue((String)((Object)state).toString(), (boolean)result.isFailed());
        ProcedureTestingUtility.assertIsTimeoutException(result);
        Assert.assertEquals((String)((Object)state).toString(), (long)2L, (long)state.size());
        Assert.assertEquals((Object)"wproc-execute", state.get(0));
        Assert.assertEquals((Object)"wproc-rollback", state.get(1));
    }

    @Test(timeout=30000L)
    public void testAbortTimeoutWithChildren() {
        ArrayList<String> state = new ArrayList<String>();
        TestWaitingProcedure proc = new TestWaitingProcedure("wproc", state, true);
        proc.setTimeout(2500);
        long rootId = ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)proc);
        LOG.info(state);
        ProcedureInfo result = this.procExecutor.getResult(rootId);
        Assert.assertTrue((String)((Object)state).toString(), (boolean)result.isFailed());
        ProcedureTestingUtility.assertIsTimeoutException(result);
        Assert.assertEquals((String)((Object)state).toString(), (long)4L, (long)state.size());
        Assert.assertEquals((Object)"wproc-execute", state.get(0));
        Assert.assertEquals((Object)"wproc-child-execute", state.get(1));
        Assert.assertEquals((Object)"wproc-child-rollback", state.get(2));
        Assert.assertEquals((Object)"wproc-rollback", state.get(3));
    }

    public static class TestWaitingProcedure
    extends SequentialProcedure<Void> {
        private final List<String> state;
        private final boolean hasChild;
        private final String name;

        public TestWaitingProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestWaitingProcedure(String name, List<String> state, boolean hasChild) {
            this.hasChild = hasChild;
            this.state = state;
            this.name = name;
        }

        protected Procedure[] execute(Void env) {
            Procedure[] procedureArray;
            this.state.add(this.name + "-execute");
            this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
            if (this.hasChild) {
                Procedure[] procedureArray2 = new Procedure[1];
                procedureArray = procedureArray2;
                procedureArray2[0] = new TestWaitChild(this.name, this.state);
            } else {
                procedureArray = null;
            }
            return procedureArray;
        }

        protected void rollback(Void env) {
            this.state.add(this.name + "-rollback");
        }

        protected boolean abort(Void env) {
            this.state.add(this.name + "-abort");
            return true;
        }

        public static class TestWaitChild
        extends SequentialProcedure<Void> {
            private final List<String> state;
            private final String name;

            public TestWaitChild() {
                throw new UnsupportedOperationException("recovery should not be triggered here");
            }

            public TestWaitChild(String name, List<String> state) {
                this.name = name;
                this.state = state;
            }

            protected Procedure[] execute(Void env) {
                this.state.add(this.name + "-child-execute");
                return null;
            }

            protected void rollback(Void env) {
                this.state.add(this.name + "-child-rollback");
            }

            protected boolean abort(Void env) {
                this.state.add(this.name + "-child-abort");
                return true;
            }
        }
    }

    public static class TestFaultyRollback
    extends SequentialProcedure<Void> {
        private int retries = 0;

        protected Procedure[] execute(Void env) {
            this.setFailure("faulty-rollback-test", new TestProcedureException("test faulty rollback"));
            return null;
        }

        protected void rollback(Void env) throws IOException {
            if (++this.retries < 3) {
                LOG.info((Object)("inject rollback failure " + this.retries));
                throw new IOException("injected failure number " + this.retries);
            }
            LOG.info((Object)("execute non faulty rollback step retries=" + this.retries));
        }

        protected boolean abort(Void env) {
            return false;
        }
    }

    public static class TestSequentialProcedure
    extends SequentialProcedure<Void> {
        private final Procedure[] subProcs;
        private final List<String> state;
        private final Exception failure;
        private final String name;

        public TestSequentialProcedure() {
            throw new UnsupportedOperationException("recovery should not be triggered here");
        }

        public TestSequentialProcedure(String name, List<String> state, Procedure ... subProcs) {
            this.state = state;
            this.subProcs = subProcs;
            this.name = name;
            this.failure = null;
        }

        public TestSequentialProcedure(String name, List<String> state, Exception failure) {
            this.state = state;
            this.subProcs = null;
            this.name = name;
            this.failure = failure;
        }

        protected Procedure[] execute(Void env) {
            this.state.add(this.name + "-execute");
            if (this.failure != null) {
                this.setFailure(new RemoteProcedureException(this.name + "-failure", (Throwable)this.failure));
                return null;
            }
            return this.subProcs;
        }

        protected void rollback(Void env) {
            this.state.add(this.name + "-rollback");
        }

        protected boolean abort(Void env) {
            this.state.add(this.name + "-abort");
            return true;
        }
    }

    private static class TestProcedureException
    extends IOException {
        public TestProcedureException(String msg) {
            super(msg);
        }
    }
}

