/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.util;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.procedure2.util.TimeoutBlockingQueue;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTimeoutBlockingQueue {
    private static final Log LOG = LogFactory.getLog(TestTimeoutBlockingQueue.class);

    @Test
    public void testOrder() {
        TimeoutBlockingQueue queue = new TimeoutBlockingQueue(8, (TimeoutBlockingQueue.TimeoutRetriever)new TestObjectTimeoutRetriever());
        long[] timeouts = new long[]{500L, 200L, 700L, 300L, 600L, 600L, 200L, 800L, 500L};
        for (int i = 0; i < timeouts.length; ++i) {
            for (int j = 0; j <= i; ++j) {
                queue.add((Object)new TestObject(j, timeouts[j]));
                queue.dump();
            }
            long prev = 0L;
            for (int j = 0; j <= i; ++j) {
                TestObject obj = (TestObject)queue.poll();
                Assert.assertTrue((obj.getTimeout() >= prev ? 1 : 0) != 0);
                prev = obj.getTimeout();
                queue.dump();
            }
        }
    }

    @Test
    public void testTimeoutBlockingQueue() {
        int[][] testArray = new int[][]{{200, 400, 600}, {200, 400, 100}, {200, 400, 300}};
        for (int i = 0; i < testArray.length; ++i) {
            int j;
            int[] sortedArray = Arrays.copyOf(testArray[i], testArray[i].length);
            Arrays.sort(sortedArray);
            TimeoutBlockingQueue queue = new TimeoutBlockingQueue(2, (TimeoutBlockingQueue.TimeoutRetriever)new TestObjectTimeoutRetriever());
            for (j = 0; j < testArray[i].length; ++j) {
                queue.add((Object)new TestObject(j, testArray[i][j]));
                queue.dump();
            }
            j = 0;
            while (!queue.isEmpty()) {
                Assert.assertEquals((long)sortedArray[j], (long)((TestObject)queue.poll()).getTimeout());
                ++j;
            }
            queue = new TimeoutBlockingQueue(2, (TimeoutBlockingQueue.TimeoutRetriever)new TestObjectTimeoutRetriever());
            queue.add((Object)new TestObject(0, 50L));
            Assert.assertEquals((long)50L, (long)((TestObject)queue.poll()).getTimeout());
            for (j = 0; j < testArray[i].length; ++j) {
                queue.add((Object)new TestObject(j, testArray[i][j]));
                queue.dump();
            }
            j = 0;
            while (!queue.isEmpty()) {
                Assert.assertEquals((long)sortedArray[j], (long)((TestObject)queue.poll()).getTimeout());
                ++j;
            }
        }
    }

    static class TestObjectTimeoutRetriever
    implements TimeoutBlockingQueue.TimeoutRetriever<TestObject> {
        TestObjectTimeoutRetriever() {
        }

        public long getTimeout(TestObject obj) {
            return obj.getTimeout();
        }

        public TimeUnit getTimeUnit(TestObject obj) {
            return TimeUnit.MILLISECONDS;
        }
    }

    static class TestObject {
        private long timeout;
        private int seqId;

        public TestObject(int seqId, long timeout) {
            this.timeout = timeout;
            this.seqId = seqId;
        }

        public long getTimeout() {
            return this.timeout;
        }

        public String toString() {
            return String.format("(%03d, %03d)", this.seqId, this.timeout);
        }
    }
}

