/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureRunnableSet;
import org.apache.hadoop.hbase.procedure2.ProcedureSimpleRunQueue;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestYieldProcedures {
    private static final Log LOG = LogFactory.getLog(TestYieldProcedures.class);
    private static final int PROCEDURE_EXECUTOR_SLOTS = 1;
    private static final Procedure NULL_PROC = null;
    private ProcedureExecutor<TestProcEnv> procExecutor;
    private TestRunQueue procRunnables;
    private ProcedureStore procStore;
    private HBaseCommonTestingUtility htu;
    private FileSystem fs;
    private Path testDir;
    private Path logDir;

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseCommonTestingUtility();
        this.testDir = this.htu.getDataTestDir();
        this.fs = this.testDir.getFileSystem(this.htu.getConfiguration());
        Assert.assertTrue((this.testDir.depth() > 1 ? 1 : 0) != 0);
        this.logDir = new Path(this.testDir, "proc-logs");
        this.procStore = ProcedureTestingUtility.createWalStore(this.htu.getConfiguration(), this.logDir);
        this.procRunnables = new TestRunQueue();
        this.procExecutor = new ProcedureExecutor(this.htu.getConfiguration(), (Object)new TestProcEnv(), this.procStore, (ProcedureRunnableSet)this.procRunnables);
        this.procStore.start(1);
        this.procExecutor.start(1, true);
    }

    @After
    public void tearDown() throws IOException {
        this.procExecutor.stop();
        this.procStore.stop(false);
        this.fs.delete(this.logDir, true);
    }

    @Test
    public void testYieldEachExecutionStep() throws Exception {
        int i;
        int NUM_STATES = 3;
        TestStateMachineProcedure[] procs = new TestStateMachineProcedure[3];
        for (i = 0; i < procs.length; ++i) {
            procs[i] = new TestStateMachineProcedure(true, false);
            this.procExecutor.submitProcedure((Procedure)procs[i]);
        }
        ProcedureTestingUtility.waitNoProcedureRunning(this.procExecutor);
        for (i = 0; i < procs.length; ++i) {
            TestStateMachineProcedure.ExecutionInfo info;
            int execStep;
            Assert.assertEquals((long)6L, (long)procs[i].getExecutionInfo().size());
            int index = 0;
            for (execStep = 0; execStep < 3; ++execStep) {
                info = procs[i].getExecutionInfo().get(index++);
                Assert.assertEquals((Object)false, (Object)info.isRollback());
                Assert.assertEquals((long)execStep, (long)info.getStep().ordinal());
            }
            for (execStep = 2; execStep >= 0; --execStep) {
                info = procs[i].getExecutionInfo().get(index++);
                Assert.assertEquals((Object)true, (Object)info.isRollback());
                Assert.assertEquals((long)execStep, (long)info.getStep().ordinal());
            }
        }
        Assert.assertEquals((long)0L, (long)this.procRunnables.size());
        Assert.assertEquals((long)0L, (long)this.procRunnables.addFrontCalls);
        Assert.assertEquals((long)18L, (long)this.procRunnables.addBackCalls);
        Assert.assertEquals((long)15L, (long)this.procRunnables.yieldCalls);
        Assert.assertEquals((long)19L, (long)this.procRunnables.pollCalls);
        Assert.assertEquals((long)3L, (long)this.procRunnables.completionCalls);
    }

    @Test
    public void testYieldOnInterrupt() throws Exception {
        TestStateMachineProcedure.ExecutionInfo info;
        int i;
        int NUM_STATES = 3;
        int count = 0;
        TestStateMachineProcedure proc = new TestStateMachineProcedure(true, true);
        ProcedureTestingUtility.submitAndWait(this.procExecutor, (Procedure)proc);
        Assert.assertEquals((long)12L, (long)proc.getExecutionInfo().size());
        for (i = 0; i < 3; ++i) {
            info = proc.getExecutionInfo().get(count++);
            Assert.assertEquals((Object)false, (Object)info.isRollback());
            Assert.assertEquals((long)i, (long)info.getStep().ordinal());
            info = proc.getExecutionInfo().get(count++);
            Assert.assertEquals((Object)false, (Object)info.isRollback());
            Assert.assertEquals((long)i, (long)info.getStep().ordinal());
        }
        for (i = 2; i >= 0; --i) {
            info = proc.getExecutionInfo().get(count++);
            Assert.assertEquals((Object)true, (Object)info.isRollback());
            Assert.assertEquals((long)i, (long)info.getStep().ordinal());
            info = proc.getExecutionInfo().get(count++);
            Assert.assertEquals((Object)true, (Object)info.isRollback());
            Assert.assertEquals((long)i, (long)info.getStep().ordinal());
        }
        Assert.assertEquals((long)0L, (long)this.procRunnables.size());
        Assert.assertEquals((long)0L, (long)this.procRunnables.addFrontCalls);
        Assert.assertEquals((long)12L, (long)this.procRunnables.addBackCalls);
        Assert.assertEquals((long)11L, (long)this.procRunnables.yieldCalls);
        Assert.assertEquals((long)13L, (long)this.procRunnables.pollCalls);
        Assert.assertEquals((long)1L, (long)this.procRunnables.completionCalls);
    }

    @Test
    public void testYieldException() {
        TestYieldProcedure proc = new TestYieldProcedure();
        ProcedureTestingUtility.submitAndWait(this.procExecutor, proc);
        Assert.assertEquals((long)6L, (long)proc.step);
        Assert.assertEquals((long)0L, (long)this.procRunnables.size());
        Assert.assertEquals((long)0L, (long)this.procRunnables.addFrontCalls);
        Assert.assertEquals((long)6L, (long)this.procRunnables.addBackCalls);
        Assert.assertEquals((long)5L, (long)this.procRunnables.yieldCalls);
        Assert.assertEquals((long)7L, (long)this.procRunnables.pollCalls);
        Assert.assertEquals((long)1L, (long)this.procRunnables.completionCalls);
    }

    private static class TestRunQueue
    extends ProcedureSimpleRunQueue {
        private int completionCalls;
        private int addFrontCalls;
        private int addBackCalls;
        private int yieldCalls;
        private int pollCalls;

        public void addFront(Procedure proc) {
            ++this.addFrontCalls;
            super.addFront(proc);
        }

        public void addBack(Procedure proc) {
            ++this.addBackCalls;
            super.addBack(proc);
        }

        public void yield(Procedure proc) {
            ++this.yieldCalls;
            super.yield(proc);
        }

        public Procedure poll() {
            ++this.pollCalls;
            return super.poll();
        }

        public void completionCleanup(Procedure proc) {
            ++this.completionCalls;
        }
    }

    public static class TestYieldProcedure
    extends Procedure<TestProcEnv> {
        private int step = 0;

        protected Procedure[] execute(TestProcEnv env) throws ProcedureYieldException {
            LOG.info((Object)("execute step " + this.step));
            if (this.step++ < 5) {
                throw new ProcedureYieldException();
            }
            return null;
        }

        protected void rollback(TestProcEnv env) {
        }

        protected boolean abort(TestProcEnv env) {
            return false;
        }

        protected boolean isYieldAfterExecutionStep(TestProcEnv env) {
            return true;
        }

        protected void serializeStateData(OutputStream stream) throws IOException {
        }

        protected void deserializeStateData(InputStream stream) throws IOException {
        }
    }

    public static class TestStateMachineProcedure
    extends StateMachineProcedure<TestProcEnv, State> {
        private final ArrayList<ExecutionInfo> executionInfo = new ArrayList();
        private final AtomicBoolean aborted = new AtomicBoolean(false);
        private final boolean throwInterruptOnceOnEachStep;
        private final boolean abortOnFinalStep;

        public TestStateMachineProcedure() {
            this(false, false);
        }

        public TestStateMachineProcedure(boolean abortOnFinalStep, boolean throwInterruptOnceOnEachStep) {
            this.abortOnFinalStep = abortOnFinalStep;
            this.throwInterruptOnceOnEachStep = throwInterruptOnceOnEachStep;
        }

        public ArrayList<ExecutionInfo> getExecutionInfo() {
            return this.executionInfo;
        }

        protected StateMachineProcedure.Flow executeFromState(TestProcEnv env, State state) throws InterruptedException {
            long ts = env.nextTimestamp();
            LOG.info((Object)(this.getProcId() + " execute step " + (Object)((Object)state) + " ts=" + ts));
            this.executionInfo.add(new ExecutionInfo(ts, state, false));
            Thread.sleep(150L);
            if (this.throwInterruptOnceOnEachStep && (this.executionInfo.size() - 1) % 2 == 0) {
                LOG.debug((Object)"THROW INTERRUPT");
                throw new InterruptedException("test interrupt");
            }
            switch (state) {
                case STATE_1: {
                    this.setNextState((Object)State.STATE_2);
                    break;
                }
                case STATE_2: {
                    this.setNextState((Object)State.STATE_3);
                    break;
                }
                case STATE_3: {
                    if (this.abortOnFinalStep) {
                        this.setFailure("test", new IOException("Requested abort on final step"));
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }

        protected void rollbackState(TestProcEnv env, State state) throws InterruptedException {
            long ts = env.nextTimestamp();
            LOG.debug((Object)(this.getProcId() + " rollback state " + (Object)((Object)state) + " ts=" + ts));
            this.executionInfo.add(new ExecutionInfo(ts, state, true));
            Thread.sleep(150L);
            if (this.throwInterruptOnceOnEachStep && (this.executionInfo.size() - 1) % 2 == 0) {
                LOG.debug((Object)"THROW INTERRUPT");
                throw new InterruptedException("test interrupt");
            }
            switch (state) {
                case STATE_1: {
                    break;
                }
                case STATE_2: {
                    break;
                }
                case STATE_3: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }

        protected State getState(int stateId) {
            return State.values()[stateId];
        }

        protected int getStateId(State state) {
            return state.ordinal();
        }

        protected State getInitialState() {
            return State.STATE_1;
        }

        protected boolean isYieldBeforeExecuteFromState(TestProcEnv env, State state) {
            return true;
        }

        protected boolean abort(TestProcEnv env) {
            this.aborted.set(true);
            return true;
        }

        public static class ExecutionInfo {
            private final boolean rollback;
            private final long timestamp;
            private final State step;

            public ExecutionInfo(long timestamp, State step, boolean isRollback) {
                this.timestamp = timestamp;
                this.step = step;
                this.rollback = isRollback;
            }

            public State getStep() {
                return this.step;
            }

            public long getTimestamp() {
                return this.timestamp;
            }

            public boolean isRollback() {
                return this.rollback;
            }
        }

        static enum State {
            STATE_1,
            STATE_2,
            STATE_3;

        }
    }

    private static class TestProcEnv {
        public final AtomicLong timestamp = new AtomicLong(0L);

        private TestProcEnv() {
        }

        public long nextTimestamp() {
            return this.timestamp.incrementAndGet();
        }
    }
}

