/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureTestingUtility;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.util.AbstractHBaseTool;

public class ProcedureWALLoaderPerformanceEvaluation
extends AbstractHBaseTool {
    protected static final HBaseCommonTestingUtility UTIL = new HBaseCommonTestingUtility();
    public static int DEFAULT_NUM_PROCS = 1000000;
    public static Option NUM_PROCS_OPTION = new Option("procs", true, "Total number of procedures. Default: " + DEFAULT_NUM_PROCS);
    public static int DEFAULT_NUM_WALS = 0;
    public static Option NUM_WALS_OPTION = new Option("wals", true, "Number of WALs to write. If -ve or 0, uses hbase.procedure.store.wal.roll.threshold conf to roll the logs. Default: " + DEFAULT_NUM_WALS);
    public static int DEFAULT_STATE_SIZE = 1024;
    public static Option STATE_SIZE_OPTION = new Option("size", true, "Size of serialized state in bytes to write on update. Default: " + DEFAULT_STATE_SIZE + " bytes");
    public static int DEFAULT_UPDATES_PER_PROC = 5;
    public static Option UPDATES_PER_PROC_OPTION = new Option("updates_per_proc", true, "Number of update states to write for each proc. Default: " + DEFAULT_UPDATES_PER_PROC);
    public static double DEFAULT_DELETE_PROCS_FRACTION = 0.5;
    public static Option DELETE_PROCS_FRACTION_OPTION = new Option("delete_procs_fraction", true, "Fraction of procs for which to write delete state. Distribution of procs chosen for delete is uniform across all procs. Default: " + DEFAULT_DELETE_PROCS_FRACTION);
    public int numProcs;
    public int updatesPerProc;
    public double deleteProcsFraction;
    public int numWals;
    private WALProcedureStore store;
    static byte[] serializedState;

    protected void addOptions() {
        this.addOption(NUM_PROCS_OPTION);
        this.addOption(UPDATES_PER_PROC_OPTION);
        this.addOption(DELETE_PROCS_FRACTION_OPTION);
        this.addOption(NUM_WALS_OPTION);
        this.addOption(STATE_SIZE_OPTION);
    }

    protected void processOptions(CommandLine cmd) {
        this.numProcs = this.getOptionAsInt(cmd, NUM_PROCS_OPTION.getOpt(), DEFAULT_NUM_PROCS);
        this.numWals = this.getOptionAsInt(cmd, NUM_WALS_OPTION.getOpt(), DEFAULT_NUM_WALS);
        int stateSize = this.getOptionAsInt(cmd, STATE_SIZE_OPTION.getOpt(), DEFAULT_STATE_SIZE);
        serializedState = new byte[stateSize];
        this.updatesPerProc = this.getOptionAsInt(cmd, UPDATES_PER_PROC_OPTION.getOpt(), DEFAULT_UPDATES_PER_PROC);
        this.deleteProcsFraction = this.getOptionAsDouble(cmd, DELETE_PROCS_FRACTION_OPTION.getOpt(), DEFAULT_DELETE_PROCS_FRACTION);
        this.setupConf();
    }

    private void setupConf() {
        if (this.numWals > 0) {
            this.conf.setLong("hbase.procedure.store.wal.roll.threshold", Long.MAX_VALUE);
        }
    }

    public void setUpProcedureStore() throws IOException {
        Path testDir = UTIL.getDataTestDir();
        FileSystem fs = testDir.getFileSystem(this.conf);
        Path logDir = new Path(testDir, "proc-logs");
        System.out.println("\n\nLogs directory : " + logDir.toString() + "\n\n");
        fs.delete(logDir, true);
        this.store = ProcedureTestingUtility.createWalStore(this.conf, logDir);
        this.store.start(1);
        this.store.recoverLease();
        this.store.load((ProcedureStore.ProcedureLoader)new LoadCounter());
    }

    private List<Integer> shuffleProcWriteSequence() {
        Random rand = new Random();
        ArrayList<Integer> procStatesSequence = new ArrayList<Integer>();
        HashSet<Integer> toBeDeletedProcs = new HashSet<Integer>();
        for (int procId = 1; procId <= this.numProcs; ++procId) {
            procStatesSequence.addAll(Collections.nCopies(this.updatesPerProc + 1, procId));
            if (!((double)rand.nextFloat() < this.deleteProcsFraction)) continue;
            procStatesSequence.add(procId);
            toBeDeletedProcs.add(procId);
        }
        Collections.shuffle(procStatesSequence);
        for (int i = procStatesSequence.size() - 1; i >= 0; --i) {
            int procId = (Integer)procStatesSequence.get(i);
            if (!toBeDeletedProcs.contains(procId)) continue;
            procStatesSequence.set(i, -1 * procId);
            toBeDeletedProcs.remove(procId);
        }
        return procStatesSequence;
    }

    private void writeWals() throws IOException {
        long startTime;
        List<Integer> procStates = this.shuffleProcWriteSequence();
        ProcedureTestingUtility.TestProcedure[] procs = new ProcedureTestingUtility.TestProcedure[this.numProcs + 1];
        int numProcsPerWal = this.numWals > 0 ? procStates.size() / this.numWals : Integer.MAX_VALUE;
        long lastTime = startTime = System.currentTimeMillis();
        for (int i = 0; i < procStates.size(); ++i) {
            int procId = procStates.get(i);
            if (procId < 0) {
                this.store.delete(procs[-procId].getProcId());
                procs[-procId] = null;
            } else if (procs[procId] == null) {
                procs[procId] = new ProcedureTestingUtility.TestProcedure(procId, 0L);
                procs[procId].setData(serializedState);
                this.store.insert((Procedure)procs[procId], null);
            } else {
                this.store.update((Procedure)procs[procId]);
            }
            if (i <= 0 || i % numProcsPerWal != 0) continue;
            long currentTime = System.currentTimeMillis();
            System.out.println("Forcing wall roll. Time taken on last WAL: " + (float)(currentTime - lastTime) / 1000.0f + " sec");
            this.store.rollWriterForTesting();
            lastTime = currentTime;
        }
        long timeTaken = System.currentTimeMillis() - startTime;
        System.out.println("\n\nDone writing WALs.\nNum procs : " + this.numProcs + "\nTotal time taken : " + StringUtils.humanTimeDiff((long)timeTaken) + "\n\n");
    }

    private void storeRestart(ProcedureStore.ProcedureLoader loader) throws IOException {
        System.out.println("Restarting procedure store to read back the WALs");
        this.store.stop(false);
        this.store.start(1);
        this.store.recoverLease();
        long startTime = System.currentTimeMillis();
        this.store.load(loader);
        long timeTaken = System.currentTimeMillis() - startTime;
        System.out.println("******************************************");
        System.out.println("Load time : " + (float)timeTaken / 1000.0f + "sec");
        System.out.println("******************************************");
    }

    public void tearDownProcedureStore() {
        this.store.stop(false);
        try {
            this.store.getFileSystem().delete(this.store.getWALDir(), true);
        }
        catch (IOException e) {
            System.err.println("Error: Couldn't delete log dir. You can delete it manually to free up disk space. Location: " + this.store.getWALDir().toString());
            System.err.println(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doWork() {
        try {
            this.setUpProcedureStore();
            this.writeWals();
            this.storeRestart(new LoadCounter());
            int n = 0;
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            this.tearDownProcedureStore();
        }
    }

    public static void main(String[] args) throws IOException {
        ProcedureWALLoaderPerformanceEvaluation tool = new ProcedureWALLoaderPerformanceEvaluation();
        tool.setConf(UTIL.getConfiguration());
        tool.run(args);
    }

    private static class LoadCounter
    implements ProcedureStore.ProcedureLoader {
        public void setMaxProcId(long maxProcId) {
        }

        public void load(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                ProcedureInfo procedureInfo;
                if (procIter.isNextCompleted()) {
                    procedureInfo = procIter.nextAsProcedureInfo();
                    continue;
                }
                procedureInfo = procIter.nextAsProcedure();
            }
        }

        public void handleCorrupted(ProcedureStore.ProcedureIterator procIter) throws IOException {
            while (procIter.hasNext()) {
                Procedure procedure = procIter.nextAsProcedure();
            }
        }
    }
}

