/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class SequentialProcedure<TEnvironment>
extends Procedure<TEnvironment> {
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure[] doExecute(TEnvironment env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        this.updateTimestamp();
        try {
            Procedure[] children = !this.executed ? this.execute(env) : null;
            this.executed = !this.executed;
            Procedure[] procedureArray = children;
            return procedureArray;
        }
        finally {
            this.updateTimestamp();
        }
    }

    @Override
    protected void doRollback(TEnvironment env) throws IOException, InterruptedException {
        this.updateTimestamp();
        if (this.executed) {
            try {
                this.rollback(env);
                this.executed = !this.executed;
            }
            finally {
                this.updateTimestamp();
            }
        }
    }

    @Override
    protected void serializeStateData(OutputStream stream) throws IOException {
        ProcedureProtos.SequentialProcedureData.Builder data = ProcedureProtos.SequentialProcedureData.newBuilder();
        data.setExecuted(this.executed);
        data.build().writeDelimitedTo(stream);
    }

    @Override
    protected void deserializeStateData(InputStream stream) throws IOException {
        ProcedureProtos.SequentialProcedureData data = ProcedureProtos.SequentialProcedureData.parseDelimitedFrom((InputStream)stream);
        this.executed = data.getExecuted();
    }
}

