/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.wal;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureUtil;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.procedure2.store.wal.CorruptedWALProcedureStoreException;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFile;
import org.apache.hadoop.hbase.procedure2.store.wal.ProcedureWALFormat;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class ProcedureWALFormatReader {
    private static final Log LOG = LogFactory.getLog(ProcedureWALFormatReader.class);
    private final WalProcedureMap localProcedureMap = new WalProcedureMap(1024);
    private final WalProcedureMap procedureMap = new WalProcedureMap(1024);
    private final ProcedureWALFormat.Loader loader;
    private final ProcedureStoreTracker tracker;
    private ProcedureStoreTracker localTracker;
    private long maxProcId = 0L;

    public ProcedureWALFormatReader(ProcedureStoreTracker tracker, ProcedureWALFormat.Loader loader) {
        this.tracker = tracker;
        this.loader = loader;
    }

    public void read(ProcedureWALFile log) throws IOException {
        ProcedureStoreTracker procedureStoreTracker = this.localTracker = log.getTracker().isPartial() ? log.getTracker() : null;
        if (this.localTracker != null) {
            LOG.info((Object)("Rebuilding tracker for " + log));
        }
        FSDataInputStream stream = log.getStream();
        try {
            boolean hasMore = true;
            block9: while (hasMore) {
                ProcedureProtos.ProcedureWALEntry entry = ProcedureWALFormat.readEntry((InputStream)stream);
                if (entry == null) {
                    LOG.warn((Object)("Nothing left to decode. Exiting with missing EOF, log=" + log));
                    break;
                }
                switch (entry.getType()) {
                    case PROCEDURE_WAL_INIT: {
                        this.readInitEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_INSERT: {
                        this.readInsertEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_UPDATE: 
                    case PROCEDURE_WAL_COMPACT: {
                        this.readUpdateEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_DELETE: {
                        this.readDeleteEntry(entry);
                        continue block9;
                    }
                    case PROCEDURE_WAL_EOF: {
                        hasMore = false;
                        continue block9;
                    }
                }
                throw new CorruptedWALProcedureStoreException("Invalid entry: " + entry);
            }
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)("While reading procedure from " + log), (Throwable)e);
            this.loader.markCorruptedWAL(log, (IOException)((Object)e));
        }
        if (this.localTracker != null) {
            this.localTracker.setPartialFlag(false);
        }
        if (!this.localProcedureMap.isEmpty()) {
            log.setProcIds(this.localProcedureMap.getMinProcId(), this.localProcedureMap.getMaxProcId());
            this.procedureMap.mergeTail(this.localProcedureMap);
        }
    }

    public void finish() throws IOException {
        this.loader.setMaxProcId(this.maxProcId);
        EntryIterator procIter = this.procedureMap.fetchReady();
        if (procIter != null) {
            this.loader.load(procIter);
        }
        if ((procIter = this.procedureMap.fetchAll()) != null) {
            this.loader.handleCorrupted(procIter);
        }
    }

    private void loadProcedure(ProcedureProtos.ProcedureWALEntry entry, ProcedureProtos.Procedure proc) {
        this.maxProcId = Math.max(this.maxProcId, proc.getProcId());
        if (this.isRequired(proc.getProcId())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Read " + entry.getType() + " entry " + proc.getProcId()));
            }
            this.localProcedureMap.add(proc);
            if (this.tracker.isPartial()) {
                this.tracker.insert(proc.getProcId());
            }
        }
        if (this.localTracker != null) {
            this.localTracker.insert(proc.getProcId());
        }
    }

    private void readInitEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadProcedure(entry, entry.getProcedure(0));
    }

    private void readInsertEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() >= 1) : "Expected one or more procedures";
        this.loadProcedure(entry, entry.getProcedure(0));
        for (int i = 1; i < entry.getProcedureCount(); ++i) {
            this.loadProcedure(entry, entry.getProcedure(i));
        }
    }

    private void readUpdateEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
        this.loadProcedure(entry, entry.getProcedure(0));
    }

    private void readDeleteEntry(ProcedureProtos.ProcedureWALEntry entry) throws IOException {
        assert (entry.hasProcId()) : "expected ProcID";
        if (entry.getChildIdCount() > 0) {
            assert (entry.getProcedureCount() == 1) : "Expected only one procedure";
            this.loadProcedure(entry, entry.getProcedure(0));
            int count = entry.getChildIdCount();
            for (int i = 0; i < count; ++i) {
                this.deleteEntry(entry.getChildId(i));
            }
        } else {
            assert (entry.getProcedureCount() == 0) : "Expected no procedures";
            this.deleteEntry(entry.getProcId());
        }
    }

    private void deleteEntry(long procId) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("delete entry " + procId));
        }
        this.maxProcId = Math.max(this.maxProcId, procId);
        this.localProcedureMap.remove(procId);
        assert (!this.procedureMap.contains(procId));
        if (this.tracker.isPartial()) {
            this.tracker.setDeleted(procId, true);
        }
        if (this.localTracker != null) {
            this.localTracker.setDeleted(procId, true);
        }
    }

    private boolean isDeleted(long procId) {
        return this.tracker.isDeleted(procId) == ProcedureStoreTracker.DeleteState.YES;
    }

    private boolean isRequired(long procId) {
        return !this.isDeleted(procId) && !this.procedureMap.contains(procId);
    }

    private static class WalProcedureMap {
        private Entry[] procedureMap;
        private Entry replayOrderHead;
        private Entry replayOrderTail;
        private Entry rootHead;
        private Entry childUnlinkedHead;
        private long minProcId = Long.MAX_VALUE;
        private long maxProcId = Long.MIN_VALUE;

        public WalProcedureMap(int size) {
            this.procedureMap = new Entry[size];
            this.replayOrderHead = null;
            this.replayOrderTail = null;
            this.rootHead = null;
            this.childUnlinkedHead = null;
        }

        public void add(ProcedureProtos.Procedure procProto) {
            this.trackProcIds(procProto.getProcId());
            Entry entry = this.addToMap(procProto.getProcId(), procProto.hasParentId());
            boolean isNew = entry.proto == null;
            entry.proto = procProto;
            this.addToReplayList(entry);
            if (isNew) {
                if (procProto.hasParentId()) {
                    this.childUnlinkedHead = this.addToLinkList(entry, this.childUnlinkedHead);
                } else {
                    this.rootHead = this.addToLinkList(entry, this.rootHead);
                }
            }
        }

        public boolean remove(long procId) {
            this.trackProcIds(procId);
            Entry entry = this.removeFromMap(procId);
            if (entry != null) {
                this.unlinkFromReplayList(entry);
                this.unlinkFromLinkList(entry);
                return true;
            }
            return false;
        }

        private void trackProcIds(long procId) {
            this.minProcId = Math.min(this.minProcId, procId);
            this.maxProcId = Math.max(this.maxProcId, procId);
        }

        public long getMinProcId() {
            return this.minProcId;
        }

        public long getMaxProcId() {
            return this.maxProcId;
        }

        public boolean contains(long procId) {
            return this.getProcedure(procId) != null;
        }

        public boolean isEmpty() {
            return this.replayOrderHead == null;
        }

        public void clear() {
            for (int i = 0; i < this.procedureMap.length; ++i) {
                this.procedureMap[i] = null;
            }
            this.replayOrderHead = null;
            this.replayOrderTail = null;
            this.rootHead = null;
            this.childUnlinkedHead = null;
            this.minProcId = Long.MAX_VALUE;
            this.maxProcId = Long.MIN_VALUE;
        }

        public void mergeTail(WalProcedureMap other) {
            Entry p = other.replayOrderHead;
            while (p != null) {
                int slotIndex = this.getMapSlot(p.getProcId());
                p.hashNext = this.procedureMap[slotIndex];
                this.procedureMap[slotIndex] = p;
                p = p.replayNext;
            }
            if (this.replayOrderHead == null) {
                this.replayOrderHead = other.replayOrderHead;
                this.replayOrderTail = other.replayOrderTail;
                this.rootHead = other.rootHead;
                this.childUnlinkedHead = other.childUnlinkedHead;
            } else {
                Entry otherTail;
                assert (this.replayOrderTail.replayNext == null);
                assert (other.replayOrderHead.replayPrev == null);
                this.replayOrderTail.replayNext = other.replayOrderHead;
                other.replayOrderHead.replayPrev = this.replayOrderTail;
                this.replayOrderTail = other.replayOrderTail;
                if (this.rootHead == null) {
                    this.rootHead = other.rootHead;
                } else if (other.rootHead != null) {
                    otherTail = this.findLinkListTail(other.rootHead);
                    otherTail.linkNext = this.rootHead;
                    this.rootHead.linkPrev = otherTail;
                    this.rootHead = other.rootHead;
                }
                if (this.childUnlinkedHead == null) {
                    this.childUnlinkedHead = other.childUnlinkedHead;
                } else if (other.childUnlinkedHead != null) {
                    otherTail = this.findLinkListTail(other.childUnlinkedHead);
                    otherTail.linkNext = this.childUnlinkedHead;
                    this.childUnlinkedHead.linkPrev = otherTail;
                    this.childUnlinkedHead = other.childUnlinkedHead;
                }
            }
            this.maxProcId = Math.max(this.maxProcId, other.maxProcId);
            this.minProcId = Math.max(this.minProcId, other.minProcId);
            other.clear();
        }

        public EntryIterator fetchReady() {
            this.buildGraph();
            Entry readyHead = null;
            Entry readyTail = null;
            Entry p = this.replayOrderHead;
            while (p != null) {
                Entry next = p.replayNext;
                if (p.isReady()) {
                    this.unlinkFromReplayList(p);
                    if (readyTail != null) {
                        readyTail.replayNext = p;
                        p.replayPrev = readyTail;
                    } else {
                        p.replayPrev = null;
                        readyHead = p;
                    }
                    readyTail = p;
                    p.replayNext = null;
                }
                p = next;
            }
            p = readyHead;
            while (p != null) {
                this.removeFromMap(p.getProcId());
                this.unlinkFromLinkList(p);
                p = p.replayNext;
            }
            return readyHead != null ? new EntryIterator(readyHead) : null;
        }

        public EntryIterator fetchAll() {
            Entry head;
            Entry p = head = this.replayOrderHead;
            while (p != null) {
                this.removeFromMap(p.getProcId());
                p = p.replayNext;
            }
            for (int i = 0; i < this.procedureMap.length; ++i) {
                assert (this.procedureMap[i] == null) : "map not empty i=" + i;
            }
            this.replayOrderHead = null;
            this.replayOrderTail = null;
            this.childUnlinkedHead = null;
            this.rootHead = null;
            return head != null ? new EntryIterator(head) : null;
        }

        private void buildGraph() {
            Entry p = this.childUnlinkedHead;
            while (p != null) {
                Entry next = p.linkNext;
                Entry rootProc = this.getRootProcedure(p);
                if (rootProc != null) {
                    rootProc.childHead = this.addToLinkList(p, rootProc.childHead);
                }
                p = next;
            }
            p = this.rootHead;
            while (p != null) {
                this.checkReadyToRun(p);
                p = p.linkNext;
            }
        }

        private Entry getRootProcedure(Entry entry) {
            while (entry != null && entry.hasParent()) {
                entry = this.getProcedure(entry.getParentId());
            }
            return entry;
        }

        private boolean checkReadyToRun(Entry rootEntry) {
            assert (!rootEntry.hasParent()) : "expected root procedure, got " + rootEntry;
            if (rootEntry.isFinished()) {
                if (rootEntry.childHead != null) {
                    LOG.error((Object)("unexpected active children for root-procedure: " + rootEntry));
                    Entry p = rootEntry.childHead;
                    while (p != null) {
                        LOG.error((Object)("unexpected active children: " + p));
                        p = p.linkNext;
                    }
                }
                assert (rootEntry.childHead == null) : "unexpected children on root completion. " + rootEntry;
                rootEntry.ready = true;
                return true;
            }
            int stackIdSum = 0;
            int maxStackId = 0;
            for (int i = 0; i < rootEntry.proto.getStackIdCount(); ++i) {
                int stackId = 1 + rootEntry.proto.getStackId(i);
                maxStackId = Math.max(maxStackId, stackId);
                stackIdSum += stackId;
            }
            Entry p = rootEntry.childHead;
            while (p != null) {
                for (int i = 0; i < p.proto.getStackIdCount(); ++i) {
                    int stackId = 1 + p.proto.getStackId(i);
                    maxStackId = Math.max(maxStackId, stackId);
                    stackIdSum += stackId;
                }
                p = p.linkNext;
            }
            int cmpStackIdSum = maxStackId * (maxStackId + 1) / 2;
            if (cmpStackIdSum == stackIdSum) {
                rootEntry.ready = true;
                Entry p2 = rootEntry.childHead;
                while (p2 != null) {
                    p2.ready = true;
                    p2 = p2.linkNext;
                }
                return true;
            }
            return false;
        }

        private void unlinkFromReplayList(Entry entry) {
            if (this.replayOrderHead == entry) {
                this.replayOrderHead = entry.replayNext;
            }
            if (this.replayOrderTail == entry) {
                this.replayOrderTail = entry.replayPrev;
            }
            if (entry.replayPrev != null) {
                entry.replayPrev.replayNext = entry.replayNext;
            }
            if (entry.replayNext != null) {
                entry.replayNext.replayPrev = entry.replayPrev;
            }
        }

        private void addToReplayList(Entry entry) {
            this.unlinkFromReplayList(entry);
            entry.replayNext = this.replayOrderHead;
            entry.replayPrev = null;
            if (this.replayOrderHead != null) {
                this.replayOrderHead.replayPrev = entry;
            } else {
                this.replayOrderTail = entry;
            }
            this.replayOrderHead = entry;
        }

        private void unlinkFromLinkList(Entry entry) {
            if (entry == this.rootHead) {
                this.rootHead = entry.linkNext;
            } else if (entry == this.childUnlinkedHead) {
                this.childUnlinkedHead = entry.linkNext;
            }
            if (entry.linkPrev != null) {
                entry.linkPrev.linkNext = entry.linkNext;
            }
            if (entry.linkNext != null) {
                entry.linkNext.linkPrev = entry.linkPrev;
            }
        }

        private Entry addToLinkList(Entry entry, Entry linkHead) {
            this.unlinkFromLinkList(entry);
            entry.linkNext = linkHead;
            entry.linkPrev = null;
            if (linkHead != null) {
                linkHead.linkPrev = entry;
            }
            return entry;
        }

        private Entry findLinkListTail(Entry linkHead) {
            Entry tail = linkHead;
            while (tail.linkNext != null) {
                tail = tail.linkNext;
            }
            return tail;
        }

        private Entry addToMap(long procId, boolean hasParent) {
            int slotIndex = this.getMapSlot(procId);
            Entry entry = this.getProcedure(slotIndex, procId);
            if (entry != null) {
                return entry;
            }
            this.procedureMap[slotIndex] = entry = new Entry(this.procedureMap[slotIndex]);
            return entry;
        }

        private Entry removeFromMap(long procId) {
            int slotIndex = this.getMapSlot(procId);
            Entry prev = null;
            Entry entry = this.procedureMap[slotIndex];
            while (entry != null) {
                if (procId == entry.getProcId()) {
                    if (prev != null) {
                        prev.hashNext = entry.hashNext;
                    } else {
                        this.procedureMap[slotIndex] = entry.hashNext;
                    }
                    entry.hashNext = null;
                    return entry;
                }
                prev = entry;
                entry = entry.hashNext;
            }
            return null;
        }

        private Entry getProcedure(long procId) {
            return this.getProcedure(this.getMapSlot(procId), procId);
        }

        private Entry getProcedure(int slotIndex, long procId) {
            Entry entry = this.procedureMap[slotIndex];
            while (entry != null) {
                if (procId == entry.getProcId()) {
                    return entry;
                }
                entry = entry.hashNext;
            }
            return null;
        }

        private int getMapSlot(long procId) {
            return (int)(Procedure.getProcIdHashCode(procId) % (long)this.procedureMap.length);
        }
    }

    private static class EntryIterator
    implements ProcedureStore.ProcedureIterator {
        private final Entry replayHead;
        private Entry current;

        public EntryIterator(Entry replayHead) {
            this.replayHead = replayHead;
            this.current = replayHead;
        }

        @Override
        public void reset() {
            this.current = this.replayHead;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public boolean isNextFinished() {
            return this.current != null && this.current.isFinished();
        }

        @Override
        public void skipNext() {
            this.current = this.current.replayNext;
        }

        @Override
        public Procedure nextAsProcedure() throws IOException {
            try {
                Procedure procedure = this.current.convert();
                return procedure;
            }
            finally {
                this.current = this.current.replayNext;
            }
        }

        @Override
        public ProcedureInfo nextAsProcedureInfo() {
            try {
                ProcedureInfo procedureInfo = this.current.convertToInfo();
                return procedureInfo;
            }
            finally {
                this.current = this.current.replayNext;
            }
        }
    }

    private static class Entry {
        protected Entry hashNext;
        protected Entry childHead;
        protected Entry linkNext;
        protected Entry linkPrev;
        protected Entry replayNext;
        protected Entry replayPrev;
        protected Procedure procedure;
        protected ProcedureProtos.Procedure proto;
        protected boolean ready = false;

        public Entry(Entry hashNext) {
            this.hashNext = hashNext;
        }

        public long getProcId() {
            return this.proto.getProcId();
        }

        public long getParentId() {
            return this.proto.getParentId();
        }

        public boolean hasParent() {
            return this.proto.hasParentId();
        }

        public boolean isReady() {
            return this.ready;
        }

        public boolean isFinished() {
            if (!this.hasParent()) {
                switch (this.proto.getState()) {
                    case ROLLEDBACK: 
                    case SUCCESS: {
                        return true;
                    }
                }
            }
            return false;
        }

        public Procedure convert() throws IOException {
            if (this.procedure == null) {
                this.procedure = ProcedureUtil.convertToProcedure(this.proto);
            }
            return this.procedure;
        }

        public ProcedureInfo convertToInfo() {
            return ProcedureUtil.convertToProcedureInfo(this.proto);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Entry(");
            sb.append(this.getProcId());
            sb.append(", parentId=");
            sb.append(this.getParentId());
            sb.append(", class=");
            sb.append(this.proto.getClassName());
            sb.append(")");
            return sb.toString();
        }
    }
}

