/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hadoop.hbase.procedure2.LockInfo;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureDeque;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SimpleProcedureScheduler
extends AbstractProcedureScheduler {
    private final ProcedureDeque runnables = new ProcedureDeque();

    @Override
    protected void enqueue(Procedure procedure, boolean addFront) {
        if (addFront) {
            this.runnables.addFirst(procedure);
        } else {
            this.runnables.addLast(procedure);
        }
    }

    @Override
    protected Procedure dequeue() {
        return (Procedure)this.runnables.poll();
    }

    @Override
    @VisibleForTesting
    public void clear() {
        this.schedLock();
        try {
            this.runnables.clear();
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void yield(Procedure proc) {
        this.addBack(proc);
    }

    @Override
    public boolean queueHasRunnables() {
        return this.runnables.size() > 0;
    }

    @Override
    public int queueSize() {
        return this.runnables.size();
    }

    @Override
    public void completionCleanup(Procedure proc) {
    }

    @Override
    public List<LockInfo> listLocks() {
        return Collections.emptyList();
    }

    @Override
    public LockInfo getLockInfoForResource(LockInfo.ResourceType resourceType, String resourceName) {
        return null;
    }
}

