/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hbase.procedure2.LockAndQueue;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.ProcedureScheduler;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AbstractProcedureScheduler
implements ProcedureScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProcedureScheduler.class);
    private final ReentrantLock schedulerLock = new ReentrantLock();
    private final Condition schedWaitCond = this.schedulerLock.newCondition();
    private boolean running = false;
    private long pollCalls = 0L;
    private long nullPollCalls = 0L;

    @Override
    public void start() {
        this.schedLock();
        try {
            this.running = true;
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void stop() {
        this.schedLock();
        try {
            this.running = false;
            this.schedWaitCond.signalAll();
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void signalAll() {
        this.schedLock();
        try {
            this.schedWaitCond.signalAll();
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract void enqueue(Procedure var1, boolean var2);

    @Override
    public void addFront(Procedure procedure) {
        this.push(procedure, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFront(Iterator<Procedure> procedureIterator) {
        this.schedLock();
        try {
            int count = 0;
            while (procedureIterator.hasNext()) {
                Procedure procedure = procedureIterator.next();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Wake " + procedure);
                }
                this.push(procedure, true, false);
                ++count;
            }
            this.wakePollIfNeeded(count);
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public void addBack(Procedure procedure) {
        this.push(procedure, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void push(Procedure procedure, boolean addFront, boolean notify) {
        this.schedLock();
        try {
            this.enqueue(procedure, addFront);
            if (notify) {
                this.schedWaitCond.signal();
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract Procedure dequeue();

    @Override
    public Procedure poll() {
        return this.poll(-1L);
    }

    @Override
    public Procedure poll(long timeout, TimeUnit unit) {
        return this.poll(unit.toNanos(timeout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    public Procedure poll(long nanos) {
        this.schedLock();
        try {
            if (!this.running) {
                LOG.debug("the scheduler is not running");
                Procedure procedure = null;
                return procedure;
            }
            if (!this.queueHasRunnables()) {
                if (nanos < 0L) {
                    this.schedWaitCond.await();
                } else {
                    this.schedWaitCond.awaitNanos(nanos);
                }
                if (!this.queueHasRunnables()) {
                    ++this.nullPollCalls;
                    Procedure procedure = null;
                    return procedure;
                }
            }
            Procedure pollResult = this.dequeue();
            ++this.pollCalls;
            this.nullPollCalls += pollResult == null ? 1L : 0L;
            Procedure procedure = pollResult;
            return procedure;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ++this.nullPollCalls;
            Procedure procedure = null;
            return procedure;
        }
        finally {
            this.schedUnlock();
        }
    }

    protected abstract int queueSize();

    protected abstract boolean queueHasRunnables();

    @Override
    public int size() {
        this.schedLock();
        try {
            int n = this.queueSize();
            return n;
        }
        finally {
            this.schedUnlock();
        }
    }

    @Override
    public boolean hasRunnables() {
        this.schedLock();
        try {
            boolean bl = this.queueHasRunnables();
            return bl;
        }
        finally {
            this.schedUnlock();
        }
    }

    public long getPollCalls() {
        return this.pollCalls;
    }

    public long getNullPollCalls() {
        return this.nullPollCalls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void wakeEvents(ProcedureEvent[] events) {
        this.schedLock();
        try {
            for (ProcedureEvent event : events) {
                if (event == null) continue;
                event.wakeInternal(this);
            }
        }
        finally {
            this.schedUnlock();
        }
    }

    protected int wakeWaitingProcedures(LockAndQueue lockAndQueue) {
        return lockAndQueue.wakeWaitingProcedures(this);
    }

    protected void waitProcedure(LockAndQueue lockAndQueue, Procedure proc) {
        lockAndQueue.addLast(proc);
    }

    protected void wakeProcedure(Procedure procedure) {
        LOG.trace("Wake {}", (Object)procedure);
        this.push(procedure, true, false);
    }

    protected void schedLock() {
        this.schedulerLock.lock();
    }

    protected void schedUnlock() {
        this.schedulerLock.unlock();
    }

    protected void wakePollIfNeeded(int waitingCount) {
        if (waitingCount <= 0) {
            return;
        }
        if (waitingCount == 1) {
            this.schedWaitCond.signal();
        } else {
            this.schedWaitCond.signalAll();
        }
    }
}

