/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, SmallTests.class})
public class TestProcedureToString {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureToString.class);

    @Test
    public void testBasicToString() throws ProcedureYieldException, InterruptedException {
        BasicProcedure p = new BasicProcedure();
        ProcedureProtos.ProcedureState state = ProcedureProtos.ProcedureState.RUNNABLE;
        p.setState(state);
        Assert.assertTrue((boolean)p.toString().contains(state.toString()));
        p = new DoublingStateStringBasicProcedure();
        p.setState(state);
        String testStr = state.toString() + state.toString();
        Assert.assertTrue((boolean)p.toString().contains(testStr));
    }

    @Test
    public void testStateMachineProcedure() {
        SimpleStateMachineProcedure p = new SimpleStateMachineProcedure();
        ProcedureProtos.ProcedureState state = ProcedureProtos.ProcedureState.RUNNABLE;
        p.setState(state);
        p.setNextState(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN);
        Assert.assertTrue((boolean)p.toString().contains(state.toString()));
        Assert.assertTrue((boolean)p.toString().contains(MasterProcedureProtos.ServerCrashState.SERVER_CRASH_ASSIGN.toString()));
    }

    static class SimpleStateMachineProcedure
    extends StateMachineProcedure<BasicProcedureEnv, MasterProcedureProtos.ServerCrashState> {
        SimpleStateMachineProcedure() {
        }

        protected StateMachineProcedure.Flow executeFromState(BasicProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws ProcedureYieldException, InterruptedException {
            return null;
        }

        protected void rollbackState(BasicProcedureEnv env, MasterProcedureProtos.ServerCrashState state) throws IOException, InterruptedException {
        }

        protected MasterProcedureProtos.ServerCrashState getState(int stateId) {
            return MasterProcedureProtos.ServerCrashState.valueOf((int)stateId);
        }

        protected int getStateId(MasterProcedureProtos.ServerCrashState state) {
            return state.getNumber();
        }

        protected MasterProcedureProtos.ServerCrashState getInitialState() {
            return null;
        }

        protected boolean abort(BasicProcedureEnv env) {
            return false;
        }
    }

    static class DoublingStateStringBasicProcedure
    extends BasicProcedure {
        DoublingStateStringBasicProcedure() {
        }

        protected void toStringState(StringBuilder builder) {
            super.toStringState(builder);
            super.toStringState(builder);
        }
    }

    static class BasicProcedure
    extends Procedure<BasicProcedureEnv> {
        BasicProcedure() {
        }

        protected Procedure<BasicProcedureEnv>[] execute(BasicProcedureEnv env) throws ProcedureYieldException, InterruptedException {
            return new Procedure[]{this};
        }

        protected void rollback(BasicProcedureEnv env) throws IOException, InterruptedException {
        }

        protected boolean abort(BasicProcedureEnv env) {
            return false;
        }

        protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }

        protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        }
    }

    static class BasicProcedureEnv {
        BasicProcedureEnv() {
        }
    }
}

