/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store;

import java.util.Random;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStoreTracker;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestProcedureStoreTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestProcedureStoreTracker.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestProcedureStoreTracker.class);

    @Test
    public void testSeqInsertAndDelete() {
        int j;
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Assert.assertTrue((boolean)tracker.isEmpty());
        boolean MIN_PROC = true;
        int MAX_PROC = 1024;
        for (i = 1; i < 1024; ++i) {
            tracker.insert((long)i);
            for (j = 1; j <= i; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)j));
            }
            for (j = i + 1; j < 1024; ++j) {
                Assert.assertTrue((tracker.isDeleted((long)j) != ProcedureStoreTracker.DeleteState.NO ? 1 : 0) != 0);
            }
        }
        for (i = 1; i < 1024; ++i) {
            tracker.delete((long)i);
            for (j = 1; j <= i; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted((long)j));
            }
            for (j = i + 1; j < 1024; ++j) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)j));
            }
        }
        Assert.assertTrue((boolean)tracker.isEmpty());
    }

    @Test
    public void testPartialTracker() {
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        tracker.setPartialFlag(true);
        Assert.assertTrue((boolean)tracker.isEmpty());
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(579L));
        tracker.setDeleted(1L, true);
        tracker.dump();
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(2L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(579L));
        tracker.setDeleted(579L, false);
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted(1L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(2L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted(579L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(577L));
        Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.MAYBE, (Object)tracker.isDeleted(580L));
        tracker.setDeleted(579L, true);
        tracker.setPartialFlag(false);
        Assert.assertTrue((boolean)tracker.isEmpty());
    }

    @Test
    public void testBasicCRUD() {
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Assert.assertTrue((boolean)tracker.isEmpty());
        long[] procs = new long[]{1L, 2L, 3L, 4L, 5L, 6L};
        tracker.insert(procs[0]);
        tracker.insert(procs[1], new long[]{procs[2], procs[3], procs[4]});
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        tracker.resetUpdates();
        Assert.assertFalse((boolean)tracker.isUpdated());
        for (i = 0; i < 4; ++i) {
            tracker.update(procs[i]);
            Assert.assertFalse((boolean)tracker.isEmpty());
            Assert.assertFalse((boolean)tracker.isUpdated());
        }
        tracker.update(procs[4]);
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        tracker.update(procs[5]);
        Assert.assertFalse((boolean)tracker.isEmpty());
        Assert.assertTrue((boolean)tracker.isUpdated());
        for (i = 0; i < 5; ++i) {
            tracker.delete(procs[i]);
            Assert.assertFalse((boolean)tracker.isEmpty());
            Assert.assertTrue((boolean)tracker.isUpdated());
        }
        tracker.delete(procs[5]);
        Assert.assertTrue((boolean)tracker.isEmpty());
    }

    @Test
    public void testRandLoad() {
        int NPROCEDURES = 2500;
        int NRUNS = 5000;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        Random rand = new Random(1L);
        for (int i = 0; i < 5000; ++i) {
            Assert.assertTrue((boolean)tracker.isEmpty());
            int count = 0;
            while (count < 2500) {
                long procId = rand.nextLong();
                if (procId < 1L) continue;
                tracker.setDeleted(procId, i % 2 == 0);
                ++count;
            }
            tracker.reset();
        }
    }

    @Test
    public void testLoad() {
        int MAX_PROCS = 1000;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        for (int numProcs = 1; numProcs < 1000; ++numProcs) {
            for (int start = 1; start <= numProcs; ++start) {
                int i;
                Assert.assertTrue((boolean)tracker.isEmpty());
                LOG.debug("loading " + numProcs + " procs from start=" + start);
                for (i = start; i <= numProcs; ++i) {
                    tracker.setDeleted((long)i, false);
                }
                for (i = 1; i < start; ++i) {
                    tracker.setDeleted((long)i, false);
                }
                tracker.reset();
            }
        }
    }

    @Test
    public void testDelete() {
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        long[] procIds = new long[]{65L, 1L, 193L};
        for (i = 0; i < procIds.length; ++i) {
            tracker.insert(procIds[i]);
            tracker.dump();
        }
        for (i = 0; i < 256; ++i) {
            boolean hasProc = false;
            for (int j = 0; j < procIds.length; ++j) {
                if (procIds[j] != (long)i) continue;
                hasProc = true;
                break;
            }
            if (hasProc) {
                Assert.assertEquals((Object)ProcedureStoreTracker.DeleteState.NO, (Object)tracker.isDeleted((long)i));
                continue;
            }
            Assert.assertEquals((String)("procId=" + i), (Object)ProcedureStoreTracker.DeleteState.YES, (Object)tracker.isDeleted((long)i));
        }
    }

    boolean isDeleted(ProcedureStoreTracker n, long procId) {
        return n.isDeleted(procId) == ProcedureStoreTracker.DeleteState.YES;
    }

    boolean isDeleted(ProcedureStoreTracker.BitSetNode n, long procId) {
        return n.isDeleted(procId) == ProcedureStoreTracker.DeleteState.YES;
    }

    ProcedureStoreTracker buildTracker(long[] active, long[] updated, long[] deleted) {
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        for (long i : active) {
            tracker.insert(i);
        }
        tracker.resetUpdates();
        for (long i : updated) {
            tracker.update(i);
        }
        for (long i : deleted) {
            tracker.delete(i);
        }
        return tracker;
    }

    ProcedureStoreTracker.BitSetNode buildBitSetNode(long[] active, long[] updated, long[] deleted) {
        ProcedureStoreTracker.BitSetNode bitSetNode = new ProcedureStoreTracker.BitSetNode(0L, false);
        for (long i : active) {
            bitSetNode.update(i);
        }
        bitSetNode.resetUpdates();
        for (long i : updated) {
            bitSetNode.update(i);
        }
        for (long i : deleted) {
            bitSetNode.delete(i);
        }
        return bitSetNode;
    }

    @Test
    public void testSetDeletedIfSet() {
        int i;
        ProcedureStoreTracker tracker = new ProcedureStoreTracker();
        long[] procIds = new long[]{1L, 3L, 7L, 152L, 512L, 1024L, 1025L};
        for (i = 0; i < procIds.length; ++i) {
            tracker.insert(procIds[i]);
        }
        Assert.assertEquals((Object)false, (Object)tracker.isEmpty());
        for (i = 0; i < procIds.length; ++i) {
            tracker.setDeletedIfSet(new long[]{procIds[i] - 1L});
            tracker.setDeletedIfSet(new long[]{procIds[i]});
            tracker.setDeletedIfSet(new long[]{procIds[i] + 1L});
        }
        Assert.assertEquals((Object)true, (Object)tracker.isEmpty());
        tracker.reset();
        for (i = 0; i < procIds.length; ++i) {
            tracker.insert(procIds[i]);
        }
        Assert.assertEquals((Object)false, (Object)tracker.isEmpty());
        tracker.setDeletedIfSet(procIds);
        Assert.assertEquals((Object)true, (Object)tracker.isEmpty());
    }
}

