/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public abstract class StateMachineProcedure<TEnvironment, TState>
extends Procedure<TEnvironment> {
    private static final Logger LOG = LoggerFactory.getLogger(StateMachineProcedure.class);
    private static final int EOF_STATE = Integer.MIN_VALUE;
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private Flow stateFlow = Flow.HAS_MORE_STATE;
    protected int stateCount = 0;
    private int[] states = null;
    private List<Procedure<TEnvironment>> subProcList = null;
    private int cycles = 0;
    private int previousState;

    protected final int getCycles() {
        return this.cycles;
    }

    protected abstract Flow executeFromState(TEnvironment var1, TState var2) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException;

    protected abstract void rollbackState(TEnvironment var1, TState var2) throws IOException, InterruptedException;

    protected abstract TState getState(int var1);

    protected abstract int getStateId(TState var1);

    protected abstract TState getInitialState();

    protected void setNextState(TState state) {
        this.setNextState(this.getStateId(state));
        this.failIfAborted();
    }

    protected boolean isYieldBeforeExecuteFromState(TEnvironment env, TState state) {
        return false;
    }

    protected <T extends Procedure<TEnvironment>> void addChildProcedure(T ... subProcedure) {
        if (subProcedure == null) {
            return;
        }
        int len = subProcedure.length;
        if (len == 0) {
            return;
        }
        if (this.subProcList == null) {
            this.subProcList = new ArrayList<Procedure<TEnvironment>>(len);
        }
        for (int i = 0; i < len; ++i) {
            T proc = subProcedure[i];
            if (!((Procedure)proc).hasOwner()) {
                ((Procedure)proc).setOwner(this.getOwner());
            }
            this.subProcList.add((Procedure<TEnvironment>)proc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Procedure[] execute(TEnvironment env) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        this.updateTimestamp();
        try {
            Procedure[] procedureArray;
            this.failIfAborted();
            if (!this.hasMoreState() || this.isFailed()) {
                Procedure[] procedureArray2 = null;
                return procedureArray2;
            }
            TState state = this.getCurrentState();
            if (this.stateCount == 0) {
                this.setNextState(this.getStateId(state));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace(state + " " + this + "; cycles=" + this.cycles);
            }
            if (this.getStateId(state) != this.previousState) {
                this.previousState = this.getStateId(state);
                this.cycles = 0;
            } else {
                ++this.cycles;
            }
            LOG.trace("{}", (Object)this);
            this.stateFlow = this.executeFromState(env, state);
            if (!this.hasMoreState()) {
                this.setNextState(Integer.MIN_VALUE);
            }
            if (this.subProcList != null && !this.subProcList.isEmpty()) {
                Procedure[] subProcedures = this.subProcList.toArray(new Procedure[this.subProcList.size()]);
                this.subProcList = null;
                Procedure[] procedureArray3 = subProcedures;
                return procedureArray3;
            }
            if (this.isWaiting() || this.isFailed() || !this.hasMoreState()) {
                procedureArray = null;
            } else {
                Procedure[] procedureArray4 = new Procedure[1];
                procedureArray = procedureArray4;
                procedureArray4[0] = this;
            }
            Procedure[] procedureArray5 = procedureArray;
            return procedureArray5;
        }
        finally {
            this.updateTimestamp();
        }
    }

    @Override
    protected void rollback(TEnvironment env) throws IOException, InterruptedException {
        if (this.isEofState()) {
            --this.stateCount;
        }
        try {
            this.updateTimestamp();
            this.rollbackState(env, this.getCurrentState());
        }
        finally {
            --this.stateCount;
            this.updateTimestamp();
        }
    }

    protected boolean isEofState() {
        return this.stateCount > 0 && this.states[this.stateCount - 1] == Integer.MIN_VALUE;
    }

    @Override
    protected boolean abort(TEnvironment env) {
        LOG.debug("Abort requested for {}", (Object)this);
        if (!this.hasMoreState()) {
            LOG.warn("Ignore abort request on {} because it has already been finished", (Object)this);
            return false;
        }
        if (!this.isRollbackSupported(this.getCurrentState())) {
            LOG.warn("Ignore abort request on {} because it does not support rollback", (Object)this);
            return false;
        }
        this.aborted.set(true);
        return true;
    }

    protected final void failIfAborted() {
        if (this.aborted.get()) {
            if (this.hasMoreState()) {
                this.setAbortFailure(this.getClass().getSimpleName(), "abort requested");
            } else {
                LOG.warn("Ignoring abort request on state='" + this.getCurrentState() + "' for " + this);
            }
        }
    }

    protected boolean isRollbackSupported(TState state) {
        return false;
    }

    @Override
    protected boolean isYieldAfterExecutionStep(TEnvironment env) {
        return this.isYieldBeforeExecuteFromState(env, this.getCurrentState());
    }

    private boolean hasMoreState() {
        return this.stateFlow != Flow.NO_MORE_STATE;
    }

    protected TState getCurrentState() {
        return this.stateCount > 0 ? this.getState(this.states[this.stateCount - 1]) : this.getInitialState();
    }

    @VisibleForTesting
    public int getCurrentStateId() {
        return this.getStateId(this.getCurrentState());
    }

    private void setNextState(int stateId) {
        if (this.states == null || this.states.length == this.stateCount) {
            int newCapacity = this.stateCount + 8;
            this.states = this.states != null ? Arrays.copyOf(this.states, newCapacity) : new int[newCapacity];
        }
        this.states[this.stateCount++] = stateId;
    }

    @Override
    protected void toStringState(StringBuilder builder) {
        super.toStringState(builder);
        if (!this.isFinished() && !this.isEofState() && this.getCurrentState() != null) {
            builder.append(":").append(this.getCurrentState());
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        ProcedureProtos.StateMachineProcedureData.Builder data = ProcedureProtos.StateMachineProcedureData.newBuilder();
        for (int i = 0; i < this.stateCount; ++i) {
            data.addState(this.states[i]);
        }
        serializer.serialize((Message)data.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        ProcedureProtos.StateMachineProcedureData data = serializer.deserialize(ProcedureProtos.StateMachineProcedureData.class);
        this.stateCount = data.getStateCount();
        if (this.stateCount > 0) {
            this.states = new int[this.stateCount];
            for (int i = 0; i < this.stateCount; ++i) {
                this.states[i] = data.getState(i);
            }
            if (this.isEofState()) {
                this.stateFlow = Flow.NO_MORE_STATE;
            }
        } else {
            this.states = null;
        }
    }

    @VisibleForTesting
    public static enum Flow {
        HAS_MORE_STATE,
        NO_MORE_STATE;

    }
}

