/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.procedure2.ProcedureAbortedException;
import org.apache.hadoop.hbase.procedure2.ProcedureMetrics;
import org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hadoop.hbase.procedure2.RemoteProcedureException;
import org.apache.hadoop.hbase.procedure2.store.ProcedureStore;
import org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ProcedureProtos;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.NonceKey;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class Procedure<TEnvironment>
implements Comparable<Procedure<TEnvironment>> {
    private static final Logger LOG = LoggerFactory.getLogger(Procedure.class);
    public static final long NO_PROC_ID = -1L;
    protected static final int NO_TIMEOUT = -1;
    private NonceKey nonceKey = null;
    private String owner = null;
    private long parentProcId = -1L;
    private long rootProcId = -1L;
    private long procId = -1L;
    private long submittedTime;
    private ProcedureProtos.ProcedureState state = ProcedureProtos.ProcedureState.INITIALIZING;
    private RemoteProcedureException exception = null;
    private int[] stackIndexes = null;
    private int childrenLatch = 0;
    private boolean wasExecuted;
    private volatile int timeout = -1;
    private volatile long lastUpdate;
    private volatile byte[] result = null;
    private volatile boolean locked = false;
    private boolean lockedWhenLoading = false;
    private volatile boolean bypass = false;
    private boolean persist = true;

    public boolean isBypass() {
        return this.bypass;
    }

    protected void bypass(TEnvironment env) {
        this.bypass = true;
    }

    boolean needPersistence() {
        return this.persist;
    }

    void resetPersistence() {
        this.persist = true;
    }

    protected final void skipPersistence() {
        this.persist = false;
    }

    protected abstract Procedure<TEnvironment>[] execute(TEnvironment var1) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException;

    protected abstract void rollback(TEnvironment var1) throws IOException, InterruptedException;

    protected abstract boolean abort(TEnvironment var1);

    protected abstract void serializeStateData(ProcedureStateSerializer var1) throws IOException;

    protected abstract void deserializeStateData(ProcedureStateSerializer var1) throws IOException;

    protected boolean waitInitialized(TEnvironment env) {
        return false;
    }

    protected LockState acquireLock(TEnvironment env) {
        return LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(TEnvironment env) {
    }

    protected boolean holdLock(TEnvironment env) {
        return false;
    }

    public final boolean hasLock() {
        return this.locked;
    }

    protected void beforeReplay(TEnvironment env) {
    }

    protected void afterReplay(TEnvironment env) {
    }

    protected void completionCleanup(TEnvironment env) {
    }

    protected boolean isYieldAfterExecutionStep(TEnvironment env) {
        return false;
    }

    protected boolean shouldWaitClientAck(TEnvironment env) {
        return true;
    }

    protected ProcedureMetrics getProcedureMetrics(TEnvironment env) {
        return null;
    }

    protected void updateMetricsOnSubmit(TEnvironment env) {
        ProcedureMetrics metrics = this.getProcedureMetrics(env);
        if (metrics == null) {
            return;
        }
        Counter submittedCounter = metrics.getSubmittedCounter();
        if (submittedCounter != null) {
            submittedCounter.increment();
        }
    }

    protected void updateMetricsOnFinish(TEnvironment env, long runtime, boolean success) {
        ProcedureMetrics metrics = this.getProcedureMetrics(env);
        if (metrics == null) {
            return;
        }
        if (success) {
            Histogram timeHisto = metrics.getTimeHisto();
            if (timeHisto != null) {
                timeHisto.update(runtime);
            }
        } else {
            Counter failedCounter = metrics.getFailedCounter();
            if (failedCounter != null) {
                failedCounter.increment();
            }
        }
    }

    public String toString() {
        return this.toStringSimpleSB().toString();
    }

    protected StringBuilder toStringSimpleSB() {
        StringBuilder sb = new StringBuilder();
        sb.append("pid=");
        sb.append(this.getProcId());
        if (this.hasParent()) {
            sb.append(", ppid=");
            sb.append(this.getParentProcId());
        }
        sb.append(", state=");
        this.toStringState(sb);
        if (this.locked) {
            sb.append(", locked=").append(this.locked);
        }
        if (this.bypass) {
            sb.append(", bypass=").append(this.bypass);
        }
        if (this.hasException()) {
            sb.append(", exception=" + (Object)((Object)this.getException()));
        }
        sb.append("; ");
        this.toStringClassDetails(sb);
        return sb;
    }

    public String toStringDetails() {
        StringBuilder sb = this.toStringSimpleSB();
        sb.append(" submittedTime=");
        sb.append(this.getSubmittedTime());
        sb.append(", lastUpdate=");
        sb.append(this.getLastUpdate());
        int[] stackIndices = this.getStackIndexes();
        if (stackIndices != null) {
            sb.append("\n");
            sb.append("stackIndexes=");
            sb.append(Arrays.toString(stackIndices));
        }
        return sb.toString();
    }

    protected String toStringClass() {
        StringBuilder sb = new StringBuilder();
        this.toStringClassDetails(sb);
        return sb.toString();
    }

    protected void toStringState(StringBuilder builder) {
        builder.append(this.getState());
    }

    protected void toStringClassDetails(StringBuilder builder) {
        builder.append(this.getClass().getName());
    }

    public long getProcId() {
        return this.procId;
    }

    public boolean hasParent() {
        return this.parentProcId != -1L;
    }

    public long getParentProcId() {
        return this.parentProcId;
    }

    public long getRootProcId() {
        return this.rootProcId;
    }

    public String getProcName() {
        return this.toStringClass();
    }

    public NonceKey getNonceKey() {
        return this.nonceKey;
    }

    public long getSubmittedTime() {
        return this.submittedTime;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    protected void setProcId(long procId) {
        this.procId = procId;
        this.submittedTime = EnvironmentEdgeManager.currentTime();
        this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
    }

    protected void setParentProcId(long parentProcId) {
        this.parentProcId = parentProcId;
    }

    protected void setRootProcId(long rootProcId) {
        this.rootProcId = rootProcId;
    }

    protected void setNonceKey(NonceKey nonceKey) {
        this.nonceKey = nonceKey;
    }

    public void setOwner(String owner) {
        this.owner = StringUtils.isEmpty(owner) ? null : owner;
    }

    public void setOwner(User owner) {
        assert (owner != null) : "expected owner to be not null";
        this.setOwner(owner.getShortName());
    }

    protected void setSubmittedTime(long submittedTime) {
        this.submittedTime = submittedTime;
    }

    protected void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public boolean hasTimeout() {
        return this.timeout != -1;
    }

    public int getTimeout() {
        return this.timeout;
    }

    protected void setLastUpdate(long lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    protected void updateTimestamp() {
        this.lastUpdate = EnvironmentEdgeManager.currentTime();
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    protected long getTimeoutTimestamp() {
        return this.getLastUpdate() + (long)this.getTimeout();
    }

    public long elapsedTime() {
        return this.getLastUpdate() - this.getSubmittedTime();
    }

    public byte[] getResult() {
        return this.result;
    }

    protected void setResult(byte[] result) {
        this.result = result;
    }

    final void lockedWhenLoading() {
        this.lockedWhenLoading = true;
    }

    public boolean isLockedWhenLoading() {
        return this.lockedWhenLoading;
    }

    public synchronized boolean isRunnable() {
        return this.state == ProcedureProtos.ProcedureState.RUNNABLE;
    }

    public synchronized boolean isInitializing() {
        return this.state == ProcedureProtos.ProcedureState.INITIALIZING;
    }

    public synchronized boolean isFailed() {
        return this.state == ProcedureProtos.ProcedureState.FAILED || this.state == ProcedureProtos.ProcedureState.ROLLEDBACK;
    }

    public synchronized boolean isSuccess() {
        return this.state == ProcedureProtos.ProcedureState.SUCCESS && !this.hasException();
    }

    public synchronized boolean isFinished() {
        return this.isSuccess() || this.state == ProcedureProtos.ProcedureState.ROLLEDBACK;
    }

    public synchronized boolean isWaiting() {
        switch (this.state) {
            case WAITING: 
            case WAITING_TIMEOUT: {
                return true;
            }
        }
        return false;
    }

    protected synchronized void setState(ProcedureProtos.ProcedureState state) {
        this.state = state;
        this.updateTimestamp();
    }

    public synchronized ProcedureProtos.ProcedureState getState() {
        return this.state;
    }

    protected void setFailure(String source, Throwable cause) {
        this.setFailure(new RemoteProcedureException(source, cause));
    }

    protected synchronized void setFailure(RemoteProcedureException exception) {
        this.exception = exception;
        if (!this.isFinished()) {
            this.setState(ProcedureProtos.ProcedureState.FAILED);
        }
    }

    protected void setAbortFailure(String source, String msg) {
        this.setFailure(source, (Throwable)((Object)new ProcedureAbortedException(msg)));
    }

    protected synchronized boolean setTimeoutFailure(TEnvironment env) {
        if (this.state == ProcedureProtos.ProcedureState.WAITING_TIMEOUT) {
            long timeDiff = EnvironmentEdgeManager.currentTime() - this.lastUpdate;
            this.setFailure("ProcedureExecutor", (Throwable)new TimeoutIOException("Operation timed out after " + StringUtils.humanTimeDiff(timeDiff)));
            return true;
        }
        return false;
    }

    public synchronized boolean hasException() {
        return this.exception != null;
    }

    public synchronized RemoteProcedureException getException() {
        return this.exception;
    }

    protected synchronized void setChildrenLatch(int numChildren) {
        this.childrenLatch = numChildren;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH INCREMENT SET " + this.childrenLatch, new Throwable(this.toString()));
        }
    }

    protected synchronized void incChildrenLatch() {
        ++this.childrenLatch;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH INCREMENT " + this.childrenLatch, new Throwable(this.toString()));
        }
    }

    private synchronized boolean childrenCountDown() {
        boolean b;
        assert (this.childrenLatch > 0) : this;
        boolean bl = b = --this.childrenLatch == 0;
        if (LOG.isTraceEnabled()) {
            LOG.trace("CHILD LATCH DECREMENT " + this.childrenLatch, new Throwable(this.toString()));
        }
        return b;
    }

    synchronized boolean tryRunnable() {
        if (this.getState() == ProcedureProtos.ProcedureState.WAITING && this.childrenCountDown()) {
            this.setState(ProcedureProtos.ProcedureState.RUNNABLE);
            return true;
        }
        return false;
    }

    protected synchronized boolean hasChildren() {
        return this.childrenLatch > 0;
    }

    protected synchronized int getChildrenLatch() {
        return this.childrenLatch;
    }

    protected synchronized void addStackIndex(int index) {
        if (this.stackIndexes == null) {
            this.stackIndexes = new int[]{index};
        } else {
            int count = this.stackIndexes.length;
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, count + 1);
            this.stackIndexes[count] = index;
        }
        this.wasExecuted = true;
    }

    protected synchronized boolean removeStackIndex() {
        if (this.stackIndexes != null && this.stackIndexes.length > 1) {
            this.stackIndexes = Arrays.copyOf(this.stackIndexes, this.stackIndexes.length - 1);
            return false;
        }
        this.stackIndexes = null;
        return true;
    }

    protected synchronized void setStackIndexes(List<Integer> stackIndexes) {
        this.stackIndexes = new int[stackIndexes.size()];
        for (int i = 0; i < this.stackIndexes.length; ++i) {
            this.stackIndexes[i] = stackIndexes.get(i);
        }
        this.wasExecuted = true;
    }

    protected synchronized void setExecuted() {
        this.wasExecuted = true;
    }

    public synchronized boolean wasExecuted() {
        return this.wasExecuted;
    }

    protected synchronized int[] getStackIndexes() {
        return this.stackIndexes;
    }

    protected boolean isRollbackSupported() {
        return true;
    }

    protected Procedure<TEnvironment>[] doExecute(TEnvironment env) throws ProcedureYieldException, ProcedureSuspendedException, InterruptedException {
        try {
            this.updateTimestamp();
            if (this.bypass) {
                LOG.info("{} bypassed, returning null to finish it", (Object)this);
                Procedure<TEnvironment>[] procedureArray = null;
                return procedureArray;
            }
            Procedure<TEnvironment>[] procedureArray = this.execute(env);
            return procedureArray;
        }
        finally {
            this.updateTimestamp();
        }
    }

    protected void doRollback(TEnvironment env) throws IOException, InterruptedException {
        try {
            this.updateTimestamp();
            if (this.bypass) {
                LOG.info("{} bypassed, skipping rollback", (Object)this);
                return;
            }
            this.rollback(env);
        }
        finally {
            this.updateTimestamp();
        }
    }

    final void restoreLock(TEnvironment env) {
        if (!this.lockedWhenLoading) {
            LOG.debug("{} didn't hold the lock before restarting, skip acquiring lock.", (Object)this);
            return;
        }
        if (this.isFinished()) {
            LOG.debug("{} is already finished, skip acquiring lock.", (Object)this);
            return;
        }
        if (this.isBypass()) {
            LOG.debug("{} is already bypassed, skip acquiring lock.", (Object)this);
            return;
        }
        if (this.getState() == ProcedureProtos.ProcedureState.WAITING && !this.holdLock(env)) {
            LOG.debug("{} is in WAITING STATE, and holdLock=false, skip acquiring lock.", (Object)this);
            this.lockedWhenLoading = false;
            return;
        }
        LOG.debug("{} held the lock before restarting, call acquireLock to restore it.", (Object)this);
        LockState state = this.acquireLock(env);
        assert (state == LockState.LOCK_ACQUIRED);
    }

    final LockState doAcquireLock(TEnvironment env, ProcedureStore store) {
        if (this.waitInitialized(env)) {
            return LockState.LOCK_EVENT_WAIT;
        }
        if (this.lockedWhenLoading) {
            this.lockedWhenLoading = false;
            this.locked = true;
            return LockState.LOCK_ACQUIRED;
        }
        LockState state = this.acquireLock(env);
        if (state == LockState.LOCK_ACQUIRED) {
            this.locked = true;
            store.update(this);
        }
        return state;
    }

    final void doReleaseLock(TEnvironment env, ProcedureStore store) {
        this.locked = false;
        if (this.getState() != ProcedureProtos.ProcedureState.ROLLEDBACK) {
            store.update(this);
        }
        this.releaseLock(env);
    }

    protected final ProcedureSuspendedException suspend(int timeoutMillis, boolean jitter) throws ProcedureSuspendedException {
        if (jitter) {
            double add = (double)timeoutMillis * ThreadLocalRandom.current().nextDouble(0.1);
            timeoutMillis = (int)((double)timeoutMillis + add);
        }
        this.setTimeout(timeoutMillis);
        this.setState(ProcedureProtos.ProcedureState.WAITING_TIMEOUT);
        this.skipPersistence();
        throw new ProcedureSuspendedException();
    }

    @Override
    public int compareTo(Procedure<TEnvironment> other) {
        return Long.compare(this.getProcId(), other.getProcId());
    }

    public static long getProcIdHashCode(long procId) {
        long h = procId;
        h ^= h >> 16;
        h *= -2048144789L;
        h ^= h >> 13;
        h *= -1028477387L;
        h ^= h >> 16;
        return h;
    }

    protected static <T> Long getRootProcedureId(Map<Long, Procedure<T>> procedures, Procedure<T> proc) {
        while (proc.hasParent()) {
            if ((proc = procedures.get(proc.getParentProcId())) != null) continue;
            return null;
        }
        return proc.getProcId();
    }

    public static boolean haveSameParent(Procedure<?> a, Procedure<?> b) {
        return a.hasParent() && b.hasParent() && a.getParentProcId() == b.getParentProcId();
    }

    public static enum LockState {
        LOCK_ACQUIRED,
        LOCK_YIELD_WAIT,
        LOCK_EVENT_WAIT;

    }
}

