/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ErrorHandlingProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ForeignExceptionUtil {
    private ForeignExceptionUtil() {
    }

    public static Exception toException(ErrorHandlingProtos.ForeignExceptionMessage eem) {
        Exception re;
        try {
            re = ForeignExceptionUtil.createException(Exception.class, eem);
        }
        catch (Throwable e) {
            re = new Exception(eem.getGenericException().getMessage());
        }
        return ForeignExceptionUtil.setExceptionDetails(re, eem);
    }

    public static IOException toIOException(ErrorHandlingProtos.ForeignExceptionMessage eem) {
        IOException re;
        try {
            re = ForeignExceptionUtil.createException(IOException.class, eem);
        }
        catch (Throwable e) {
            re = new IOException(eem.getGenericException().getMessage());
        }
        return ForeignExceptionUtil.setExceptionDetails(re, eem);
    }

    private static <T extends Exception> T createException(Class<T> clazz, ErrorHandlingProtos.ForeignExceptionMessage eem) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        ErrorHandlingProtos.GenericExceptionMessage gem = eem.getGenericException();
        Class<?> realClass = Class.forName(gem.getClassName());
        Class<T> cls = realClass.asSubclass(clazz);
        Constructor<T> cn = cls.getConstructor(String.class);
        cn.setAccessible(true);
        return (T)((Exception)cn.newInstance(gem.getMessage()));
    }

    private static <T extends Exception> T setExceptionDetails(T exception, ErrorHandlingProtos.ForeignExceptionMessage eem) {
        ErrorHandlingProtos.GenericExceptionMessage gem = eem.getGenericException();
        StackTraceElement[] trace = ForeignExceptionUtil.toStackTrace(gem.getTraceList());
        exception.setStackTrace(trace);
        return exception;
    }

    public static ErrorHandlingProtos.ForeignExceptionMessage toProtoForeignException(Throwable t) {
        return ForeignExceptionUtil.toProtoForeignException(null, t);
    }

    public static ErrorHandlingProtos.ForeignExceptionMessage toProtoForeignException(String source, Throwable t) {
        List<ErrorHandlingProtos.StackTraceElementMessage> stack;
        ErrorHandlingProtos.GenericExceptionMessage.Builder gemBuilder = ErrorHandlingProtos.GenericExceptionMessage.newBuilder();
        gemBuilder.setClassName(t.getClass().getName());
        if (t.getMessage() != null) {
            gemBuilder.setMessage(t.getMessage());
        }
        if ((stack = ForeignExceptionUtil.toProtoStackTraceElement(t.getStackTrace())) != null) {
            gemBuilder.addAllTrace(stack);
        }
        ErrorHandlingProtos.GenericExceptionMessage payload = gemBuilder.build();
        ErrorHandlingProtos.ForeignExceptionMessage.Builder exception = ErrorHandlingProtos.ForeignExceptionMessage.newBuilder();
        exception.setGenericException(payload);
        if (source != null) {
            exception.setSource(source);
        }
        return exception.build();
    }

    public static List<ErrorHandlingProtos.StackTraceElementMessage> toProtoStackTraceElement(StackTraceElement[] trace) {
        if (trace == null) {
            return null;
        }
        ArrayList<ErrorHandlingProtos.StackTraceElementMessage> pbTrace = new ArrayList<ErrorHandlingProtos.StackTraceElementMessage>(trace.length);
        for (StackTraceElement elem : trace) {
            ErrorHandlingProtos.StackTraceElementMessage.Builder stackBuilder = ErrorHandlingProtos.StackTraceElementMessage.newBuilder();
            stackBuilder.setDeclaringClass(elem.getClassName());
            if (elem.getFileName() != null) {
                stackBuilder.setFileName(elem.getFileName());
            }
            stackBuilder.setLineNumber(elem.getLineNumber());
            stackBuilder.setMethodName(elem.getMethodName());
            pbTrace.add(stackBuilder.build());
        }
        return pbTrace;
    }

    public static StackTraceElement[] toStackTrace(List<ErrorHandlingProtos.StackTraceElementMessage> traceList) {
        if (traceList == null || traceList.isEmpty()) {
            return new StackTraceElement[0];
        }
        StackTraceElement[] trace = new StackTraceElement[traceList.size()];
        for (int i = 0; i < traceList.size(); ++i) {
            ErrorHandlingProtos.StackTraceElementMessage elem = traceList.get(i);
            trace[i] = new StackTraceElement(elem.getDeclaringClass(), elem.getMethodName(), elem.hasFileName() ? elem.getFileName() : null, elem.getLineNumber());
        }
        return trace;
    }
}

