/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationGroupOffset;
import org.apache.hadoop.hbase.replication.ReplicationQueueData;
import org.apache.hadoop.hbase.replication.ReplicationQueueId;
import org.apache.hadoop.hbase.replication.ZKReplicationQueueStorageForMigration;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public interface ReplicationQueueStorage {
    public void setOffset(ReplicationQueueId var1, String var2, ReplicationGroupOffset var3, Map<String, Long> var4) throws ReplicationException;

    public Map<String, ReplicationGroupOffset> getOffsets(ReplicationQueueId var1) throws ReplicationException;

    public List<ReplicationQueueId> listAllQueueIds(String var1) throws ReplicationException;

    public List<ReplicationQueueId> listAllQueueIds(ServerName var1) throws ReplicationException;

    public List<ReplicationQueueId> listAllQueueIds(String var1, ServerName var2) throws ReplicationException;

    public List<ReplicationQueueData> listAllQueues() throws ReplicationException;

    public List<ServerName> listAllReplicators() throws ReplicationException;

    public Map<String, ReplicationGroupOffset> claimQueue(ReplicationQueueId var1, ServerName var2) throws ReplicationException;

    public void removeQueue(ReplicationQueueId var1) throws ReplicationException;

    public void removeAllQueues(String var1) throws ReplicationException;

    public long getLastSequenceId(String var1, String var2) throws ReplicationException;

    public void setLastSequenceIds(String var1, Map<String, Long> var2) throws ReplicationException;

    public void removeLastSequenceIds(String var1) throws ReplicationException;

    public void removeLastSequenceIds(String var1, List<String> var2) throws ReplicationException;

    public void removePeerFromHFileRefs(String var1) throws ReplicationException;

    public void addHFileRefs(String var1, List<Pair<Path, Path>> var2) throws ReplicationException;

    public void removeHFileRefs(String var1, List<String> var2) throws ReplicationException;

    public List<String> getAllPeersFromHFileRefsQueue() throws ReplicationException;

    public List<String> getReplicableHFiles(String var1) throws ReplicationException;

    public Set<String> getAllHFileRefs() throws ReplicationException;

    public boolean hasData() throws ReplicationException;

    public void batchUpdateQueues(ServerName var1, List<ReplicationQueueData> var2) throws ReplicationException;

    public void batchUpdateLastSequenceIds(List<ZKReplicationQueueStorageForMigration.ZkLastPushedSeqId> var1) throws ReplicationException;

    public void batchUpdateHFileRefs(String var1, List<String> var2) throws ReplicationException;

    public void removeLastSequenceIdsAndHFileRefsBefore(long var1) throws ReplicationException;
}

