/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.rest.NamespacesInstanceResource;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.model.NamespacesModel;

@InterfaceAudience.Private
public class NamespacesResource
extends ResourceBase {
    private static final Log LOG = LogFactory.getLog(NamespacesResource.class);

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/protobuf"})
    public Response get(@Context ServletContext context, @Context UriInfo uriInfo) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("GET " + uriInfo.getAbsolutePath()));
        }
        this.servlet.getMetrics().incrementRequests(1);
        try {
            NamespacesModel rowModel = null;
            rowModel = new NamespacesModel(this.servlet.getAdmin());
            this.servlet.getMetrics().incrementSucessfulGetRequests(1);
            return Response.ok((Object)rowModel).build();
        }
        catch (IOException e) {
            this.servlet.getMetrics().incrementFailedGetRequests(1);
            throw new RuntimeException("Cannot retrieve list of namespaces.");
        }
    }

    @Path(value="{namespace}")
    public NamespacesInstanceResource getNamespaceInstanceResource(@PathParam(value="namespace") String namespace) throws IOException {
        return new NamespacesInstanceResource(namespace);
    }
}

